/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class JobStatus
implements Writable,
Cloneable {
    private JobID jobid;
    private float mapProgress;
    private float reduceProgress;
    private float cleanupProgress;
    private float setupProgress;
    private State runState;
    private long startTime;
    private String user;
    private String queue;
    private JobPriority priority;
    private String schedulingInfo = "NA";
    private String failureInfo = "NA";
    private Map<JobACL, AccessControlList> jobACLs = new HashMap<JobACL, AccessControlList>();
    private String jobName;
    private String jobFile;
    private long finishTime;
    private boolean isRetired;
    private String historyFile = "";
    private String trackingUrl = "";
    private int numUsedSlots;
    private int numReservedSlots;
    private int usedMem;
    private int reservedMem;
    private int neededMem;
    private boolean isUber;

    public JobStatus() {
    }

    public JobStatus(JobID jobid, float setupProgress, float mapProgress, float reduceProgress, float cleanupProgress, State runState, JobPriority jp, String user, String jobName, String jobFile, String trackingUrl) {
        this(jobid, setupProgress, mapProgress, reduceProgress, cleanupProgress, runState, jp, user, jobName, "default", jobFile, trackingUrl, false);
    }

    public JobStatus(JobID jobid, float setupProgress, float mapProgress, float reduceProgress, float cleanupProgress, State runState, JobPriority jp, String user, String jobName, String queue, String jobFile, String trackingUrl) {
        this(jobid, setupProgress, mapProgress, reduceProgress, cleanupProgress, runState, jp, user, jobName, queue, jobFile, trackingUrl, false);
    }

    public JobStatus(JobID jobid, float setupProgress, float mapProgress, float reduceProgress, float cleanupProgress, State runState, JobPriority jp, String user, String jobName, String queue, String jobFile, String trackingUrl, boolean isUber) {
        this(jobid, setupProgress, mapProgress, reduceProgress, cleanupProgress, runState, jp, user, jobName, queue, jobFile, trackingUrl, isUber, "");
    }

    public JobStatus(JobID jobid, float setupProgress, float mapProgress, float reduceProgress, float cleanupProgress, State runState, JobPriority jp, String user, String jobName, String queue, String jobFile, String trackingUrl, boolean isUber, String historyFile) {
        this.jobid = jobid;
        this.setupProgress = setupProgress;
        this.mapProgress = mapProgress;
        this.reduceProgress = reduceProgress;
        this.cleanupProgress = cleanupProgress;
        this.runState = runState;
        this.user = user;
        this.queue = queue;
        if (jp == null) {
            throw new IllegalArgumentException("Job Priority cannot be null.");
        }
        this.priority = jp;
        this.jobName = jobName;
        this.jobFile = jobFile;
        this.trackingUrl = trackingUrl;
        this.isUber = isUber;
        this.historyFile = historyFile;
    }

    protected synchronized void setMapProgress(float p) {
        this.mapProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    protected synchronized void setCleanupProgress(float p) {
        this.cleanupProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    protected synchronized void setSetupProgress(float p) {
        this.setupProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    protected synchronized void setReduceProgress(float p) {
        this.reduceProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    protected synchronized void setPriority(JobPriority jp) {
        if (jp == null) {
            throw new IllegalArgumentException("Job priority cannot be null.");
        }
        this.priority = jp;
    }

    protected synchronized void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    protected synchronized void setHistoryFile(String historyFile) {
        this.historyFile = historyFile;
    }

    protected synchronized void setTrackingUrl(String trackingUrl) {
        this.trackingUrl = trackingUrl;
    }

    protected synchronized void setRetired() {
        this.isRetired = true;
    }

    protected synchronized void setState(State state) {
        this.runState = state;
    }

    protected synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected synchronized void setUsername(String userName) {
        this.user = userName;
    }

    protected synchronized void setSchedulingInfo(String schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
    }

    protected synchronized void setJobACLs(Map<JobACL, AccessControlList> acls) {
        this.jobACLs = acls;
    }

    protected synchronized void setQueue(String queue) {
        this.queue = queue;
    }

    protected synchronized void setFailureInfo(String failureInfo) {
        this.failureInfo = failureInfo;
    }

    public synchronized String getQueue() {
        return this.queue;
    }

    public synchronized float getMapProgress() {
        return this.mapProgress;
    }

    public synchronized float getCleanupProgress() {
        return this.cleanupProgress;
    }

    public synchronized float getSetupProgress() {
        return this.setupProgress;
    }

    public synchronized float getReduceProgress() {
        return this.reduceProgress;
    }

    public synchronized State getState() {
        return this.runState;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
    }

    public JobID getJobID() {
        return this.jobid;
    }

    public synchronized String getUsername() {
        return this.user;
    }

    public synchronized String getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public synchronized Map<JobACL, AccessControlList> getJobACLs() {
        return this.jobACLs;
    }

    public synchronized JobPriority getPriority() {
        return this.priority;
    }

    public synchronized String getFailureInfo() {
        return this.failureInfo;
    }

    public synchronized boolean isJobComplete() {
        return this.runState == State.SUCCEEDED || this.runState == State.FAILED || this.runState == State.KILLED;
    }

    public synchronized void write(DataOutput out) throws IOException {
        this.jobid.write(out);
        out.writeFloat(this.setupProgress);
        out.writeFloat(this.mapProgress);
        out.writeFloat(this.reduceProgress);
        out.writeFloat(this.cleanupProgress);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.runState);
        out.writeLong(this.startTime);
        Text.writeString((DataOutput)out, (String)this.user);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.priority);
        Text.writeString((DataOutput)out, (String)this.schedulingInfo);
        out.writeLong(this.finishTime);
        out.writeBoolean(this.isRetired);
        Text.writeString((DataOutput)out, (String)this.historyFile);
        Text.writeString((DataOutput)out, (String)this.jobName);
        Text.writeString((DataOutput)out, (String)this.trackingUrl);
        Text.writeString((DataOutput)out, (String)this.jobFile);
        out.writeBoolean(this.isUber);
        out.writeInt(this.jobACLs.size());
        for (Map.Entry<JobACL, AccessControlList> entry : this.jobACLs.entrySet()) {
            WritableUtils.writeEnum((DataOutput)out, (Enum)entry.getKey());
            entry.getValue().write(out);
        }
    }

    public synchronized void readFields(DataInput in) throws IOException {
        this.jobid = new JobID();
        this.jobid.readFields(in);
        this.setupProgress = in.readFloat();
        this.mapProgress = in.readFloat();
        this.reduceProgress = in.readFloat();
        this.cleanupProgress = in.readFloat();
        this.runState = (State)WritableUtils.readEnum((DataInput)in, State.class);
        this.startTime = in.readLong();
        this.user = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.priority = (JobPriority)WritableUtils.readEnum((DataInput)in, JobPriority.class);
        this.schedulingInfo = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.finishTime = in.readLong();
        this.isRetired = in.readBoolean();
        this.historyFile = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.jobName = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.trackingUrl = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.jobFile = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.isUber = in.readBoolean();
        int numACLs = in.readInt();
        for (int i = 0; i < numACLs; ++i) {
            JobACL aclType = (JobACL)WritableUtils.readEnum((DataInput)in, JobACL.class);
            AccessControlList acl = new AccessControlList(" ");
            acl.readFields(in);
            this.jobACLs.put(aclType, acl);
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public synchronized String getTrackingUrl() {
        return this.trackingUrl;
    }

    public synchronized long getFinishTime() {
        return this.finishTime;
    }

    public synchronized boolean isRetired() {
        return this.isRetired;
    }

    public synchronized String getHistoryFile() {
        return this.historyFile;
    }

    public int getNumUsedSlots() {
        return this.numUsedSlots;
    }

    public void setNumUsedSlots(int n) {
        this.numUsedSlots = n;
    }

    public int getNumReservedSlots() {
        return this.numReservedSlots;
    }

    public void setNumReservedSlots(int n) {
        this.numReservedSlots = n;
    }

    public int getUsedMem() {
        return this.usedMem;
    }

    public void setUsedMem(int m) {
        this.usedMem = m;
    }

    public int getReservedMem() {
        return this.reservedMem;
    }

    public void setReservedMem(int r) {
        this.reservedMem = r;
    }

    public int getNeededMem() {
        return this.neededMem;
    }

    public void setNeededMem(int n) {
        this.neededMem = n;
    }

    public synchronized boolean isUber() {
        return this.isUber;
    }

    public synchronized void setUber(boolean isUber) {
        this.isUber = isUber;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("job-id : " + this.jobid);
        buffer.append("uber-mode : " + this.isUber);
        buffer.append("map-progress : " + this.mapProgress);
        buffer.append("reduce-progress : " + this.reduceProgress);
        buffer.append("cleanup-progress : " + this.cleanupProgress);
        buffer.append("setup-progress : " + this.setupProgress);
        buffer.append("runstate : " + this.runState);
        buffer.append("start-time : " + this.startTime);
        buffer.append("user-name : " + this.user);
        buffer.append("priority : " + this.priority);
        buffer.append("scheduling-info : " + this.schedulingInfo);
        buffer.append("num-used-slots" + this.numUsedSlots);
        buffer.append("num-reserved-slots" + this.numReservedSlots);
        buffer.append("used-mem" + this.usedMem);
        buffer.append("reserved-mem" + this.reservedMem);
        buffer.append("needed-mem" + this.neededMem);
        return buffer.toString();
    }

    static {
        WritableFactories.setFactory(JobStatus.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new JobStatus();
            }
        });
    }

    public static enum State {
        RUNNING(1),
        SUCCEEDED(2),
        FAILED(3),
        PREP(4),
        KILLED(5);

        int value;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

