/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanupQueue {
    public static final Logger LOG = LoggerFactory.getLogger(CleanupQueue.class);
    private static PathCleanupThread cleanupThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CleanupQueue() {
        Class<PathCleanupThread> clazz = PathCleanupThread.class;
        synchronized (PathCleanupThread.class) {
            if (cleanupThread == null) {
                cleanupThread = new PathCleanupThread();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void addToQueue(PathDeletionContext ... contexts) {
        cleanupThread.addToQueue(contexts);
    }

    protected static boolean deletePath(PathDeletionContext context) throws IOException {
        context.enablePathForCleanup();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to delete " + context.fullPath);
        }
        if (context.fs.exists(new Path(context.fullPath))) {
            return context.fs.delete(new Path(context.fullPath), true);
        }
        return true;
    }

    protected boolean isQueueEmpty() {
        return CleanupQueue.cleanupThread.queue.size() == 0;
    }

    private static class PathCleanupThread
    extends Thread {
        private LinkedBlockingQueue<PathDeletionContext> queue = new LinkedBlockingQueue();

        public PathCleanupThread() {
            this.setName("Directory/File cleanup thread");
            this.setDaemon(true);
            this.start();
        }

        void addToQueue(PathDeletionContext[] contexts) {
            for (PathDeletionContext context : contexts) {
                try {
                    this.queue.put(context);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getName() + " started.");
            }
            PathDeletionContext context = null;
            while (true) {
                try {
                    while (true) {
                        if (!CleanupQueue.deletePath(context = this.queue.take())) {
                            LOG.warn("CleanupThread:Unable to delete path " + context.fullPath);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("DELETED " + context.fullPath);
                    }
                }
                catch (InterruptedException t) {
                    if (context == null) {
                        LOG.warn("Interrupted deletion of an invalid path: Path deletion context is null.");
                    } else {
                        LOG.warn("Interrupted deletion of " + context.fullPath);
                    }
                    return;
                }
                catch (Exception e) {
                    LOG.warn("Error deleting path " + context.fullPath + ": " + e);
                    continue;
                }
                break;
            }
        }
    }

    static class PathDeletionContext {
        String fullPath;
        FileSystem fs;

        public PathDeletionContext(FileSystem fs, String fullPath) {
            this.fs = fs;
            this.fullPath = fullPath;
        }

        protected String getPathForCleanup() {
            return this.fullPath;
        }

        protected void enablePathForCleanup() throws IOException {
        }
    }
}

