/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCLI {
    private static String jobIdStr = "job_1015298225799_0015";

    @Test
    public void testListAttemptIdsWithValidInput() throws Exception {
        JobID jobId = JobID.forName((String)jobIdStr);
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        Job job = (Job)Mockito.mock(Job.class);
        CLI cli = (CLI)Mockito.spy((Object)new CLI(new Configuration()));
        ((CLI)Mockito.doReturn((Object)mockCluster).when((Object)cli)).createCluster();
        Mockito.when((Object)job.getTaskReports(TaskType.MAP)).thenReturn((Object)this.getTaskReports(jobId, TaskType.MAP));
        Mockito.when((Object)job.getTaskReports(TaskType.REDUCE)).thenReturn((Object)this.getTaskReports(jobId, TaskType.REDUCE));
        Mockito.when((Object)mockCluster.getJob(jobId)).thenReturn((Object)job);
        int retCode_MAP = cli.run(new String[]{"-list-attempt-ids", jobIdStr, "MAP", "running"});
        int retCode_map = cli.run(new String[]{"-list-attempt-ids", jobIdStr, "map", "running"});
        int retCode_REDUCE = cli.run(new String[]{"-list-attempt-ids", jobIdStr, "REDUCE", "running"});
        int retCode_completed = cli.run(new String[]{"-list-attempt-ids", jobIdStr, "REDUCE", "completed"});
        Assertions.assertEquals((int)0, (int)retCode_MAP, (String)"MAP is a valid input,exit code should be 0");
        Assertions.assertEquals((int)0, (int)retCode_map, (String)"map is a valid input,exit code should be 0");
        Assertions.assertEquals((int)0, (int)retCode_REDUCE, (String)"REDUCE is a valid input,exit code should be 0");
        Assertions.assertEquals((int)0, (int)retCode_completed, (String)"REDUCE and completed are a valid inputs to -list-attempt-ids,exit code should be 0");
        ((Job)Mockito.verify((Object)job, (VerificationMode)Mockito.times((int)2))).getTaskReports(TaskType.MAP);
        ((Job)Mockito.verify((Object)job, (VerificationMode)Mockito.times((int)2))).getTaskReports(TaskType.REDUCE);
    }

    @Test
    public void testListAttemptIdsWithInvalidInputs() throws Exception {
        JobID jobId = JobID.forName((String)jobIdStr);
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        Job job = (Job)Mockito.mock(Job.class);
        CLI cli = (CLI)Mockito.spy((Object)new CLI(new Configuration()));
        ((CLI)Mockito.doReturn((Object)mockCluster).when((Object)cli)).createCluster();
        Mockito.when((Object)mockCluster.getJob(jobId)).thenReturn((Object)job);
        int retCode_JOB_SETUP = cli.run(new String[]{"-list-attempt-ids", jobIdStr, "JOB_SETUP", "running"});
        int retCode_JOB_CLEANUP = cli.run(new String[]{"-list-attempt-ids", jobIdStr, "JOB_CLEANUP", "running"});
        int retCode_invalidTaskState = cli.run(new String[]{"-list-attempt-ids", jobIdStr, "REDUCE", "complete"});
        String jobIdStr2 = "job_1015298225799_0016";
        int retCode_invalidJobId = cli.run(new String[]{"-list-attempt-ids", jobIdStr2, "MAP", "running"});
        Assertions.assertEquals((int)-1, (int)retCode_JOB_SETUP, (String)"JOB_SETUP is an invalid input,exit code should be -1");
        Assertions.assertEquals((int)-1, (int)retCode_JOB_CLEANUP, (String)"JOB_CLEANUP is an invalid input,exit code should be -1");
        Assertions.assertEquals((int)-1, (int)retCode_invalidTaskState, (String)"complete is an invalid input,exit code should be -1");
        Assertions.assertEquals((int)-1, (int)retCode_invalidJobId, (String)"Non existing job id should be skipped with -1");
    }

    private TaskReport[] getTaskReports(JobID jobId, TaskType type) {
        return new TaskReport[]{new TaskReport(), new TaskReport()};
    }

    @Test
    public void testJobKIll() throws Exception {
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        CLI cli = (CLI)Mockito.spy((Object)new CLI(new Configuration()));
        ((CLI)Mockito.doReturn((Object)mockCluster).when((Object)cli)).createCluster();
        String jobId1 = "job_1234654654_001";
        String jobId2 = "job_1234654654_002";
        String jobId3 = "job_1234654654_003";
        String jobId4 = "job_1234654654_004";
        Job mockJob1 = this.mockJob(mockCluster, jobId1, JobStatus.State.RUNNING);
        Job mockJob2 = this.mockJob(mockCluster, jobId2, JobStatus.State.KILLED);
        Job mockJob3 = this.mockJob(mockCluster, jobId3, JobStatus.State.FAILED);
        Job mockJob4 = this.mockJob(mockCluster, jobId4, JobStatus.State.PREP);
        int exitCode1 = cli.run(new String[]{"-kill", jobId1});
        Assertions.assertEquals((int)0, (int)exitCode1);
        ((Job)Mockito.verify((Object)mockJob1, (VerificationMode)Mockito.times((int)1))).killJob();
        int exitCode2 = cli.run(new String[]{"-kill", jobId2});
        Assertions.assertEquals((int)-1, (int)exitCode2);
        ((Job)Mockito.verify((Object)mockJob2, (VerificationMode)Mockito.times((int)0))).killJob();
        int exitCode3 = cli.run(new String[]{"-kill", jobId3});
        Assertions.assertEquals((int)-1, (int)exitCode3);
        ((Job)Mockito.verify((Object)mockJob3, (VerificationMode)Mockito.times((int)0))).killJob();
        int exitCode4 = cli.run(new String[]{"-kill", jobId4});
        Assertions.assertEquals((int)0, (int)exitCode4);
        ((Job)Mockito.verify((Object)mockJob4, (VerificationMode)Mockito.times((int)1))).killJob();
    }

    private Job mockJob(Cluster mockCluster, String jobId, JobStatus.State jobState) throws IOException, InterruptedException {
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockCluster.getJob(JobID.forName((String)jobId))).thenReturn((Object)mockJob);
        JobStatus status = new JobStatus(null, 0.0f, 0.0f, 0.0f, 0.0f, jobState, JobPriority.HIGH, null, null, null, null);
        Mockito.when((Object)mockJob.getStatus()).thenReturn((Object)status);
        return mockJob;
    }

    @Test
    public void testGetJobWithoutRetry() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.app.mapreduce.client.job.max-retries", 0);
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)mockCluster.getJob((JobID)ArgumentMatchers.any(JobID.class))).thenReturn(null);
        CLI cli = new CLI(conf);
        cli.cluster = mockCluster;
        Job job = cli.getJob(JobID.forName((String)"job_1234654654_001"));
        Assertions.assertTrue((job == null ? 1 : 0) != 0, (String)"job is not null");
    }

    @Test
    public void testGetJobWithRetry() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.app.mapreduce.client.job.max-retries", 1);
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        Job mockJob = Job.getInstance((Configuration)conf);
        Mockito.when((Object)mockCluster.getJob((JobID)ArgumentMatchers.any(JobID.class))).thenReturn(null).thenReturn((Object)mockJob);
        CLI cli = new CLI(conf);
        cli.cluster = mockCluster;
        Job job = cli.getJob(JobID.forName((String)"job_1234654654_001"));
        Assertions.assertNotNull((Object)job, (String)"job is null");
    }

    @Test
    public void testListEvents() throws Exception {
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        CLI cli = (CLI)Mockito.spy((Object)new CLI(new Configuration()));
        ((CLI)Mockito.doReturn((Object)mockCluster).when((Object)cli)).createCluster();
        String jobId1 = "job_1234654654_001";
        String jobId2 = "job_1234654656_002";
        Job mockJob1 = this.mockJob(mockCluster, jobId1, JobStatus.State.RUNNING);
        int exitCode = cli.run(new String[]{"-events", jobId2, "0", "10"});
        Assertions.assertEquals((int)-1, (int)exitCode);
    }

    @Test
    public void testLogs() throws Exception {
        Cluster mockCluster = (Cluster)Mockito.mock(Cluster.class);
        CLI cli = (CLI)Mockito.spy((Object)new CLI(new Configuration()));
        ((CLI)Mockito.doReturn((Object)mockCluster).when((Object)cli)).createCluster();
        String jobId1 = "job_1234654654_001";
        String jobId2 = "job_1234654656_002";
        Job mockJob1 = this.mockJob(mockCluster, jobId1, JobStatus.State.SUCCEEDED);
        int exitCode = cli.run(new String[]{"-logs", jobId2});
        Assertions.assertEquals((int)-1, (int)exitCode);
    }
}

