/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleSchedulerImpl;
import org.apache.hadoop.util.Progress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestShuffleScheduler {
    @Test
    public void testTipFailed() throws Exception {
        JobConf job = new JobConf();
        job.setNumMapTasks(2);
        TaskStatus status = new TaskStatus(){

            public boolean getIsMap() {
                return false;
            }

            public void addFetchFailedMap(org.apache.hadoop.mapred.TaskAttemptID mapTaskId) {
            }
        };
        Progress progress = new Progress();
        org.apache.hadoop.mapred.TaskAttemptID reduceId = new org.apache.hadoop.mapred.TaskAttemptID("314159", 0, TaskType.REDUCE, 0, 0);
        ShuffleSchedulerImpl scheduler = new ShuffleSchedulerImpl(job, status, (TaskAttemptID)reduceId, null, progress, null, null, null);
        JobID jobId = new JobID();
        TaskID taskId1 = new TaskID(jobId, TaskType.REDUCE, 1);
        scheduler.tipFailed(taskId1);
        Assertions.assertEquals((float)0.5f, (float)progress.getProgress(), (float)0.0f, (String)"Progress should be 0.5");
        Assertions.assertFalse((boolean)scheduler.waitUntilDone(1));
        TaskID taskId0 = new TaskID(jobId, TaskType.REDUCE, 0);
        scheduler.tipFailed(taskId0);
        Assertions.assertEquals((float)1.0f, (float)progress.getProgress(), (float)0.0f, (String)"Progress should be 1.0");
        Assertions.assertTrue((boolean)scheduler.waitUntilDone(1));
    }

    @Test
    public <K, V> void TestAggregatedTransferRate() throws Exception {
        JobConf job = new JobConf();
        job.setNumMapTasks(10);
        TaskUmbilicalProtocol mockUmbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Reporter mockReporter = (Reporter)Mockito.mock(Reporter.class);
        FileSystem mockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Class combinerClass = job.getCombinerClass();
        Task.CombineOutputCollector mockCombineOutputCollector = (Task.CombineOutputCollector)Mockito.mock(Task.CombineOutputCollector.class);
        TaskAttemptID mockTaskAttemptID = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        LocalDirAllocator mockLocalDirAllocator = (LocalDirAllocator)Mockito.mock(LocalDirAllocator.class);
        CompressionCodec mockCompressionCodec = (CompressionCodec)Mockito.mock(CompressionCodec.class);
        Counters.Counter mockCounter = (Counters.Counter)Mockito.mock(Counters.Counter.class);
        TaskStatus mockTaskStatus = (TaskStatus)Mockito.mock(TaskStatus.class);
        Progress mockProgress = (Progress)Mockito.mock(Progress.class);
        MapOutputFile mockMapOutputFile = (MapOutputFile)Mockito.mock(MapOutputFile.class);
        Task mockTask = (Task)Mockito.mock(Task.class);
        MapOutput output = (MapOutput)Mockito.mock(MapOutput.class);
        ShuffleConsumerPlugin.Context context = new ShuffleConsumerPlugin.Context(mockTaskAttemptID, job, mockFileSystem, mockUmbilical, mockLocalDirAllocator, mockReporter, mockCompressionCodec, combinerClass, mockCombineOutputCollector, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockTaskStatus, mockProgress, mockProgress, mockTask, mockMapOutputFile, null);
        TaskStatus status = new TaskStatus(){

            public boolean getIsMap() {
                return false;
            }

            public void addFetchFailedMap(org.apache.hadoop.mapred.TaskAttemptID mapTaskId) {
            }
        };
        Progress progress = new Progress();
        ShuffleSchedulerImpl scheduler = new ShuffleSchedulerImpl(job, status, null, null, progress, context.getShuffledMapsCounter(), context.getReduceShuffleBytes(), context.getFailedShuffleCounter());
        org.apache.hadoop.mapred.TaskAttemptID attemptID0 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 0), 0);
        long bytes = 0x2800000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID0, new MapHost(null, null), bytes, 60000L, 100000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(1, 1.0, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID1 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 1), 1);
        bytes = 0x3200000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID1, new MapHost(null, null), bytes, 0L, 50000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(2, 1.0, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID2 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 2), 2);
        bytes = 0x6E00000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID2, new MapHost(null, null), bytes, 25000L, 80000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(3, 2.0, 2.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID3 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 3), 3);
        bytes = 0x6400000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID3, new MapHost(null, null), bytes, 100000L, 300000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(4, 0.5, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID4 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 4), 4);
        bytes = 0x3200000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID4, new MapHost(null, null), bytes, 350000L, 400000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(5, 1.0, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID5 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 5), 5);
        bytes = 0x3200000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID5, new MapHost(null, null), bytes, 450000L, 500000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(6, 1.0, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID6 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 6), 6);
        bytes = 0x1400000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID6, new MapHost(null, null), bytes, 320000L, 340000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(7, 1.0, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID7 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 7), 7);
        bytes = 0x1E00000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID7, new MapHost(null, null), bytes, 290000L, 350000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(8, 0.5, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID8 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 8), 8);
        bytes = 0x3200000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID8, new MapHost(null, null), bytes, 400000L, 450000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(9, 1.0, 1.0), (Object)progress.toString());
        org.apache.hadoop.mapred.TaskAttemptID attemptID9 = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 9), 9);
        bytes = 524288000L;
        scheduler.copySucceeded((TaskAttemptID)attemptID9, new MapHost(null, null), bytes, 0L, 500000L, output);
        Assertions.assertEquals((Object)TestShuffleScheduler.copyMessage(10, 1.0, 2.0), (Object)progress.toString());
    }

    @Test
    public <K, V> void TestSucceedAndFailedCopyMap() throws Exception {
        JobConf job = new JobConf();
        job.setNumMapTasks(2);
        TaskUmbilicalProtocol mockUmbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Reporter mockReporter = (Reporter)Mockito.mock(Reporter.class);
        FileSystem mockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Class combinerClass = job.getCombinerClass();
        Task.CombineOutputCollector mockCombineOutputCollector = (Task.CombineOutputCollector)Mockito.mock(Task.CombineOutputCollector.class);
        TaskAttemptID mockTaskAttemptID = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        LocalDirAllocator mockLocalDirAllocator = (LocalDirAllocator)Mockito.mock(LocalDirAllocator.class);
        CompressionCodec mockCompressionCodec = (CompressionCodec)Mockito.mock(CompressionCodec.class);
        Counters.Counter mockCounter = (Counters.Counter)Mockito.mock(Counters.Counter.class);
        TaskStatus mockTaskStatus = (TaskStatus)Mockito.mock(TaskStatus.class);
        Progress mockProgress = (Progress)Mockito.mock(Progress.class);
        MapOutputFile mockMapOutputFile = (MapOutputFile)Mockito.mock(MapOutputFile.class);
        Task mockTask = (Task)Mockito.mock(Task.class);
        MapOutput output = (MapOutput)Mockito.mock(MapOutput.class);
        ShuffleConsumerPlugin.Context context = new ShuffleConsumerPlugin.Context(mockTaskAttemptID, job, mockFileSystem, mockUmbilical, mockLocalDirAllocator, mockReporter, mockCompressionCodec, combinerClass, mockCombineOutputCollector, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockTaskStatus, mockProgress, mockProgress, mockTask, mockMapOutputFile, null);
        TaskStatus status = new TaskStatus(){

            public boolean getIsMap() {
                return false;
            }

            public void addFetchFailedMap(org.apache.hadoop.mapred.TaskAttemptID mapTaskId) {
            }
        };
        Progress progress = new Progress();
        ShuffleSchedulerImpl scheduler = new ShuffleSchedulerImpl(job, status, null, null, progress, context.getShuffledMapsCounter(), context.getReduceShuffleBytes(), context.getFailedShuffleCounter());
        MapHost host1 = new MapHost("host1", null);
        org.apache.hadoop.mapred.TaskAttemptID failedAttemptID = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 0), 0);
        org.apache.hadoop.mapred.TaskAttemptID succeedAttemptID = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 1), 1);
        scheduler.hostFailed(host1.getHostName());
        long bytes = 524288000L;
        scheduler.copySucceeded((TaskAttemptID)succeedAttemptID, host1, bytes, 0L, 500000L, output);
        scheduler.copyFailed((TaskAttemptID)failedAttemptID, host1, true, false);
    }

    @Test
    public <K, V> void testDuplicateCopySucceeded() throws Exception {
        JobConf job = new JobConf();
        job.setNumMapTasks(2);
        TaskUmbilicalProtocol mockUmbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Reporter mockReporter = (Reporter)Mockito.mock(Reporter.class);
        FileSystem mockFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Class combinerClass = job.getCombinerClass();
        Task.CombineOutputCollector mockCombineOutputCollector = (Task.CombineOutputCollector)Mockito.mock(Task.CombineOutputCollector.class);
        TaskAttemptID mockTaskAttemptID = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        LocalDirAllocator mockLocalDirAllocator = (LocalDirAllocator)Mockito.mock(LocalDirAllocator.class);
        CompressionCodec mockCompressionCodec = (CompressionCodec)Mockito.mock(CompressionCodec.class);
        Counters.Counter mockCounter = (Counters.Counter)Mockito.mock(Counters.Counter.class);
        TaskStatus mockTaskStatus = (TaskStatus)Mockito.mock(TaskStatus.class);
        Progress mockProgress = (Progress)Mockito.mock(Progress.class);
        MapOutputFile mockMapOutputFile = (MapOutputFile)Mockito.mock(MapOutputFile.class);
        Task mockTask = (Task)Mockito.mock(Task.class);
        MapOutput output1 = (MapOutput)Mockito.mock(MapOutput.class);
        MapOutput output2 = (MapOutput)Mockito.mock(MapOutput.class);
        MapOutput output3 = (MapOutput)Mockito.mock(MapOutput.class);
        ShuffleConsumerPlugin.Context context = new ShuffleConsumerPlugin.Context(mockTaskAttemptID, job, mockFileSystem, mockUmbilical, mockLocalDirAllocator, mockReporter, mockCompressionCodec, combinerClass, mockCombineOutputCollector, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockCounter, mockTaskStatus, mockProgress, mockProgress, mockTask, mockMapOutputFile, null);
        TaskStatus status = new TaskStatus(){

            public boolean getIsMap() {
                return false;
            }

            public void addFetchFailedMap(org.apache.hadoop.mapred.TaskAttemptID mapTaskId) {
            }
        };
        Progress progress = new Progress();
        ShuffleSchedulerImpl scheduler = new ShuffleSchedulerImpl(job, status, null, null, progress, context.getShuffledMapsCounter(), context.getReduceShuffleBytes(), context.getFailedShuffleCounter());
        MapHost host1 = new MapHost("host1", null);
        org.apache.hadoop.mapred.TaskAttemptID succeedAttempt1ID = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 0), 0);
        org.apache.hadoop.mapred.TaskAttemptID succeedAttempt2ID = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 0), 1);
        org.apache.hadoop.mapred.TaskAttemptID succeedAttempt3ID = new org.apache.hadoop.mapred.TaskAttemptID(new org.apache.hadoop.mapred.TaskID(new JobID("test", 0), TaskType.MAP, 1), 0);
        long bytes = 524288000L;
        scheduler.copySucceeded((TaskAttemptID)succeedAttempt1ID, host1, bytes, 0L, 1L, output1);
        ((MapOutput)Mockito.verify((Object)output1)).commit();
        scheduler.copySucceeded((TaskAttemptID)succeedAttempt2ID, host1, bytes, 0L, 1L, output2);
        ((MapOutput)Mockito.verify((Object)output2)).abort();
        scheduler.copySucceeded((TaskAttemptID)succeedAttempt3ID, host1, bytes, 0L, 1L, output3);
        ((MapOutput)Mockito.verify((Object)output3)).commit();
    }

    private static String copyMessage(int attemptNo, double rate1, double rate2) {
        int attemptZero = attemptNo - 1;
        return String.format("copy task(attempt_test_0000_m_%06d_%d succeeded at %1.2f MB/s) Aggregated copy rate(%d of 10 at %1.2f MB/s)", attemptZero, attemptZero, rate1, attemptNo, rate2);
    }
}

