/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.metrics2.MetricsTag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestShuffleClientMetrics {
    private static final String TEST_JOB_NAME = "Test job name";
    private static final String TEST_JOB_ID = "Test job id";
    private static final String TEST_TASK_ID = "Test task id";
    private static final String TEST_USER_NAME = "Test user name";

    @Test
    public void testShuffleMetricsTags() {
        JobID jobID = (JobID)Mockito.mock(JobID.class);
        Mockito.when((Object)jobID.toString()).thenReturn((Object)TEST_JOB_ID);
        TaskAttemptID reduceId = (TaskAttemptID)Mockito.mock(TaskAttemptID.class);
        Mockito.when((Object)reduceId.getJobID()).thenReturn((Object)jobID);
        Mockito.when((Object)reduceId.toString()).thenReturn((Object)TEST_TASK_ID);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        Mockito.when((Object)jobConf.getUser()).thenReturn((Object)TEST_USER_NAME);
        Mockito.when((Object)jobConf.getJobName()).thenReturn((Object)TEST_JOB_NAME);
        ShuffleClientMetrics shuffleClientMetrics = ShuffleClientMetrics.create((TaskAttemptID)reduceId, (JobConf)jobConf);
        MetricsTag userMetrics = shuffleClientMetrics.getMetricsRegistry().getTag("user");
        Assertions.assertEquals((Object)TEST_USER_NAME, (Object)userMetrics.value());
        MetricsTag jobNameMetrics = shuffleClientMetrics.getMetricsRegistry().getTag("jobName");
        Assertions.assertEquals((Object)TEST_JOB_NAME, (Object)jobNameMetrics.value());
        MetricsTag jobIdMetrics = shuffleClientMetrics.getMetricsRegistry().getTag("jobId");
        Assertions.assertEquals((Object)TEST_JOB_ID, (Object)jobIdMetrics.value());
        MetricsTag taskIdMetrics = shuffleClientMetrics.getMetricsRegistry().getTag("taskId");
        Assertions.assertEquals((Object)TEST_TASK_ID, (Object)taskIdMetrics.value());
    }
}

