/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.reduce.EventFetcher;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleScheduler;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestEventFetcher {
    @Test
    public void testConsecutiveFetch() throws IOException, InterruptedException {
        int MAX_EVENTS_TO_FETCH = 100;
        org.apache.hadoop.mapred.TaskAttemptID tid = new org.apache.hadoop.mapred.TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 1);
        TaskUmbilicalProtocol umbilical = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        Mockito.when((Object)umbilical.getMapCompletionEvents((JobID)Mockito.any(JobID.class), Mockito.anyInt(), Mockito.anyInt(), (org.apache.hadoop.mapred.TaskAttemptID)Mockito.any(org.apache.hadoop.mapred.TaskAttemptID.class))).thenReturn((Object)this.getMockedCompletionEventsUpdate(0, 0));
        Mockito.when((Object)umbilical.getMapCompletionEvents((JobID)Mockito.any(JobID.class), Mockito.eq((int)0), Mockito.eq((int)100), (org.apache.hadoop.mapred.TaskAttemptID)Mockito.eq((Object)tid))).thenReturn((Object)this.getMockedCompletionEventsUpdate(0, 100));
        Mockito.when((Object)umbilical.getMapCompletionEvents((JobID)Mockito.any(JobID.class), Mockito.eq((int)100), Mockito.eq((int)100), (org.apache.hadoop.mapred.TaskAttemptID)Mockito.eq((Object)tid))).thenReturn((Object)this.getMockedCompletionEventsUpdate(100, 100));
        Mockito.when((Object)umbilical.getMapCompletionEvents((JobID)Mockito.any(JobID.class), Mockito.eq((int)200), Mockito.eq((int)100), (org.apache.hadoop.mapred.TaskAttemptID)Mockito.eq((Object)tid))).thenReturn((Object)this.getMockedCompletionEventsUpdate(200, 3));
        ShuffleScheduler scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        ExceptionReporter reporter = (ExceptionReporter)Mockito.mock(ExceptionReporter.class);
        EventFetcherForTest ef = new EventFetcherForTest(tid, umbilical, scheduler, reporter, 100);
        ef.getMapCompletionEvents();
        ((ExceptionReporter)Mockito.verify((Object)reporter, (VerificationMode)Mockito.never())).reportException((Throwable)Mockito.any(Throwable.class));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{umbilical});
        ((TaskUmbilicalProtocol)inOrder.verify((Object)umbilical)).getMapCompletionEvents((JobID)Mockito.any(JobID.class), Mockito.eq((int)0), Mockito.eq((int)100), (org.apache.hadoop.mapred.TaskAttemptID)Mockito.eq((Object)tid));
        ((TaskUmbilicalProtocol)inOrder.verify((Object)umbilical)).getMapCompletionEvents((JobID)Mockito.any(JobID.class), Mockito.eq((int)100), Mockito.eq((int)100), (org.apache.hadoop.mapred.TaskAttemptID)Mockito.eq((Object)tid));
        ((TaskUmbilicalProtocol)inOrder.verify((Object)umbilical)).getMapCompletionEvents((JobID)Mockito.any(JobID.class), Mockito.eq((int)200), Mockito.eq((int)100), (org.apache.hadoop.mapred.TaskAttemptID)Mockito.eq((Object)tid));
        ((ShuffleScheduler)Mockito.verify((Object)scheduler, (VerificationMode)Mockito.times((int)203))).resolve((TaskCompletionEvent)Mockito.any(TaskCompletionEvent.class));
    }

    private MapTaskCompletionEventsUpdate getMockedCompletionEventsUpdate(int startIdx, int numEvents) {
        ArrayList<TaskCompletionEvent> tceList = new ArrayList<TaskCompletionEvent>(numEvents);
        for (int i = 0; i < numEvents; ++i) {
            int eventIdx = startIdx + i;
            TaskCompletionEvent tce = new TaskCompletionEvent(eventIdx, new org.apache.hadoop.mapred.TaskAttemptID("12345", 1, TaskType.MAP, eventIdx, 0), eventIdx, true, TaskCompletionEvent.Status.SUCCEEDED, "http://somehost:8888");
            tceList.add(tce);
        }
        TaskCompletionEvent[] events = new TaskCompletionEvent[]{};
        return new MapTaskCompletionEventsUpdate(tceList.toArray(events), false);
    }

    private static class EventFetcherForTest<K, V>
    extends EventFetcher<K, V> {
        public EventFetcherForTest(org.apache.hadoop.mapred.TaskAttemptID reduce, TaskUmbilicalProtocol umbilical, ShuffleScheduler<K, V> scheduler, ExceptionReporter reporter, int maxEventsToFetch) {
            super((TaskAttemptID)reduce, umbilical, scheduler, reporter, maxEventsToFetch);
        }

        public int getMapCompletionEvents() throws IOException, InterruptedException {
            return super.getMapCompletionEvents();
        }
    }
}

