/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestJobSplitWriterWithEC {
    private ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)5);
    private static final int BLOCKSIZE = 0xA00000;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private Configuration conf;
    private Path submitDir;
    private Path testFile;

    @BeforeEach
    public void setup() throws Exception {
        HdfsConfiguration hdfsConf = new HdfsConfiguration();
        hdfsConf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        String namenodeDir = new File(MiniDFSCluster.getBaseDirectory(), "name").getAbsolutePath();
        hdfsConf.set("dfs.namenode.name.dir", namenodeDir);
        hdfsConf.set("dfs.namenode.edits.dir", namenodeDir);
        hdfsConf.setLong("dfs.blocksize", 0xA00000L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)hdfsConf).numDataNodes(15).build();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.fs.setErasureCodingPolicy(new Path("/"), this.ecPolicy.getName());
        this.cluster.waitActive();
        this.conf = new Configuration();
        this.submitDir = new Path("/");
        this.testFile = new Path("/testfile");
        DFSTestUtil.writeFile((FileSystem)this.fs, (Path)this.testFile, (byte[])StripedFileTestUtil.generateBytes((int)0xA00000));
        this.conf.set("mapreduce.input.fileinputformat.inputdir", this.fs.getUri().toString() + this.testFile.toString());
    }

    @AfterEach
    public void after() {
        this.cluster.close();
    }

    @Test
    public void testMaxBlockLocationsNewSplitsWithErasureCoding() throws Exception {
        Job job = Job.getInstance((Configuration)this.conf);
        org.apache.hadoop.mapreduce.lib.input.TextInputFormat fileInputFormat = new org.apache.hadoop.mapreduce.lib.input.TextInputFormat();
        List splits = fileInputFormat.getSplits((JobContext)job);
        JobSplitWriter.createSplitFiles((Path)this.submitDir, (Configuration)this.conf, (FileSystem)this.fs, (List)splits);
        this.validateSplitMetaInfo();
    }

    @Test
    public void testMaxBlockLocationsOldSplitsWithErasureCoding() throws Exception {
        JobConf jobConf = new JobConf(this.conf);
        TextInputFormat fileInputFormat = new TextInputFormat();
        fileInputFormat.configure(jobConf);
        InputSplit[] splits = fileInputFormat.getSplits(jobConf, 1);
        JobSplitWriter.createSplitFiles((Path)this.submitDir, (Configuration)this.conf, (FileSystem)this.fs, (InputSplit[])splits);
        this.validateSplitMetaInfo();
    }

    private void validateSplitMetaInfo() throws IOException {
        JobSplit.TaskSplitMetaInfo[] splitInfo = SplitMetaInfoReader.readSplitMetaInfo((JobID)new JobID(), (FileSystem)this.fs, (Configuration)this.conf, (Path)this.submitDir);
        Assertions.assertEquals((int)1, (int)splitInfo.length, (String)"Number of splits");
        Assertions.assertEquals((int)14, (int)splitInfo[0].getLocations().length, (String)"Number of block locations");
    }
}

