/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.EntryFileIO;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hadoop.util.functional.TaskPool;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEntryFileIO
extends AbstractManifestCommitterTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestEntryFileIO.class);
    public static final FileEntry ENTRY = new FileEntry("source", "dest", 100L, "etag");
    private EntryFileIO entryFileIO;
    private File entryFile;

    @Override
    @BeforeEach
    public void setup() throws Exception {
        this.entryFileIO = new EntryFileIO(new Configuration());
        this.createEntryFile();
    }

    @Override
    @AfterEach
    public void teardown() throws Exception {
        Thread.currentThread().setName("teardown");
        if (this.getEntryFile() != null) {
            this.getEntryFile().delete();
        }
    }

    private void createEntryFile() throws IOException {
        this.setEntryFile(File.createTempFile("entry", ".seq"));
    }

    private File getEntryFile() {
        return this.entryFile;
    }

    private void setEntryFile(File entryFile) {
        this.entryFile = entryFile;
    }

    @Test
    public void testCreateWriteReadFileOneEntry() throws Throwable {
        FileEntry source = ENTRY;
        SequenceFile.Writer writer = this.createWriter();
        writer.append((Writable)NullWritable.get(), (Writable)source);
        writer.flush();
        writer.close();
        FileEntry readBack = new FileEntry();
        try (SequenceFile.Reader reader = this.readEntryFile();){
            reader.next((Writable)NullWritable.get(), (Writable)readBack);
        }
        ((ObjectAssert)Assertions.assertThat((Object)readBack).describedAs("entry read back from sequence file", new Object[0])).isEqualTo((Object)source);
        RemoteIterator<FileEntry> it = this.iterateOverEntryFile();
        ArrayList files = new ArrayList();
        RemoteIterators.foreach(it, files::add);
        ((ObjectAssert)((ListAssert)((ListAssert)Assertions.assertThat(files).describedAs("iteration over the entry file", new Object[0])).hasSize(1)).element(0)).isEqualTo((Object)source);
        EntryFileIO.EntryIterator et = (EntryFileIO.EntryIterator)it;
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)et).describedAs("entry iterator %s", new Object[]{et})).matches(p -> p.isClosed())).extracting(p -> p.getCount()).isEqualTo((Object)1);
    }

    private SequenceFile.Writer createWriter() throws IOException {
        return this.entryFileIO.createWriter(this.getEntryFile());
    }

    private RemoteIterator<FileEntry> iterateOverEntryFile() throws IOException {
        return this.entryFileIO.iterateOver(this.readEntryFile());
    }

    private SequenceFile.Reader readEntryFile() throws IOException {
        this.assertEntryFileNonEmpty();
        return this.entryFileIO.createReader(this.getEntryFile());
    }

    @Test
    public void testCreateEmptyFile() throws Throwable {
        File file = this.getEntryFile();
        this.entryFileIO.createWriter(file).close();
        ArrayList files = new ArrayList();
        ((AbstractLongAssert)Assertions.assertThat((long)RemoteIterators.foreach(this.iterateOverEntryFile(), files::add)).describedAs("Count of iterations over entries in an entry file with no entries", new Object[0])).isEqualTo(0L);
    }

    private void assertEntryFileNonEmpty() {
        ((AbstractLongAssert)Assertions.assertThat((long)this.getEntryFile().length()).describedAs("Length of file %s", new Object[]{this.getEntryFile()})).isGreaterThan(0L);
    }

    @Test
    public void testCreateInvalidWriter() throws Throwable {
        LambdaTestUtils.intercept(NullPointerException.class, () -> this.entryFileIO.launchEntryWriter(null, 1));
    }

    @Test
    public void testCreateInvalidWriterCapacity() throws Throwable {
        LambdaTestUtils.intercept(IllegalStateException.class, () -> this.entryFileIO.launchEntryWriter(null, 0));
    }

    @Test
    public void testLargeStreamingWrite() throws Throwable {
        int listSize = 100;
        int writes = 100;
        List<FileEntry> list = TestEntryFileIO.buildEntryList(listSize);
        int total = listSize * writes;
        try (EntryFileIO.EntryWriter out = this.entryFileIO.launchEntryWriter(this.createWriter(), 2);){
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)out.isActive()).describedAs("out.isActive in ()", new Object[]{out})).isTrue();
            for (int i = 0; i < writes; ++i) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)out.enqueue(list)).describedAs("enqueue of list", new Object[0])).isTrue();
            }
            out.close();
            out.maybeRaiseWriteException();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)out.isActive()).describedAs("out.isActive in ()", new Object[]{out})).isFalse();
            ((AbstractIntegerAssert)Assertions.assertThat((int)out.getCount()).describedAs("total elements written", new Object[0])).isEqualTo(total);
        }
        AtomicInteger count = new AtomicInteger();
        RemoteIterators.foreach(this.iterateOverEntryFile(), e -> {
            int elt = count.getAndIncrement();
            int index = elt % listSize;
            ((ObjectAssert)Assertions.assertThat((Object)e).describedAs("element %d in file mapping to index %d", new Object[]{elt, index})).isEqualTo(list.get(index));
        });
        ((AbstractIntegerAssert)Assertions.assertThat((int)count.get()).describedAs("total elements read", new Object[0])).isEqualTo(total);
    }

    private static List<FileEntry> buildEntryList(int listSize) {
        ArrayList<FileEntry> list = new ArrayList<FileEntry>(listSize);
        for (int i = 0; i < listSize; ++i) {
            list.add(new FileEntry("source" + i, "dest" + i, (long)i, "etag-" + i));
        }
        Assertions.assertThat(list).hasSize(listSize);
        return list;
    }

    @Test
    public void testFailurePropagation() throws Throwable {
        int count = 4;
        SequenceFile.Writer writer = TestEntryFileIO.spyWithFailingAppend(this.entryFileIO.createWriter(this.getEntryFile()), 4);
        List<FileEntry> list = TestEntryFileIO.buildEntryList(1);
        try (EntryFileIO.EntryWriter out = this.entryFileIO.launchEntryWriter(writer, 2);){
            boolean valid = true;
            for (int i = 0; valid && i < 8; ++i) {
                valid = out.enqueue(list);
            }
            LOG.info("queue to {} finished valid={}", (Object)out, (Object)valid);
            out.close();
            LambdaTestUtils.intercept(IOException.class, (String)"mocked", () -> out.maybeRaiseWriteException());
            ((AbstractIntegerAssert)Assertions.assertThat((int)out.getCount()).describedAs("process count of %s", new Object[]{4})).isEqualTo(4);
        }
    }

    private static SequenceFile.Writer spyWithFailingAppend(SequenceFile.Writer writer, int count) throws IOException {
        AtomicLong limit = new AtomicLong(count);
        SequenceFile.Writer spied = (SequenceFile.Writer)Mockito.spy((Object)writer);
        ((SequenceFile.Writer)Mockito.doAnswer(invocation -> {
            Writable k = (Writable)invocation.getArgument(0);
            Writable v = (Writable)invocation.getArgument(1);
            if (limit.getAndDecrement() <= 0L) {
                throw new IOException("mocked");
            }
            writer.append(k, v);
            return null;
        }).when((Object)spied)).append((Writable)Mockito.any(Writable.class), (Writable)Mockito.any(Writable.class));
        return spied;
    }

    @Test
    public void testParallelWrite() throws Throwable {
        int listSize = 100;
        int attempts = 100;
        List<FileEntry> list = TestEntryFileIO.buildEntryList(listSize);
        int total = listSize * attempts;
        try (EntryFileIO.EntryWriter out = this.entryFileIO.launchEntryWriter(this.createWriter(), 20);){
            TaskPool.foreach((RemoteIterator)RemoteIterators.rangeExcludingIterator((long)0L, (long)attempts)).executeWith((TaskPool.Submitter)this.getSubmitter()).stopOnFailure().run(l -> out.enqueue(list));
            out.close();
            out.maybeRaiseWriteException();
            ((AbstractIntegerAssert)Assertions.assertThat((int)out.getCount()).describedAs("total elements written", new Object[0])).isEqualTo(total);
        }
        ((AbstractLongAssert)Assertions.assertThat((long)RemoteIterators.foreach(this.iterateOverEntryFile(), e -> {})).describedAs("total elements read", new Object[0])).isEqualTo((long)total);
    }
}

