/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterTestSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.JsonSerialization;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTaskManifestFileIO
extends AbstractManifestCommitterTest {
    private TaskManifest source;
    private ManifestCommitterTestSupport.JobAndTaskIDsForTests taskIDs;
    private String taskAttempt00;
    private Path testPath;
    private Path taPath;

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.taskIDs = new ManifestCommitterTestSupport.JobAndTaskIDsForTests(2, 2);
        this.source = new TaskManifest();
        this.taskAttempt00 = this.taskIDs.getTaskAttempt(0, 0);
        this.source.setTaskAttemptID(this.taskAttempt00);
        this.testPath = this.methodPath();
        this.taPath = new Path(this.testPath, "  " + this.taskAttempt00);
        this.source.setTaskAttemptDir(AbstractManifestData.marshallPath((Path)this.taPath));
    }

    @Test
    public void testJsonRoundTrip() throws Throwable {
        this.describe("Save manifest file to string and back");
        Path subdirS = new Path(this.taPath, "subdir");
        Path subdirD = new Path(this.testPath, "subdir");
        this.source.addDirectory(DirEntry.dirEntry((Path)subdirD, (int)0, (int)0));
        Path subfileS = new Path(subdirS, "file");
        Path subfileD = new Path(subdirD, "file");
        long len = 256L;
        FileEntry subFileEntry = new FileEntry(subfileS, subfileD, len, "etag");
        this.source.addFileToCommit(subFileEntry);
        JsonSerialization serializer = TaskManifest.serializer();
        String json = serializer.toJson((Object)this.source);
        LOG.info("serialized form\n{}", (Object)json);
        TaskManifest deser = (TaskManifest)serializer.fromJson(json);
        deser.validate();
        ((AbstractStringAssert)Assertions.assertThat((String)deser.getTaskAttemptID()).describedAs("Task attempt ID", new Object[0])).isEqualTo((Object)this.taskAttempt00);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)AbstractManifestData.unmarshallPath((String)deser.getTaskAttemptDir())).describedAs("Task attempt Dir %s", new Object[]{deser.getTaskAttemptDir()})).isEqualTo((Object)this.taPath);
        ((ListAssert)Assertions.assertThat((List)deser.getDestDirectories()).hasSize(1)).allSatisfy(d -> ManifestCommitterTestSupport.assertDirEntryMatch(d, subdirD, 0L));
        ((ListAssert)Assertions.assertThat((List)deser.getFilesToCommit()).hasSize(1)).allSatisfy(d -> ManifestCommitterTestSupport.assertFileEntryMatch(d, subfileS, subfileD, len));
        FileEntry entry = (FileEntry)deser.getFilesToCommit().get(0);
        ManifestCommitterTestSupport.assertFileEntryMatch(entry, subfileS, subfileD, len);
        ((AbstractStringAssert)Assertions.assertThat((String)entry.getEtag()).describedAs("etag of %s", new Object[]{entry})).isEqualTo((Object)"etag");
    }

    @Test
    public void testValidateRejectsTwoCommitsToSameDest() throws Throwable {
        Path subdirS = new Path(this.taPath, "subdir");
        Path subdirD = new Path(this.testPath, "subdir");
        this.source.addDirectory(DirEntry.dirEntry((Path)subdirD, (int)0, (int)0));
        Path subfileS = new Path(subdirS, "file");
        Path subfileS2 = new Path(subdirS, "file2");
        Path subfileD = new Path(subdirD, "file");
        long len = 256L;
        this.source.addFileToCommit(new FileEntry(subfileS, subfileD, len, "tag1"));
        this.source.addFileToCommit(new FileEntry(subfileS2, subfileD, len, "tag2"));
        this.assertValidationFailureOnRoundTrip(this.source);
    }

    @Test
    public void testValidateRejectsIncompleteFileEntry() throws Throwable {
        this.source.addFileToCommit(new FileEntry(this.taPath, null, 0L, null));
        this.assertValidationFailureOnRoundTrip(this.source);
    }

    @Test
    public void testValidateRejectsInvalidFileLength() throws Throwable {
        this.source.addFileToCommit(new FileEntry(this.taPath, this.testPath, -1L, null));
        this.assertValidationFailureOnRoundTrip(this.source);
    }

    @Test
    public void testRejectIncompatibleVersion() throws Throwable {
        this.source.setVersion(5);
        this.assertValidationFailureOnRoundTrip(this.source);
    }

    @Test
    public void testRejectIncompatibleType() throws Throwable {
        this.source.setType("Incompatible type");
        this.assertValidationFailureOnRoundTrip(this.source);
    }

    private void assertValidationFailureOnRoundTrip(TaskManifest manifest) throws Exception {
        JsonSerialization serializer = TaskManifest.serializer();
        String json = serializer.toJson((Object)manifest);
        LOG.info("serialized form\n{}", (Object)json);
        TaskManifest deser = (TaskManifest)serializer.fromJson(json);
        LambdaTestUtils.intercept(IOException.class, () -> ((TaskManifest)deser).validate());
    }
}

