/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.BindingPathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MapFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitter;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConstants;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterFactory;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterTestSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.TextOutputForTests;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestManifestCommitProtocol
extends AbstractManifestCommitterTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestManifestCommitProtocol.class);
    private static final String SUB_DIR = "SUB_DIR";
    protected static final String PART_00000 = "part-m-00000";
    private static final Text KEY_1 = new Text("key1");
    private static final Text KEY_2 = new Text("key2");
    private static final Text VAL_1 = new Text("val1");
    private static final Text VAL_2 = new Text("val2");
    private static final IOStatisticsSnapshot IOSTATISTICS = IOStatisticsSupport.snapshotIOStatistics();
    private final String jobId;
    private final String attempt0;
    private final TaskAttemptID taskAttempt0;
    private final TaskAttemptID taskAttempt1;
    private final String attempt1;
    private final List<JobData> abortInTeardown = new ArrayList<JobData>(1);
    private Path outputDir;
    private final LocalCommitterFactory localCommitterFactory = new LocalCommitterFactory();
    public static final PathFilter HIDDEN_FILE_FILTER = path -> !path.getName().startsWith("_") && !path.getName().startsWith(".");

    private void cleanupOutputDir() throws IOException {
        if (this.outputDir != null) {
            this.getFileSystem().delete(this.outputDir, true);
        }
    }

    public TestManifestCommitProtocol() {
        ManifestCommitterTestSupport.JobAndTaskIDsForTests taskIDs = new ManifestCommitterTestSupport.JobAndTaskIDsForTests(2, 2);
        this.jobId = taskIDs.getJobId();
        this.attempt0 = taskIDs.getTaskAttempt(0, 0);
        this.taskAttempt0 = taskIDs.getTaskAttemptIdType(0, 0);
        this.attempt1 = taskIDs.getTaskAttempt(0, 1);
        this.taskAttempt1 = taskIDs.getTaskAttemptIdType(0, 1);
    }

    protected String suitename() {
        return "TestManifestCommitProtocolLocalFS";
    }

    public Logger log() {
        return LOG;
    }

    protected String getMethodName() {
        return this.suitename() + "-" + super.getMethodName();
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.outputDir = this.path(this.getMethodName());
        this.cleanupOutputDir();
    }

    @Override
    @AfterEach
    public void teardown() throws Exception {
        this.describe("teardown");
        Thread.currentThread().setName("teardown");
        for (JobData jobData : this.abortInTeardown) {
            this.abortJobQuietly(jobData);
            IOSTATISTICS.aggregate((IOStatistics)jobData.committer.getIOStatistics());
        }
        try {
            this.cleanupOutputDir();
        }
        catch (IOException e) {
            this.log().info("Exception during cleanup", (Throwable)e);
        }
        super.teardown();
    }

    @AfterAll
    public static void logAggregateIOStatistics() {
        LOG.info("Final IOStatistics {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)IOSTATISTICS));
    }

    protected void abortInTeardown(JobData jobData) {
        this.abortInTeardown.add(jobData);
    }

    @Override
    protected Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        this.bindCommitter(conf);
        return conf;
    }

    protected void bindCommitter(Configuration conf) {
        conf.set("mapreduce.outputcommitter.factory.class", ManifestCommitterConstants.MANIFEST_COMMITTER_FACTORY);
    }

    protected ManifestCommitter createCommitter(TaskAttemptContext context) throws IOException {
        return this.createCommitter(this.getOutputDir(), context);
    }

    protected ManifestCommitter createCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        return new ManifestCommitter(outputPath, context);
    }

    protected Path getOutputDir() {
        return this.outputDir;
    }

    protected String getJobId() {
        return this.jobId;
    }

    protected String getAttempt0() {
        return this.attempt0;
    }

    protected TaskAttemptID getTaskAttempt0() {
        return this.taskAttempt0;
    }

    protected String getAttempt1() {
        return this.attempt1;
    }

    protected TaskAttemptID getTaskAttempt1() {
        return this.taskAttempt1;
    }

    protected void assertCommitterFactoryIsManifestCommitter(JobContext context, Path output) {
        Configuration conf = context.getConfiguration();
        this.assertConfigurationUsesManifestCommitter(conf);
        String factoryName = conf.get("mapreduce.outputcommitter.factory.class", "");
        PathOutputCommitterFactory factory = PathOutputCommitterFactory.getCommitterFactory((Path)output, (Configuration)conf);
        ((ObjectAssert)Assertions.assertThat((Object)factory).describedAs("Committer for output path %s and factory name \"%s\"", new Object[]{output, factoryName})).isInstanceOf(ManifestCommitterFactory.class);
    }

    private void assertConfigurationUsesManifestCommitter(Configuration conf) {
        String factoryName = conf.get("mapreduce.outputcommitter.factory.class", null);
        ((AbstractStringAssert)Assertions.assertThat((String)factoryName).describedAs("Value of %s", new Object[]{"mapreduce.outputcommitter.factory.class"})).isEqualTo((Object)ManifestCommitterConstants.MANIFEST_COMMITTER_FACTORY);
    }

    protected Path writeTextOutput(TaskAttemptContext context) throws IOException, InterruptedException {
        this.describe("write output");
        try (DurationInfo d = new DurationInfo(LOG, "Writing Text output for task %s", new Object[]{context.getTaskAttemptID()});){
            TextOutputForTests.LoggingLineRecordWriter writer = new TextOutputForTests().getRecordWriter(context);
            this.writeOutput((RecordWriter<Writable, Object>)writer, context);
            Path path = writer.getDest();
            return path;
        }
    }

    private void writeOutput(RecordWriter<Writable, Object> writer, TaskAttemptContext context) throws IOException, InterruptedException {
        NullWritable nullWritable = NullWritable.get();
        try (ManifestCommitterTestSupport.CloseWriter<Writable, Object> cw = new ManifestCommitterTestSupport.CloseWriter<Writable, Object>(writer, context);){
            writer.write((Object)KEY_1, (Object)VAL_1);
            writer.write(null, (Object)nullWritable);
            writer.write(null, (Object)VAL_1);
            writer.write((Object)nullWritable, (Object)VAL_2);
            writer.write((Object)KEY_2, (Object)nullWritable);
            writer.write((Object)KEY_1, null);
            writer.write(null, null);
            writer.write((Object)KEY_2, (Object)VAL_2);
            writer.close(context);
        }
    }

    private void writeMapFileOutput(RecordWriter<WritableComparable<?>, Writable> writer, TaskAttemptContext context) throws IOException, InterruptedException {
        this.describe("\nWrite map output");
        try (DurationInfo d = new DurationInfo(LOG, "Writing Text output for task %s", new Object[]{context.getTaskAttemptID()});
             ManifestCommitterTestSupport.CloseWriter cw = new ManifestCommitterTestSupport.CloseWriter(writer, context);){
            for (int i = 0; i < 10; ++i) {
                Text val = (i & 1) == 1 ? VAL_1 : VAL_2;
                writer.write((Object)new LongWritable((long)i), (Object)val);
            }
            LOG.debug("Closing writer {}", writer);
            writer.close(context);
        }
    }

    public Job newJob() throws IOException {
        return this.newJob(this.outputDir, this.getConfiguration(), this.attempt0);
    }

    private Job newJob(Path dir, Configuration configuration, String taskAttemptId) throws IOException {
        Job job = Job.getInstance((Configuration)configuration);
        Configuration conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", taskAttemptId);
        this.enableManifestCommitter(conf);
        FileOutputFormat.setOutputPath((Job)job, (Path)dir);
        return job;
    }

    protected JobData startJob(boolean writeText) throws IOException, InterruptedException {
        return this.startJob(this.localCommitterFactory, writeText);
    }

    protected JobData startJob(CommitterFactory factory, boolean writeText) throws IOException, InterruptedException {
        Job job = this.newJob();
        Configuration conf = job.getConfiguration();
        this.assertConfigurationUsesManifestCommitter(conf);
        conf.set("mapreduce.task.attempt.id", this.attempt0);
        conf.setInt("mapreduce.job.application.attempt.id", 1);
        JobContextImpl jContext = new JobContextImpl(conf, this.taskAttempt0.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, this.taskAttempt0);
        ManifestCommitter committer = factory.createCommitter((TaskAttemptContext)tContext);
        JobData jobData = new JobData(job, (JobContext)jContext, (TaskAttemptContext)tContext, committer);
        this.setupJob(jobData);
        this.abortInTeardown(jobData);
        if (writeText) {
            jobData.writtenTextPath = this.writeTextOutput((TaskAttemptContext)tContext);
        }
        return jobData;
    }

    protected void setupJob(JobData jobData) throws IOException {
        ManifestCommitter committer = jobData.committer;
        JobContext jContext = jobData.jContext;
        TaskAttemptContext tContext = jobData.tContext;
        this.describe("\nsetup job");
        try (DurationInfo d = new DurationInfo(LOG, "setup job %s", new Object[]{jContext.getJobID()});){
            committer.setupJob(jContext);
        }
        this.setupCommitter(committer, tContext);
        this.describe("setup complete");
    }

    private void setupCommitter(ManifestCommitter committer, TaskAttemptContext tContext) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "setup task %s", new Object[]{tContext.getTaskAttemptID()});){
            committer.setupTask(tContext);
        }
    }

    protected void abortJobQuietly(JobData jobData) {
        this.abortJobQuietly(jobData.committer, jobData.jContext, jobData.tContext);
    }

    protected void abortJobQuietly(ManifestCommitter committer, JobContext jContext, TaskAttemptContext tContext) {
        this.describe("\naborting task");
        try {
            committer.abortTask(tContext);
        }
        catch (Exception e) {
            this.log().warn("Exception aborting task:", (Throwable)e);
        }
        this.describe("\naborting job");
        try {
            committer.abortJob(jContext, JobStatus.State.KILLED);
        }
        catch (Exception e) {
            this.log().warn("Exception aborting job", (Throwable)e);
        }
    }

    protected void commitTaskAndJob(ManifestCommitter committer, JobContext jContext, TaskAttemptContext tContext) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "committing Job %s", new Object[]{jContext.getJobID()});){
            this.describe("\ncommitting task");
            committer.commitTask(tContext);
            this.describe("\ncommitting job");
            committer.commitJob(jContext);
            this.describe("commit complete\n");
        }
    }

    protected void executeWork(String name, ActionToTest action) throws Exception {
        this.executeWork(name, this.startJob(false), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWork(String name, JobData jobData, ActionToTest action) throws Exception {
        try (DurationInfo d = new DurationInfo(LOG, "Executing %s", new Object[]{name});){
            action.exec(jobData.job, jobData.jContext, jobData.tContext, jobData.committer);
        }
        finally {
            this.abortJobQuietly(jobData);
        }
    }

    TaskManifest loadManifest(Path path) throws IOException {
        return TaskManifest.load((FileSystem)this.getFileSystem(), (Path)path);
    }

    @Test
    public void testRecoveryAndCleanup() throws Exception {
        this.describe("Test (unsupported) task recovery.");
        JobData jobData = this.startJob(true);
        TaskAttemptContext tContext = jobData.tContext;
        ManifestCommitter committer = jobData.committer;
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)committer.getWorkPath()).as("null workPath in committer " + committer, new Object[0])).isNotNull();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)committer.getOutputPath()).as("null outputPath in committer " + committer, new Object[0])).isNotNull();
        this.commitTask(committer, tContext);
        TaskManifest manifest = this.loadManifest(committer.getTaskManifestPath(tContext));
        LOG.info("Manifest {}", (Object)manifest);
        Configuration conf2 = jobData.job.getConfiguration();
        conf2.set("mapreduce.task.attempt.id", this.attempt0);
        conf2.setInt("mapreduce.job.application.attempt.id", 2);
        JobContextImpl jContext2 = new JobContextImpl(conf2, this.taskAttempt0.getJobID());
        TaskAttemptContextImpl tContext2 = new TaskAttemptContextImpl(conf2, this.taskAttempt0);
        ManifestCommitter committer2 = this.createCommitter((TaskAttemptContext)tContext2);
        committer2.setupJob((JobContext)tContext2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)committer2.isRecoverySupported()).as("recoverySupported in " + committer2, new Object[0])).isFalse();
        LambdaTestUtils.intercept(IOException.class, (String)"recover", () -> TestManifestCommitProtocol.lambda$testRecoveryAndCleanup$0(committer2, (TaskAttemptContext)tContext2));
        this.describe("aborting task attempt 2; expect nothing to clean up");
        committer2.abortTask((TaskAttemptContext)tContext2);
        this.describe("Aborting job 2; expect pending commits to be aborted");
        committer2.abortJob((JobContext)jContext2, JobStatus.State.KILLED);
    }

    protected void assertTaskAttemptPathDoesNotExist(ManifestCommitter committer, TaskAttemptContext context) throws IOException {
        Path attemptPath = committer.getTaskAttemptPath(context);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)attemptPath.getFileSystem(context.getConfiguration()), (String)"task attempt dir", (Path)attemptPath);
    }

    protected void assertJobAttemptPathDoesNotExist(ManifestCommitter committer, JobContext context) throws IOException {
        Path attemptPath = committer.getJobAttemptPath(context);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)attemptPath.getFileSystem(context.getConfiguration()), (String)"job attempt dir", (Path)attemptPath);
    }

    private ManifestSuccessData validateContent(Path dir, boolean expectSuccessMarker, String expectedJobId) throws Exception {
        TestManifestCommitProtocol.lsR(this.getFileSystem(), dir, true);
        ManifestSuccessData successData = expectSuccessMarker ? this.verifySuccessMarker(dir, expectedJobId) : null;
        Path expectedFile = this.getPart0000(dir);
        this.log().debug("Validating content in {}", (Object)expectedFile);
        StringBuilder expectedOutput = new StringBuilder();
        expectedOutput.append(KEY_1).append('\t').append(VAL_1).append("\n");
        expectedOutput.append(VAL_1).append("\n");
        expectedOutput.append(VAL_2).append("\n");
        expectedOutput.append(KEY_2).append("\n");
        expectedOutput.append(KEY_1).append("\n");
        expectedOutput.append(KEY_2).append('\t').append(VAL_2).append("\n");
        String output = this.readFile(expectedFile);
        ((AbstractStringAssert)Assertions.assertThat((String)output).describedAs("Content of %s", new Object[]{expectedFile})).isEqualTo((Object)expectedOutput.toString());
        return successData;
    }

    protected Path getPart0000(Path dir) throws Exception {
        FileSystem fs = dir.getFileSystem(this.getConfiguration());
        FileStatus[] statuses = fs.listStatus(dir, path -> path.getName().startsWith(PART_00000));
        if (statuses.length != 1) {
            ContractTestUtils.assertPathExists((FileSystem)fs, (String)"Output file", (Path)new Path(dir, PART_00000));
        }
        return statuses[0].getPath();
    }

    private void validateMapFileOutputContent(FileSystem fs, Path dir) throws Exception {
        this.assertPathExists("Map output", dir);
        Path expectedMapDir = this.getPart0000(dir);
        this.assertPathExists("Map output", expectedMapDir);
        this.assertIsDirectory(expectedMapDir);
        Object[] files = fs.listStatus(expectedMapDir);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])files).as("No files found in " + expectedMapDir, new Object[0])).isNotEmpty();
        this.assertPathExists("index file in " + expectedMapDir, new Path(expectedMapDir, "index"));
        this.assertPathExists("data file in " + expectedMapDir, new Path(expectedMapDir, "data"));
    }

    @Test
    public void testCommitLifecycle() throws Exception {
        this.describe("Full test of the expected lifecycle:\n start job, task, write, commit task, commit job.\nVerify:\n* no files are visible after task commit\n* the expected file is visible after job commit\n");
        JobData jobData = this.startJob(false);
        JobContext jContext = jobData.jContext;
        TaskAttemptContext tContext = jobData.tContext;
        ManifestCommitter committer = jobData.committer;
        this.assertCommitterFactoryIsManifestCommitter((JobContext)tContext, tContext.getWorkingDirectory());
        this.validateTaskAttemptWorkingDirectory(committer, tContext);
        this.describe("1. Writing output");
        Path textOutputPath = this.writeTextOutput(tContext);
        this.describe("Output written to %s", textOutputPath);
        this.describe("2. Committing task");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)committer.needsTaskCommit(tContext)).as("No files to commit were found by " + committer, new Object[0])).isTrue();
        this.commitTask(committer, tContext);
        TaskManifest taskManifest = Objects.requireNonNull(committer.getTaskAttemptCommittedManifest(), "committerTaskManifest");
        String manifestJSON = taskManifest.toJson();
        LOG.info("Task manifest {}", (Object)manifestJSON);
        int filesCreated = 1;
        ((ListAssert)Assertions.assertThat((List)taskManifest.getFilesToCommit()).describedAs("Files to commit in task manifest %s", new Object[]{manifestJSON})).hasSize(filesCreated);
        ((ListAssert)Assertions.assertThat((List)taskManifest.getDestDirectories()).describedAs("Directories to create in task manifest %s", new Object[]{manifestJSON})).isEmpty();
        try {
            RemoteIterators.foreach((RemoteIterator)this.getFileSystem().listFiles(this.outputDir, false), status -> ((AbstractStringAssert)Assertions.assertThat((String)status.getPath().toString()).as("task committed file to dest :" + status, new Object[0])).contains(new CharSequence[]{"part"}));
        }
        catch (FileNotFoundException ignored) {
            this.log().info("Outdir {} is not created by task commit phase ", (Object)this.outputDir);
        }
        this.describe("3. Committing job");
        this.commitJob(committer, jContext);
        this.describe("4. Validating content");
        String jobUniqueId = jobData.jobId();
        ManifestSuccessData successData = this.validateContent(this.outputDir, true, jobUniqueId);
        ((MapAssert)Assertions.assertThat((Map)successData.getDiagnostics()).describedAs("Stage entry in SUCCESS", new Object[0])).containsEntry((Object)"stage", (Object)"committer_commit_job");
        IOStatisticsSnapshot jobStats = successData.getIOStatistics();
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)jobStats, (String)"op_load_manifest", (long)1L);
        FileStatus st = this.getFileSystem().getFileStatus(this.getPart0000(this.outputDir));
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)jobStats, (String)"committer_files_committed", (long)filesCreated);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)jobStats, (String)"committer_bytes_committed", (long)st.getLen());
        ManifestSuccessData report = this.loadReport(jobUniqueId, true);
        Map diag = report.getDiagnostics();
        ((MapAssert)Assertions.assertThat((Map)diag).describedAs("Stage entry in report", new Object[0])).containsEntry((Object)"stage", (Object)"committer_commit_job");
        IOStatisticsSnapshot reportStats = report.getIOStatistics();
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)reportStats, (String)"op_load_manifest", (long)1L);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)reportStats, (String)"committer_commit_job", (long)1L);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)reportStats, (String)"committer_files_committed", (long)filesCreated);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)reportStats, (String)"committer_bytes_committed", (long)st.getLen());
    }

    private ManifestSuccessData loadReport(String jobUniqueId, boolean expectSuccess) throws IOException {
        File file = new File(this.getReportDir(), ManifestCommitterSupport.createJobSummaryFilename((String)jobUniqueId));
        ContractTestUtils.assertIsFile((FileSystem)FileSystem.getLocal((Configuration)this.getConfiguration()), (Path)new Path(file.toURI()));
        ManifestSuccessData report = (ManifestSuccessData)ManifestSuccessData.serializer().load(file);
        LOG.info("Report for job {}:\n{}", (Object)jobUniqueId, (Object)report.toJson());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)report.getSuccess()).describedAs("success flag in report", new Object[0])).isEqualTo(expectSuccess);
        return report;
    }

    @Test
    public void testCommitterWithDuplicatedCommit() throws Exception {
        this.describe("Call a task then job commit twice;expect the second task commit to fail.");
        JobData jobData = this.startJob(true);
        JobContext jContext = jobData.jContext;
        TaskAttemptContext tContext = jobData.tContext;
        ManifestCommitter committer = jobData.committer;
        this.describe("committing task");
        committer.commitTask(tContext);
        committer.commitTask(tContext);
        this.describe("committing job");
        committer.commitJob(jContext);
        this.describe("commit complete\n");
        this.describe("cleanup");
        committer.cleanupJob(jContext);
        this.validateContent(this.outputDir, this.shouldExpectSuccessMarker(), committer.getJobUniqueId());
        this.describe("Attempting commit of the same task after job commit -expecting failure");
        TestManifestCommitProtocol.expectFNFEonTaskCommit(committer, tContext);
    }

    @Test
    public void testTwoTaskAttemptsCommit() throws Exception {
        this.describe("Commit two task attempts; expect the second attempt to succeed.");
        JobData jobData = this.startJob(false);
        TaskAttemptContext tContext = jobData.tContext;
        ManifestCommitter committer = jobData.committer;
        this.describe("\ncommitting task");
        Path outputTA1 = this.writeTextOutput(tContext);
        Configuration conf2 = jobData.conf;
        conf2.set("mapreduce.output.basename", "attempt2");
        String attempt2 = "attempt_" + this.jobId + "_m_000000_1";
        TaskAttemptID ta2 = TaskAttemptID.forName((String)attempt2);
        TaskAttemptContextImpl tContext2 = new TaskAttemptContextImpl(conf2, ta2);
        ManifestCommitter committer2 = this.localCommitterFactory.createCommitter((TaskAttemptContext)tContext2);
        this.setupCommitter(committer2, (TaskAttemptContext)tContext2);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)committer.getWorkPath()).describedAs("Working dir of %s", new Object[]{committer})).isNotEqualTo((Object)committer2.getWorkPath());
        Path outputTA2 = this.writeTextOutput((TaskAttemptContext)tContext2);
        String name1 = outputTA1.getName();
        String name2 = outputTA2.getName();
        ((AbstractStringAssert)Assertions.assertThat((String)name1).describedAs("name of task attempt output %s", new Object[]{outputTA1})).isNotEqualTo((Object)name2);
        committer.commitTask(tContext);
        committer2.commitTask((TaskAttemptContext)tContext2);
        committer2.commitJob((JobContext)tContext);
        FileSystem fs = this.getFileSystem();
        ManifestSuccessData successData = ManifestCommitterTestSupport.validateSuccessFile(fs, this.outputDir, 1, "");
        ((ListAssert)Assertions.assertThat((List)successData.getFilenames()).describedAs("Files committed", new Object[0])).hasSize(1);
        this.assertPathExists("attempt2 output", new Path(this.outputDir, name2));
        this.assertPathDoesNotExist("attempt1 output", new Path(this.outputDir, name1));
    }

    protected boolean shouldExpectSuccessMarker() {
        return true;
    }

    protected void expectJobCommitToFail(JobContext jContext, ManifestCommitter committer) throws Exception {
        TestManifestCommitProtocol.expectJobCommitFailure(jContext, committer, FileNotFoundException.class);
    }

    protected static <E extends IOException> E expectJobCommitFailure(JobContext jContext, ManifestCommitter committer, Class<E> clazz) throws Exception {
        return (E)((IOException)LambdaTestUtils.intercept(clazz, () -> {
            committer.commitJob(jContext);
            return committer.toString();
        }));
    }

    protected static void expectFNFEonTaskCommit(ManifestCommitter committer, TaskAttemptContext tContext) throws Exception {
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> {
            committer.commitTask(tContext);
            return committer.toString();
        });
    }

    @Test
    public void testCommitterWithNoOutputs() throws Exception {
        this.describe("Have a task and job with no outputs: expect success");
        JobData jobData = this.startJob(this.localCommitterFactory, false);
        TaskAttemptContext tContext = jobData.tContext;
        ManifestCommitter committer = jobData.committer;
        committer.commitTask(tContext);
        Path attemptPath = committer.getTaskAttemptPath(tContext);
        ContractTestUtils.assertPathExists((FileSystem)attemptPath.getFileSystem(tContext.getConfiguration()), (String)"task attempt dir", (Path)attemptPath);
    }

    @Test
    public void testMapFileOutputCommitter() throws Exception {
        this.describe("Test that the committer generates map output into a directory\nstarting with the prefix part-");
        JobData jobData = this.startJob(false);
        JobContext jContext = jobData.jContext;
        TaskAttemptContext tContext = jobData.tContext;
        ManifestCommitter committer = jobData.committer;
        Configuration conf = jobData.conf;
        this.writeMapFileOutput(new MapFileOutputFormat().getRecordWriter(tContext), tContext);
        this.commitTaskAndJob(committer, jContext, tContext);
        FileSystem fs = this.getFileSystem();
        TestManifestCommitProtocol.lsR(fs, this.outputDir, true);
        String ls = this.ls(this.outputDir);
        this.describe("\nvalidating");
        this.verifySuccessMarker(this.outputDir, committer.getJobUniqueId());
        this.describe("validate output of %s", this.outputDir);
        this.validateMapFileOutputContent(fs, this.outputDir);
        this.describe("listing");
        Object[] filtered = fs.listStatus(this.outputDir, HIDDEN_FILE_FILTER);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filtered).describedAs("listed children under %s", new Object[]{ls})).hasSize(1);
        Object fileStatus = filtered[0];
        ((AbstractStringAssert)Assertions.assertThat((String)fileStatus.getPath().getName()).as("Not the part file: " + (FileStatus)fileStatus, new Object[0])).startsWith((CharSequence)PART_00000);
        this.describe("getReaders()");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])TestManifestCommitProtocol.getReaders(fs, this.outputDir, conf)).describedAs("getReaders() MapFile.Reader entries with shared FS %s %s", new Object[]{this.outputDir, ls})).hasSize(1);
        this.describe("getReaders(new FS)");
        FileSystem fs2 = FileSystem.get((URI)this.outputDir.toUri(), (Configuration)conf);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])TestManifestCommitProtocol.getReaders(fs2, this.outputDir, conf)).describedAs("getReaders(new FS) %s %s", new Object[]{this.outputDir, ls})).hasSize(1);
        this.describe("MapFileOutputFormat.getReaders");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])MapFileOutputFormat.getReaders((Path)this.outputDir, (Configuration)conf)).describedAs("MapFileOutputFormat.getReaders(%s) %s", new Object[]{this.outputDir, ls})).hasSize(1);
    }

    private static MapFile.Reader[] getReaders(FileSystem fs, Path dir, Configuration conf) throws IOException {
        Object[] names = FileUtil.stat2Paths((FileStatus[])fs.listStatus(dir, HIDDEN_FILE_FILTER));
        Arrays.sort(names);
        MapFile.Reader[] parts = new MapFile.Reader[names.length];
        for (int i = 0; i < names.length; ++i) {
            parts[i] = new MapFile.Reader((Path)names[i], conf, new SequenceFile.Reader.Option[0]);
        }
        return parts;
    }

    @Test
    public void testAbortTaskNoWorkDone() throws Exception {
        this.executeWork("abort task no work", (job, jContext, tContext, committer) -> committer.abortTask(tContext));
    }

    @Test
    public void testAbortJobNoWorkDone() throws Exception {
        this.executeWork("abort task no work", (job, jContext, tContext, committer) -> committer.abortJob(jContext, JobStatus.State.RUNNING));
    }

    @Test
    public void testCommitJobButNotTask() throws Exception {
        this.executeWork("commit a job while a task's work is pending, expect task writes to be cancelled.", (job, jContext, tContext, committer) -> {
            this.writeTextOutput(tContext);
            this.createCommitter(tContext).commitJob((JobContext)tContext);
            this.assertPart0000DoesNotExist(this.outputDir);
        });
    }

    @Test
    public void testAbortTaskThenJob() throws Exception {
        JobData jobData = this.startJob(true);
        ManifestCommitter committer = jobData.committer;
        committer.abortTask(jobData.tContext);
        LambdaTestUtils.intercept(FileNotFoundException.class, (String)"", () -> this.getPart0000(committer.getWorkPath()));
        committer.abortJob(jobData.jContext, JobStatus.State.FAILED);
        this.assertJobAbortCleanedUp(jobData);
    }

    public void assertJobAbortCleanedUp(JobData jobData) throws Exception {
        FileSystem fs = this.getFileSystem();
        try {
            Object[] children = ContractTestUtils.listChildren((FileSystem)fs, (Path)this.outputDir);
            if (children.length != 0) {
                TestManifestCommitProtocol.lsR(fs, this.outputDir, true);
            }
            ((ObjectArrayAssert)Assertions.assertThat((Object[])children).as("Output directory not empty " + this.ls(this.outputDir), new Object[0])).containsExactly((Object[])new FileStatus[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFailAbort() throws Exception {
        this.describe("Abort the task, then job (failed), abort the job again");
        JobData jobData = this.startJob(true);
        JobContext jContext = jobData.jContext;
        TaskAttemptContext tContext = jobData.tContext;
        ManifestCommitter committer = jobData.committer;
        committer.abortTask(tContext);
        committer.getJobAttemptPath(jContext);
        committer.getTaskAttemptPath(tContext);
        this.assertPart0000DoesNotExist(this.outputDir);
        this.assertSuccessMarkerDoesNotExist(this.outputDir);
        this.describe("Aborting job into %s", this.outputDir);
        committer.abortJob(jContext, JobStatus.State.FAILED);
        this.assertTaskAttemptPathDoesNotExist(committer, tContext);
        this.assertJobAttemptPathDoesNotExist(committer, jContext);
        ManifestSuccessData report = this.loadReport(jobData.jobId(), false);
        Map diag = report.getDiagnostics();
        ((MapAssert)Assertions.assertThat((Map)diag).describedAs("Stage entry in report", new Object[0])).containsEntry((Object)"stage", (Object)"job_stage_abort");
        IOStatisticsSnapshot reportStats = report.getIOStatistics();
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)reportStats, (String)"job_stage_abort", (long)1L);
        committer.abortJob(jContext, JobStatus.State.FAILED);
    }

    protected void assertSuccessMarkerDoesNotExist(Path dir) throws IOException {
        this.assertPathDoesNotExist("Success marker", new Path(dir, "_SUCCESS"));
    }

    public void assertPart0000DoesNotExist(Path dir) throws Exception {
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.getPart0000(dir));
        this.assertPathDoesNotExist("expected output file", new Path(dir, PART_00000));
    }

    @Test
    public void testAbortJobNotTask() throws Exception {
        this.executeWork("abort task no work", (job, jContext, tContext, committer) -> {
            this.writeTextOutput(tContext);
            committer.abortJob(jContext, JobStatus.State.RUNNING);
            this.assertTaskAttemptPathDoesNotExist(committer, tContext);
            this.assertJobAttemptPathDoesNotExist(committer, jContext);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentCommitTaskWithSubDir() throws Exception {
        Job job = this.newJob();
        FileOutputFormat.setOutputPath((Job)job, (Path)this.outputDir);
        Configuration conf = job.getConfiguration();
        JobContextImpl jContext = new JobContextImpl(conf, this.taskAttempt0.getJobID());
        ManifestCommitter amCommitter = this.createCommitter((TaskAttemptContext)new TaskAttemptContextImpl(conf, this.taskAttempt0));
        amCommitter.setupJob((JobContext)jContext);
        TaskAttemptContextImpl[] taCtx = new TaskAttemptContextImpl[]{new TaskAttemptContextImpl(conf, this.taskAttempt0), new TaskAttemptContextImpl(conf, this.taskAttempt1)};
        TextOutputFormat[] tof = new TextOutputForTests[2];
        for (int i = 0; i < tof.length; ++i) {
            tof[i] = new TextOutputForTests<Writable, Object>(){

                public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
                    ManifestCommitter foc = (ManifestCommitter)this.getOutputCommitter(context);
                    return new Path(new Path(foc.getWorkPath(), TestManifestCommitProtocol.SUB_DIR), 1.getUniqueFile((TaskAttemptContext)context, (String)1.getOutputName((JobContext)context), (String)extension));
                }
            };
        }
        ExecutorService executor = HadoopExecutors.newFixedThreadPool((int)2);
        try {
            int i = 0;
            while (i < taCtx.length) {
                int taskIdx = i++;
                executor.submit(() -> this.lambda$testConcurrentCommitTaskWithSubDir$12(tof, taskIdx, (TaskAttemptContext[])taCtx));
            }
        }
        finally {
            executor.shutdown();
            while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.log().info("Awaiting thread termination!");
            }
        }
        this.describe("\nCommitting Job");
        amCommitter.commitJob((JobContext)jContext);
        this.assertPathExists("base output directory", this.outputDir);
        this.assertPart0000DoesNotExist(this.outputDir);
        Path outSubDir = new Path(this.outputDir, SUB_DIR);
        this.assertPathDoesNotExist("Must not end up with sub_dir/sub_dir", new Path(outSubDir, SUB_DIR));
        this.validateContent(outSubDir, false, "");
    }

    @Test
    public void testUnsupportedSchema() throws Throwable {
        LambdaTestUtils.intercept(PathIOException.class, () -> new ManifestCommitterFactory().createOutputCommitter(new Path("s3a://unsupported/"), null));
    }

    @Test
    public void testOutputFormatIntegration() throws Throwable {
        Configuration conf = this.getConfiguration();
        Job job = this.newJob();
        this.assertCommitterFactoryIsManifestCommitter((JobContext)job, this.outputDir);
        job.setOutputFormatClass(TextOutputForTests.class);
        conf = job.getConfiguration();
        conf.set("mapreduce.task.attempt.id", this.attempt0);
        conf.setInt("mapreduce.job.application.attempt.id", 1);
        JobContextImpl jContext = new JobContextImpl(conf, this.taskAttempt0.getJobID());
        TaskAttemptContextImpl tContext = new TaskAttemptContextImpl(conf, this.taskAttempt0);
        TextOutputForTests outputFormat = (TextOutputForTests)((Object)ReflectionUtils.newInstance((Class)tContext.getOutputFormatClass(), (Configuration)conf));
        ManifestCommitter committer = (ManifestCommitter)outputFormat.getOutputCommitter((TaskAttemptContext)tContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)committer.hasCapability("mapreduce.job.committer.dynamic.partitioning")).describedAs("dynamic partitioning capability in committer %s", new Object[]{committer})).isTrue();
        BindingPathOutputCommitter bindingCommitter = new BindingPathOutputCommitter(this.outputDir, (TaskAttemptContext)tContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)bindingCommitter.hasCapability("mapreduce.job.committer.dynamic.partitioning")).describedAs("dynamic partitioning capability in committer %s", new Object[]{bindingCommitter})).isTrue();
        JobData jobData = new JobData(job, (JobContext)jContext, (TaskAttemptContext)tContext, committer);
        this.setupJob(jobData);
        this.abortInTeardown(jobData);
        TextOutputForTests.LoggingLineRecordWriter<IntWritable, IntWritable> recordWriter = outputFormat.getRecordWriter((TaskAttemptContext)tContext);
        IntWritable iw = new IntWritable(1);
        recordWriter.write(iw, iw);
        long expectedLength = 4L;
        Path dest = recordWriter.getDest();
        this.validateTaskAttemptPathDuringWrite(dest, expectedLength);
        recordWriter.close((TaskAttemptContext)tContext);
        this.validateTaskAttemptPathAfterWrite(dest, expectedLength);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)committer.needsTaskCommit((TaskAttemptContext)tContext)).as("Committer does not have data to commit " + committer, new Object[0])).isTrue();
        this.commitTask(committer, (TaskAttemptContext)tContext);
        IOStatisticsSnapshot snapshot = new IOStatisticsSnapshot((IOStatistics)committer.getIOStatistics());
        String commitsCompleted = "committer_tasks_completed";
        LOG.info("after task commit {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)snapshot));
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)snapshot, (String)commitsCompleted, (long)1L);
        TaskManifest manifest = this.loadManifest(committer.getTaskManifestPath((TaskAttemptContext)tContext));
        LOG.info("Manifest {}", (Object)manifest.toJson());
        this.commitJob(committer, (JobContext)jContext);
        LOG.info("committer iostatistics {}", (Object)IOStatisticsLogging.ioStatisticsSourceToString((Object)committer));
        ManifestSuccessData successData = this.verifySuccessMarker(this.outputDir, committer.getJobUniqueId());
        IOStatisticsSnapshot successStats = successData.getIOStatistics();
        LOG.info("loaded statistics {}", (Object)successStats);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)successStats, (String)commitsCompleted, (long)1L);
    }

    @Test
    public void testAMWorkflow() throws Throwable {
        this.describe("Create a committer with a null output path & use as an AM");
        JobData jobData = this.startJob(true);
        JobContext jContext = jobData.jContext;
        TaskAttemptContext tContext = jobData.tContext;
        TaskAttemptContextImpl newAttempt = new TaskAttemptContextImpl(jContext.getConfiguration(), this.taskAttempt0);
        Configuration conf = jContext.getConfiguration();
        TextOutputForTests.bind(conf);
        OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)newAttempt.getOutputFormatClass(), (Configuration)conf);
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)newAttempt);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)outputPath).as("null output path in new task attempt", new Object[0])).isNotNull();
        ManifestCommitter committer2 = (ManifestCommitter)outputFormat.getOutputCommitter((TaskAttemptContext)newAttempt);
        committer2.abortTask(tContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelJobsToAdjacentPaths() throws Throwable {
        this.describe("Run two jobs in parallel, assert they both complete");
        JobData jobData = this.startJob(true);
        Job job1 = jobData.job;
        ManifestCommitter committer1 = jobData.committer;
        JobContext jContext1 = jobData.jContext;
        TaskAttemptContext tContext1 = jobData.tContext;
        String jobId2 = ManifestCommitterTestSupport.randomJobId();
        String attempt20 = "attempt_" + jobId2 + "_m_000000_0";
        TaskAttemptID taskAttempt20 = TaskAttemptID.forName((String)attempt20);
        String attempt21 = "attempt_" + jobId2 + "_m_000001_0";
        TaskAttemptID taskAttempt21 = TaskAttemptID.forName((String)attempt21);
        Path job1Dest = this.outputDir;
        Path job2Dest = new Path(this.getOutputDir().getParent(), this.getMethodName() + "job2Dest");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)job2Dest).describedAs("Job destinations", new Object[0])).isNotEqualTo((Object)job1Dest);
        Job job2 = this.newJob(job2Dest, this.unsetUUIDOptions((Configuration)new JobConf(this.getConfiguration())), attempt20);
        Configuration conf2 = job2.getConfiguration();
        conf2.setInt("mapreduce.job.application.attempt.id", 1);
        ManifestCommitter committer2 = null;
        try {
            JobContextImpl jContext2 = new JobContextImpl(conf2, taskAttempt20.getJobID());
            TaskAttemptContextImpl tContext2 = new TaskAttemptContextImpl(conf2, taskAttempt20);
            committer2 = this.createCommitter(job2Dest, (TaskAttemptContext)tContext2);
            JobData jobData2 = new JobData(job2, (JobContext)jContext2, (TaskAttemptContext)tContext2, committer2);
            this.setupJob(jobData2);
            this.abortInTeardown(jobData2);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)committer1.getOutputPath()).describedAs("Committer output path of %s and %s", new Object[]{committer1, committer2})).isNotEqualTo((Object)committer2.getOutputPath());
            ((AbstractStringAssert)Assertions.assertThat((String)committer1.getJobUniqueId()).describedAs("JobUnique IDs of %s and %s", new Object[]{committer1, committer2})).isNotEqualTo((Object)committer2.getJobUniqueId());
            this.writeTextOutput((TaskAttemptContext)tContext2);
            this.commitTask(committer2, (TaskAttemptContext)tContext2);
            this.commitTask(committer1, tContext1);
            this.commitJob(committer1, jContext1);
            this.getPart0000(job1Dest);
            this.commitJob(committer2, (JobContext)jContext2);
            this.getPart0000(job2Dest);
        }
        finally {
            FileSystem fs = this.getFileSystem();
            if (committer1 != null) {
                fs.delete(committer1.getOutputPath(), true);
            }
            if (committer2 != null) {
                fs.delete(committer2.getOutputPath(), true);
            }
        }
    }

    protected Configuration unsetUUIDOptions(Configuration conf) {
        conf.unset("spark.sql.sources.writeJobUUID");
        return conf;
    }

    protected void assertJobAttemptPathExists(ManifestCommitter committer, JobContext jobContext) throws IOException {
        Path attemptPath = committer.getJobAttemptPath(jobContext);
        ContractTestUtils.assertIsDirectory((FileSystem)attemptPath.getFileSystem(committer.getConf()), (Path)attemptPath);
    }

    protected void validateTaskAttemptPathDuringWrite(Path p, long expectedLength) throws IOException {
    }

    protected void validateTaskAttemptPathAfterWrite(Path p, long expectedLength) throws IOException {
    }

    protected void validateTaskAttemptWorkingDirectory(ManifestCommitter committer, TaskAttemptContext context) throws IOException {
    }

    protected void commitTask(ManifestCommitter committer, TaskAttemptContext tContext) throws IOException {
        committer.commitTask(tContext);
    }

    protected void commitJob(ManifestCommitter committer, JobContext jContext) throws IOException {
        committer.commitJob(jContext);
    }

    private /* synthetic */ Object lambda$testConcurrentCommitTaskWithSubDir$12(TextOutputFormat[] tof, int taskIdx, TaskAttemptContext[] taCtx) throws Exception {
        OutputCommitter outputCommitter = tof[taskIdx].getOutputCommitter(taCtx[taskIdx]);
        outputCommitter.setupTask(taCtx[taskIdx]);
        this.writeOutput((RecordWriter<Writable, Object>)tof[taskIdx].getRecordWriter(taCtx[taskIdx]), taCtx[taskIdx]);
        this.describe("Committing Task %d", taskIdx);
        outputCommitter.commitTask(taCtx[taskIdx]);
        return null;
    }

    private static /* synthetic */ void lambda$testRecoveryAndCleanup$0(ManifestCommitter committer2, TaskAttemptContext tContext2) throws Exception {
        committer2.recoverTask(tContext2);
    }

    protected class LocalCommitterFactory
    implements CommitterFactory {
        protected LocalCommitterFactory() {
        }

        @Override
        public ManifestCommitter createCommitter(TaskAttemptContext context) throws IOException {
            return TestManifestCommitProtocol.this.createCommitter(context);
        }
    }

    protected static final class JobData {
        private final Job job;
        private final JobContext jContext;
        private final TaskAttemptContext tContext;
        private final ManifestCommitter committer;
        private final Configuration conf;
        private Path writtenTextPath;

        public JobData(Job job, JobContext jContext, TaskAttemptContext tContext, ManifestCommitter committer) {
            this.job = job;
            this.jContext = jContext;
            this.tContext = tContext;
            this.committer = committer;
            this.conf = job.getConfiguration();
        }

        public String jobId() {
            return this.committer.getJobUniqueId();
        }
    }

    @FunctionalInterface
    public static interface CommitterFactory {
        public ManifestCommitter createCommitter(TaskAttemptContext var1) throws IOException;
    }

    @FunctionalInterface
    public static interface ActionToTest {
        public void exec(Job var1, JobContext var2, TaskAttemptContext var3, ManifestCommitter var4) throws Exception;
    }
}

