/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConstants;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterTestSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.LoadedManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.OutputValidationException;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbortTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CommitJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CommitTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.LoadManifestsStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.ValidateRenamedFilesStage;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ProxyableObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
public class TestJobThroughManifestCommitter
extends AbstractManifestCommitterTest {
    private Path destDir;
    private ManifestCommitterSupport.AttemptDirectories dirs;
    private static Path sharedTestRoot = null;
    private String jobId;
    private String taskAttempt00;
    private String taskAttempt01;
    private String taskAttempt10;
    private String taskAttempt11;
    private StageConfig ta00Config;
    private StageConfig ta01Config;
    private StageConfig ta10Config;
    private StageConfig ta11Config;
    private static LoadedManifestData loadedManifestData;

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.taskAttempt00 = TASK_IDS.getTaskAttempt(0, 0);
        this.taskAttempt01 = TASK_IDS.getTaskAttempt(0, 1);
        this.taskAttempt10 = TASK_IDS.getTaskAttempt(1, 0);
        this.taskAttempt11 = TASK_IDS.getTaskAttempt(1, 1);
        TestJobThroughManifestCommitter.setSharedPath(this.path("TestJobThroughManifestCommitter"));
        this.destDir = new Path(sharedTestRoot, "out put");
        this.jobId = TASK_IDS.getJobId();
        this.dirs = new ManifestCommitterSupport.AttemptDirectories(this.destDir, this.jobId, 1);
        this.setJobStageConfig(this.createStageConfigForJob(1, this.destDir).build());
        this.ta00Config = this.createStageConfig(1, 0, 0, this.destDir).build();
        this.ta01Config = this.createStageConfig(1, 0, 1, this.destDir).build();
        this.ta10Config = this.createStageConfig(1, 1, 0, this.destDir).build();
        this.ta11Config = this.createStageConfig(1, 1, 1, this.destDir).build();
    }

    protected void deleteTestDirInTeardown() throws IOException {
    }

    protected boolean shouldDeleteTestRootAtEndOfTestRun() {
        return false;
    }

    private void deleteSharedTestRoot() throws IOException {
        this.describe("Deleting shared test root %s", sharedTestRoot);
        ContractTestUtils.rm((FileSystem)this.getFileSystem(), (Path)sharedTestRoot, (boolean)true, (boolean)false);
    }

    private static synchronized boolean setSharedPath(Path path) {
        if (sharedTestRoot == null) {
            LOG.info("Set shared path to {}", (Object)path);
            sharedTestRoot = path;
            return true;
        }
        return false;
    }

    @Test
    public void test_0000_setupTestDir() throws Throwable {
        this.describe("always ensure directory setup is empty");
        this.deleteSharedTestRoot();
    }

    @Test
    public void test_0100_setupJobStage() throws Throwable {
        this.describe("Set up a job");
        this.verifyPath("Job attempt dir", this.dirs.getJobAttemptDir(), (Path)new SetupJobStage(this.getJobStageConfig()).apply((Object)true));
    }

    private void verifyJobSetupCompleted() throws IOException {
        this.assertPathExists("Job attempt dir from test_0100", this.dirs.getJobAttemptDir());
    }

    @Test
    public void test_0110_setupJobOnlyAllowedOnce() throws Throwable {
        this.describe("a second creation of a job attempt must fail");
        this.verifyJobSetupCompleted();
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, (String)"", () -> (Path)new SetupJobStage(this.getJobStageConfig()).apply((Object)true));
        this.assertPathExists("Job attempt dir", this.dirs.getJobAttemptDir());
    }

    @Test
    public void test_0120_setupJobNewAttemptNumber() throws Throwable {
        this.describe("Creating a new job attempt is supported");
        this.verifyJobSetupCompleted();
        Path path = this.pathMustExist("Job attempt 2 dir", (Path)new SetupJobStage(this.createStageConfig(2, -1, 0, this.destDir)).apply((Object)false));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)path).describedAs("Stage created path", new Object[0])).isNotEqualTo((Object)this.dirs.getJobAttemptDir());
    }

    @Test
    public void test_0200_setupTask00() throws Throwable {
        this.describe("Set up a task; job must have been set up first");
        this.verifyJobSetupCompleted();
        this.verifyPath("Task attempt 00", this.dirs.getTaskAttemptPath(this.taskAttempt00), (Path)new SetupTaskStage(this.ta00Config).apply((Object)"first"));
    }

    private void verifyTaskAttempt00SetUp() throws IOException {
        this.pathMustExist("Dir from taskAttempt00 setup", this.dirs.getTaskAttemptPath(this.taskAttempt00));
    }

    @Test
    public void test_0210_setupTask00OnlyAllowedOnce() throws Throwable {
        this.describe("Second attempt to set up task00 must fail.");
        this.verifyTaskAttempt00SetUp();
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, (String)"second", () -> (Path)new SetupTaskStage(this.ta00Config).apply((Object)"second"));
    }

    @Test
    public void test_0220_setupTask01() throws Throwable {
        this.describe("Setup task attempt 01");
        this.verifyTaskAttempt00SetUp();
        this.verifyPath("Task attempt 01", this.dirs.getTaskAttemptPath(this.taskAttempt01), (Path)new SetupTaskStage(this.ta01Config).apply((Object)"01"));
    }

    @Test
    public void test_0230_setupTask10() throws Throwable {
        this.describe("Setup task attempt 10");
        this.verifyJobSetupCompleted();
        this.verifyPath("Task attempt 10", this.dirs.getTaskAttemptPath(this.taskAttempt10), (Path)new SetupTaskStage(this.ta10Config).apply((Object)"10"));
    }

    @Test
    public void test_0240_setupThenAbortTask11() throws Throwable {
        this.describe("Setup then abort task attempt 11");
        this.verifyJobSetupCompleted();
        Path ta11Path = (Path)new SetupTaskStage(this.ta11Config).apply((Object)"11");
        Path deletedDir = (Path)new AbortTaskStage(this.ta11Config).apply((Object)false);
        Assertions.assertThat((Comparable)ta11Path).isEqualTo((Object)deletedDir);
        this.assertPathDoesNotExist("aborted directory", ta11Path);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (CommitTaskStage.Result)new CommitTaskStage(this.ta11Config).apply(null));
        this.assertPathDoesNotExist("task manifest", ManifestCommitterSupport.manifestPathForTask((Path)this.dirs.getTaskManifestDir(), (String)TASK_IDS.getTaskId(1)));
    }

    @Test
    public void test_0300_executeTask00() throws Throwable {
        this.describe("Create the files for Task 00, then commit the task");
        List<Path> files = this.createFilesOrDirs(this.dirs.getTaskAttemptPath(this.taskAttempt00), "part-00", this.getExecutorService(), 3, 2, 4, false);
        CommitTaskStage.Result result = (CommitTaskStage.Result)new CommitTaskStage(this.ta00Config).apply(null);
        ContractTestUtils.verifyPathExists((FileSystem)this.getFileSystem(), (String)"manifest", (Path)result.getPath());
        TaskManifest manifest = result.getTaskManifest();
        manifest.validate();
        manifest.setIOStatistics(null);
        LOG.info("Task Manifest {}", (Object)manifest.toJson());
        this.validateTaskAttemptManifest(this.taskAttempt00, files, manifest);
    }

    protected void validateTaskAttemptManifest(String attemptId, List<Path> files, TaskManifest manifest) throws IOException {
        this.verifyManifestTaskAttemptID(manifest, attemptId);
        this.verifyManifestFilesMatch(manifest, files);
    }

    @Test
    public void test_0310_executeTask01() throws Throwable {
        this.describe("Create the files for Task 01, then commit the task");
        List<Path> files = this.createFilesOrDirs(this.dirs.getTaskAttemptPath(this.taskAttempt01), "part-00", this.getExecutorService(), 3, 2, 4, false);
        CommitTaskStage.Result result = (CommitTaskStage.Result)new CommitTaskStage(this.ta01Config).apply(null);
        Path manifestPath = ContractTestUtils.verifyPathExists((FileSystem)this.getFileSystem(), (String)"manifest", (Path)result.getPath()).getPath();
        TaskManifest manifest = TaskManifest.load((FileSystem)this.getFileSystem(), (Path)manifestPath);
        manifest.validate();
        manifest.setIOStatistics(null);
        LOG.info("Task Manifest {}", (Object)manifest.toJson());
        this.validateTaskAttemptManifest(this.taskAttempt01, files, manifest);
    }

    @Test
    public void test_0320_executeTask10() throws Throwable {
        this.describe("Create the files for Task 10, then commit the task");
        List<Path> files = this.createFilesOrDirs(this.dirs.getTaskAttemptPath(this.ta10Config.getTaskAttemptId()), "part-01", this.getExecutorService(), 3, 3, 3, false);
        CommitTaskStage.Result result = (CommitTaskStage.Result)new CommitTaskStage(this.ta10Config).apply(null);
        TaskManifest manifest = result.getTaskManifest();
        this.validateTaskAttemptManifest(this.taskAttempt10, files, manifest);
    }

    @Test
    public void test_0340_setupThenAbortTask11() throws Throwable {
        this.describe("Setup then abort task attempt 11");
        Path ta11Path = (Path)new SetupTaskStage(this.ta11Config).apply((Object)"11");
        this.createFilesOrDirs(ta11Path, "part-01", this.getExecutorService(), 2, 1, 1, false);
        new AbortTaskStage(this.ta11Config).apply((Object)false);
        this.assertPathDoesNotExist("aborted directory", ta11Path);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (CommitTaskStage.Result)new CommitTaskStage(this.ta11Config).apply(null));
        Path manifestPathForTask1 = ManifestCommitterSupport.manifestPathForTask((Path)this.dirs.getTaskManifestDir(), (String)TASK_IDS.getTaskId(1));
        this.verifyManifestTaskAttemptID(TaskManifest.load((FileSystem)this.getFileSystem(), (Path)manifestPathForTask1), this.taskAttempt10);
    }

    @Test
    public void test_0400_loadManifests() throws Throwable {
        this.describe("Load all manifests; committed must be TA01 and TA10");
        File entryFile = File.createTempFile("entry", ".seq");
        LoadManifestsStage.Arguments args = new LoadManifestsStage.Arguments(entryFile, 32);
        LoadManifestsStage.Result result = (LoadManifestsStage.Result)new LoadManifestsStage(this.getJobStageConfig()).apply((Object)args);
        loadedManifestData = result.getLoadedManifestData();
        ((ObjectAssert)Assertions.assertThat((Object)loadedManifestData).describedAs("manifest data from %s", new Object[]{result})).isNotNull();
        LoadManifestsStage.SummaryInfo stageSummary = result.getSummary();
        String summary = stageSummary.toString();
        LOG.info("Manifest summary {}", (Object)summary);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)stageSummary.getTaskAttemptIDs()).describedAs("Task attempts in %s", new Object[]{summary})).hasSize(2)).contains((Object[])new String[]{this.taskAttempt01, this.taskAttempt10});
    }

    @Test
    public void test_0410_commitJob() throws Throwable {
        this.describe("Commit the job");
        CommitJobStage stage = new CommitJobStage(this.getJobStageConfig());
        stage.apply((Object)new CommitJobStage.Arguments(true, false, null, CleanupJobStage.DISABLED));
    }

    @Test
    public void test_0420_validateJob() throws Throwable {
        this.describe("Validate the output of the job through the validation stage");
        ((ProxyableObjectAssert)Assumptions.assumeThat((Object)loadedManifestData).describedAs("Loaded Manifest Data from earlier stage", new Object[0])).isNotNull();
        ManifestSuccessData successData = ManifestCommitterTestSupport.loadAndPrintSuccessData(this.getFileSystem(), this.getJobStageConfig().getJobSuccessMarkerPath());
        List validatedEntries = (List)new ValidateRenamedFilesStage(this.getJobStageConfig()).apply((Object)loadedManifestData.getEntrySequenceData());
        List committedFiles = validatedEntries.stream().map(FileEntry::getDest).collect(Collectors.toList());
        Assertions.assertThat(committedFiles).containsAll((Iterable)successData.getFilenames());
    }

    @Test
    public void test_0430_validateStatistics() throws Throwable {
        ManifestSuccessData successData = ManifestSuccessData.load((FileSystem)this.getFileSystem(), (Path)this.getJobStageConfig().getJobSuccessMarkerPath());
        String json = successData.toJson();
        LOG.info("Success data is {}", (Object)json);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)successData).describedAs("Manifest " + json, new Object[0])).returns((Object)NetUtils.getLocalHostname(), ManifestSuccessData::getHostname)).returns((Object)ManifestCommitterConstants.MANIFEST_COMMITTER_CLASSNAME, ManifestSuccessData::getCommitter)).returns((Object)this.jobId, ManifestSuccessData::getJobId)).returns((Object)true, ManifestSuccessData::getSuccess)).returns((Object)"JobID", ManifestSuccessData::getJobIdSource);
        ((MapAssert)Assertions.assertThat((Map)successData.getDiagnostics()).containsEntry((Object)"principal", (Object)UserGroupInformation.getCurrentUser().getShortUserName())).containsEntry((Object)"stage", (Object)"committer_commit_job");
        IOStatisticsSnapshot iostats = successData.getIOStatistics();
        int files = successData.getFilenames().size();
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)iostats, (String)"committer_commit_job", (long)1L);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)iostats, (String)"committer_files_committed").isGreaterThanOrEqualTo((long)files);
        Long totalFiles = (Long)iostats.counters().get("committer_files_committed");
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)iostats, (String)"committer_bytes_committed", (long)(totalFiles * 2L));
    }

    @Test
    public void test_0440_validateSuccessFiles() throws Throwable {
        FileSystem fs = this.getFileSystem();
        ManifestSuccessData successData = ManifestCommitterTestSupport.loadAndPrintSuccessData(fs, this.getJobStageConfig().getJobSuccessMarkerPath());
        ManifestCommitterTestSupport.validateGeneratedFiles(fs, this.getJobStageConfig().getDestinationDir(), successData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_0450_validationDetectsFailures() throws Throwable {
        List validatedEntries = (List)new ValidateRenamedFilesStage(this.getJobStageConfig()).apply((Object)loadedManifestData.getEntrySequenceData());
        Path path = ((FileEntry)validatedEntries.get(0)).getDestPath();
        Path p2 = new Path(path.getParent(), path.getName() + "-renamed");
        FileSystem fs = this.getFileSystem();
        fs.rename(path, p2);
        try {
            LambdaTestUtils.intercept(OutputValidationException.class, () -> (List)new ValidateRenamedFilesStage(this.getJobStageConfig()).apply((Object)loadedManifestData.getEntrySequenceData()));
        }
        finally {
            fs.rename(p2, path);
        }
    }

    @Test
    public void test_0900_cleanupJob() throws Throwable {
        this.describe("Cleanup job");
        CleanupJobStage.Arguments arguments = new CleanupJobStage.Arguments("job_stage_cleanup", true, true, false, false, 0L);
        CleanupJobStage.Result result = (CleanupJobStage.Result)new CleanupJobStage(this.getJobStageConfig()).apply((Object)arguments);
        this.assertCleanupResult(result, CleanupJobStage.Outcome.PARALLEL_DELETE, 4);
        this.assertPathDoesNotExist("Job attempt dir", result.getDirectory());
        result = (CleanupJobStage.Result)new CleanupJobStage(this.getJobStageConfig()).apply((Object)arguments);
        this.assertCleanupResult(result, CleanupJobStage.Outcome.NOTHING_TO_CLEAN_UP, 0);
    }

    @Test
    public void test_9999_cleanupTestDir() throws Throwable {
        if (this.shouldDeleteTestRootAtEndOfTestRun()) {
            this.deleteSharedTestRoot();
        }
    }
}

