/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.UnreliableManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCleanupStage
extends AbstractManifestCommitterTest {
    protected static final int TASK_ATTEMPT_COUNT = 10;
    protected static final int ROOT_DELETE_COUNT = 1;
    protected static final int PARALLEL_DELETE_COUNT = 11;
    private UnreliableManifestStoreOperations failures;
    private List<TaskManifest> manifests;

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.failures = new UnreliableManifestStoreOperations(this.createManifestStoreOperations());
        this.setStoreOperations(this.failures);
        Path destDir = this.methodPath();
        StageConfig stageConfig = this.createStageConfigForJob(1, destDir);
        this.setJobStageConfig(stageConfig);
        new SetupJobStage(stageConfig).apply((Object)true);
        this.manifests = this.executeTaskAttempts(10, 0);
    }

    @Test
    public void testCleanupInParallelHealthy() throws Throwable {
        this.describe("parallel cleanup of TA dirs.");
        this.cleanup(true, true, false, false, CleanupJobStage.Outcome.PARALLEL_DELETE, 11);
        this.verifyJobDirsCleanedUp();
    }

    @Test
    public void testCleanupInParallelHealthyBaseFirst() throws Throwable {
        this.describe("parallel cleanup of TA dirs with base first: one operation");
        this.cleanup(true, true, true, false, CleanupJobStage.Outcome.DELETED, 1);
        this.verifyJobDirsCleanedUp();
    }

    @Test
    public void testCleanupSingletonHealthy() throws Throwable {
        this.describe("Cleanup with a single delete. Not the default; would be best on HDFS");
        this.cleanup(true, false, false, false, CleanupJobStage.Outcome.DELETED, 1);
        this.verifyJobDirsCleanedUp();
    }

    @Test
    public void testCleanupNoDir() throws Throwable {
        this.describe("parallel cleanup MUST not fail if there's no dir");
        this.cleanup(true, true, false, false, CleanupJobStage.Outcome.PARALLEL_DELETE, 11);
        this.cleanup(true, false, false, false, CleanupJobStage.Outcome.NOTHING_TO_CLEAN_UP, 0);
        this.cleanup(true, true, true, false, CleanupJobStage.Outcome.NOTHING_TO_CLEAN_UP, 0);
        this.cleanup(false, true, false, false, CleanupJobStage.Outcome.DISABLED, 0);
    }

    @Test
    public void testFailureInParallelDelete() throws Throwable {
        this.describe("A parallel delete fails, but the fallback base delete works");
        TaskManifest manifest = this.manifests.get(4);
        this.failures.addDeletePathToFail(new Path(manifest.getTaskAttemptDir()));
        this.cleanup(true, true, false, false, CleanupJobStage.Outcome.DELETED, 11);
    }

    @Test
    public void testFailureInParallelBaseDelete() throws Throwable {
        this.describe("A parallel delete fails in the base delete; the parallel stage works");
        this.failures.addDeletePathToTimeOut(this.getJobStageConfig().getOutputTempSubDir());
        this.failures.setFailureLimit(1);
        this.cleanup(true, true, false, false, CleanupJobStage.Outcome.PARALLEL_DELETE, 11);
    }

    @Test
    public void testDoubleFailureInParallelBaseDelete() throws Throwable {
        this.describe("A parallel delete fails with the base delete and a task attempt dir");
        this.failures.addDeletePathToTimeOut(this.getJobStageConfig().getOutputTempSubDir());
        TaskManifest manifest = this.manifests.get(4);
        this.failures.addDeletePathToFail(new Path(manifest.getTaskAttemptDir()));
        this.failures.setFailureLimit(2);
        this.cleanup(true, true, true, false, CleanupJobStage.Outcome.DELETED, 12);
    }

    @Test
    public void testTripleFailureInParallelBaseDelete() throws Throwable {
        this.describe("All delete phases will fail");
        this.failures.addDeletePathToTimeOut(this.getJobStageConfig().getOutputTempSubDir());
        TaskManifest manifest = this.manifests.get(4);
        this.failures.addDeletePathToFail(new Path(manifest.getTaskAttemptDir()));
        this.failures.setFailureLimit(4);
        this.cleanup(true, true, true, true, CleanupJobStage.Outcome.FAILURE, 12);
    }

    @Test
    public void testParallelDeleteNoTaskAttemptDir() throws Throwable {
        this.describe("Execute parallel delete where the job task directory does not exist");
        StageConfig stageConfig = this.getJobStageConfig();
        this.failures.addPathNotFound(stageConfig.getJobAttemptTaskSubDir());
        this.cleanup(true, true, false, false, CleanupJobStage.Outcome.DELETED, 1);
    }
}

