/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterTestSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.Progressable;

class CommitterTestBinding
implements IOStatisticsSource {
    public static final String PROGRESS_EVENTS = "progress_events";
    private final IOStatisticsStore iostatistics = ManifestCommitterSupport.createIOStatisticsStore().withCounters(new String[]{"progress_events"}).build();
    private final String jobAttemptId;
    private final JobID jobId = JobID.forName((String)ManifestCommitterTestSupport.randomJobId());
    private final TaskAttemptID taskAttemptId;
    private final TaskID taskId;
    private final TaskAttemptContext taskAttemptContext;

    CommitterTestBinding(Configuration conf, int appAttempt, int taskNumber, int taskAttemptNumber) {
        this.jobAttemptId = this.jobId.toString() + "_ " + appAttempt;
        this.taskId = new TaskID(this.jobId, TaskType.MAP, taskNumber);
        this.taskAttemptId = new TaskAttemptID(this.taskId, taskAttemptNumber);
        conf.setInt("mapreduce.job.application.attempt.id", appAttempt);
        this.taskAttemptContext = new TaskAttemptContextImpl(conf, this.taskAttemptId);
    }

    ManifestCommitterConfig createCommitterConfig(Path outputPath) {
        return new ManifestCommitterConfig(outputPath, "task committer", (JobContext)this.taskAttemptContext, this.iostatistics, null);
    }

    StageConfig createStageConfig(Path outputPath) {
        return this.createCommitterConfig(outputPath).createStageConfig().withProgressable((Progressable)new ProgressCallback());
    }

    public IOStatisticsStore getIOStatistics() {
        return this.iostatistics;
    }

    private final class ProgressCallback
    implements Progressable {
        private ProgressCallback() {
        }

        public void progress() {
            CommitterTestBinding.this.iostatistics.incrementCounter(CommitterTestBinding.PROGRESS_EVENTS, 1L);
        }
    }
}

