/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.PartialFileOutputCommitter;
import org.apache.hadoop.mapreduce.task.annotation.Checkpointable;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestPreemptableFileOutputCommitter {
    @Test
    public void testPartialOutputCleanup() throws FileNotFoundException, IllegalArgumentException, IOException {
        Configuration conf = new Configuration(false);
        conf.setInt("mapreduce.job.application.attempt.id", 1);
        TaskAttemptID tid0 = new TaskAttemptID("1363718006656", 1, TaskType.REDUCE, 14, 3);
        Path p = (Path)Mockito.spy((Object)new Path("/user/hadoop/out"));
        Path a = new Path("hdfs://user/hadoop/out");
        Path p0 = new Path(a, "_temporary/1/attempt_1363718006656_0001_r_000014_0");
        Path p1 = new Path(a, "_temporary/1/attempt_1363718006656_0001_r_000014_1");
        Path p2 = new Path(a, "_temporary/1/attempt_1363718006656_0001_r_000013_0");
        Path p3 = new Path(a, "_temporary/1/attempt_1363718006656_0001_r_000014_2");
        FileStatus[] fsa = new FileStatus[3];
        fsa[0] = new FileStatus();
        fsa[0].setPath(p0);
        fsa[1] = new FileStatus();
        fsa[1].setPath(p1);
        fsa[2] = new FileStatus();
        fsa[2].setPath(p2);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs.exists((Path)Mockito.eq((Object)p0))).thenReturn((Object)true);
        Mockito.when((Object)fs.exists((Path)Mockito.eq((Object)p1))).thenReturn((Object)true);
        Mockito.when((Object)fs.exists((Path)Mockito.eq((Object)p2))).thenReturn((Object)true);
        Mockito.when((Object)fs.exists((Path)Mockito.eq((Object)p3))).thenReturn((Object)false);
        Mockito.when((Object)fs.delete((Path)Mockito.eq((Object)p0), Mockito.eq((boolean)true))).thenReturn((Object)true);
        Mockito.when((Object)fs.delete((Path)Mockito.eq((Object)p1), Mockito.eq((boolean)true))).thenReturn((Object)true);
        ((Path)Mockito.doReturn((Object)fs).when((Object)p)).getFileSystem((Configuration)Mockito.any(Configuration.class));
        Mockito.when((Object)fs.makeQualified((Path)Mockito.eq((Object)p))).thenReturn((Object)a);
        TaskAttemptContext context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)context.getTaskAttemptID()).thenReturn((Object)tid0);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)conf);
        TestPFOC foc = new TestPFOC(p, context, fs);
        foc.cleanUpPartialOutputForTask(context);
        ((FileSystem)Mockito.verify((Object)fs)).delete((Path)Mockito.eq((Object)p0), Mockito.eq((boolean)true));
        ((FileSystem)Mockito.verify((Object)fs)).delete((Path)Mockito.eq((Object)p1), Mockito.eq((boolean)true));
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).delete((Path)Mockito.eq((Object)p3), Mockito.eq((boolean)true));
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).delete((Path)Mockito.eq((Object)p2), Mockito.eq((boolean)true));
    }

    @Checkpointable
    static class TestPFOC
    extends PartialFileOutputCommitter {
        final FileSystem fs;

        TestPFOC(Path outputPath, TaskAttemptContext ctxt, FileSystem fs) throws IOException {
            super(outputPath, ctxt);
            this.fs = fs;
        }

        FileSystem fsFor(Path p, Configuration conf) {
            return this.fs;
        }
    }
}

