/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.BindingPathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitterFactory;
import org.apache.hadoop.mapreduce.lib.output.NamedCommitterFactory;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;
import org.apache.hadoop.mapreduce.lib.output.TestPathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPathOutputCommitterFactory
extends Assertions {
    private static final String HTTP_COMMITTER_FACTORY = String.format("mapreduce.outputcommitter.factory.scheme.%s", "http");
    private static final Path HTTP_PATH = new Path("http://hadoop.apache.org/");
    private static final Path HDFS_PATH = new Path("hdfs://localhost:8081/");
    private TaskAttemptID taskAttemptID = new TaskAttemptID("local", 0, TaskType.MAP, 1, 2);

    @Test
    public void testCommitterFactoryForSchema() throws Throwable {
        this.createCommitterFactory(SimpleCommitterFactory.class, HTTP_PATH, this.newBondedConfiguration());
    }

    @Test
    public void testCommitterFactoryFallbackDefault() throws Throwable {
        this.createCommitterFactory(FileOutputCommitterFactory.class, HDFS_PATH, this.newBondedConfiguration());
    }

    @Test
    public void testCommitterFallbackDefault() throws Throwable {
        this.createCommitter(FileOutputCommitter.class, HDFS_PATH, this.taskAttempt(this.newBondedConfiguration()));
    }

    @Test
    public void testCommitterFactoryOverride() throws Throwable {
        Configuration conf = this.newBondedConfiguration();
        conf.set("mapreduce.outputcommitter.factory.class", OtherFactory.class.getName());
        this.createCommitterFactory(OtherFactory.class, HDFS_PATH, conf);
        this.createCommitterFactory(OtherFactory.class, HTTP_PATH, conf);
    }

    @Test
    public void testCommitterFactoryEmptyOption() throws Throwable {
        Configuration conf = this.newBondedConfiguration();
        conf.set("mapreduce.outputcommitter.factory.class", "");
        this.createCommitterFactory(SimpleCommitterFactory.class, HTTP_PATH, conf);
        this.createCommitterFactory(FileOutputCommitterFactory.class, HDFS_PATH, conf);
    }

    @Test
    public void testCommitterFactoryUnknown() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("mapreduce.outputcommitter.factory.class", "unknown");
        LambdaTestUtils.intercept(RuntimeException.class, () -> PathOutputCommitterFactory.getCommitterFactory((Path)HDFS_PATH, (Configuration)conf));
    }

    @Test
    public void testCommitterNullOutputPath() throws Throwable {
        Configuration conf = this.newBondedConfiguration();
        FileOutputCommitter committer = this.createCommitter(FileOutputCommitterFactory.class, FileOutputCommitter.class, null, conf);
        TestPathOutputCommitterFactory.assertNull((Object)committer.getOutputPath());
        TestPathOutputCommitterFactory.assertNull((Object)committer.getWorkPath());
    }

    @Test
    public void testNamedCommitterFactory() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("mapreduce.outputcommitter.factory.class", "org.apache.hadoop.mapreduce.lib.output.NamedCommitterFactory");
        conf.set("mapreduce.outputcommitter.named.classname", SimpleCommitter.class.getName());
        SimpleCommitter sc = this.createCommitter(NamedCommitterFactory.class, SimpleCommitter.class, HDFS_PATH, conf);
        TestPathOutputCommitterFactory.assertEquals((Object)HDFS_PATH, (Object)sc.getOutputPath(), (String)("Wrong output path from " + sc));
    }

    @Test
    public void testNamedCommitterFactoryNullPath() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("mapreduce.outputcommitter.factory.class", "org.apache.hadoop.mapreduce.lib.output.NamedCommitterFactory");
        conf.set("mapreduce.outputcommitter.named.classname", SimpleCommitter.class.getName());
        SimpleCommitter sc = this.createCommitter(NamedCommitterFactory.class, SimpleCommitter.class, null, conf);
        TestPathOutputCommitterFactory.assertNull((Object)sc.getOutputPath());
    }

    @Test
    public void testNamedCommitterNullPath() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("mapreduce.outputcommitter.factory.class", "org.apache.hadoop.mapreduce.lib.output.NamedCommitterFactory");
        conf.set("mapreduce.outputcommitter.named.classname", SimpleCommitter.class.getName());
        SimpleCommitter sc = this.createCommitter(SimpleCommitter.class, null, this.taskAttempt(conf));
        TestPathOutputCommitterFactory.assertNull((Object)sc.getOutputPath());
    }

    private <T extends PathOutputCommitterFactory, U extends PathOutputCommitter> U createCommitter(Class<T> factoryClass, Class<U> committerClass, Path path, Configuration conf) throws IOException {
        T f = this.createCommitterFactory(factoryClass, path, conf);
        PathOutputCommitter committer = f.createOutputCommitter(path, this.taskAttempt(conf));
        TestPathOutputCommitterFactory.assertEquals(committerClass, committer.getClass(), (String)(" Wrong committer for path " + path + " from factory " + f));
        return (U)committer;
    }

    private <U extends PathOutputCommitter> U createCommitter(Class<U> committerClass, Path path, TaskAttemptContext context) throws IOException {
        PathOutputCommitter committer = PathOutputCommitterFactory.createCommitter((Path)path, (TaskAttemptContext)context);
        TestPathOutputCommitterFactory.assertEquals(committerClass, committer.getClass(), (String)(" Wrong committer for path " + path));
        return (U)committer;
    }

    private <T extends PathOutputCommitterFactory> T createCommitterFactory(Class<T> factoryClass, Path path, Configuration conf) {
        PathOutputCommitterFactory factory = PathOutputCommitterFactory.getCommitterFactory((Path)path, (Configuration)conf);
        TestPathOutputCommitterFactory.assertEquals(factoryClass, factory.getClass(), (String)(" Wrong factory for path " + path));
        return (T)factory;
    }

    private TaskAttemptContext taskAttempt(Configuration conf) {
        return new TaskAttemptContextImpl(conf, this.taskAttemptID);
    }

    @Test
    public void testFileOutputCommitterFactory() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("mapreduce.outputcommitter.factory.class", "org.apache.hadoop.mapreduce.lib.output.FileOutputCommitterFactory");
        conf.set("mapreduce.outputcommitter.named.classname", SimpleCommitter.class.getName());
        PathOutputCommitterFactory.getCommitterFactory((Path)HDFS_PATH, (Configuration)conf);
        this.createCommitter(FileOutputCommitterFactory.class, FileOutputCommitter.class, null, conf);
    }

    @Test
    public void testFileOutputFormatBinding() throws Throwable {
        Configuration conf = this.newBondedConfiguration();
        conf.set("mapreduce.output.fileoutputformat.outputdir", HTTP_PATH.toUri().toString());
        TextOutputFormat off = new TextOutputFormat();
        SimpleCommitter committer = (SimpleCommitter)off.getOutputCommitter(this.taskAttempt(conf));
        TestPathOutputCommitterFactory.assertEquals((Object)HTTP_PATH, (Object)committer.getOutputPath(), (String)("Wrong output path from " + committer));
    }

    @Test
    public void testFileOutputFormatBindingNoPath() throws Throwable {
        Configuration conf = new Configuration();
        conf.unset("mapreduce.output.fileoutputformat.outputdir");
        conf.set("mapreduce.outputcommitter.factory.class", "org.apache.hadoop.mapreduce.lib.output.NamedCommitterFactory");
        conf.set("mapreduce.outputcommitter.named.classname", SimpleCommitter.class.getName());
        this.httpToSimpleFactory(conf);
        TextOutputFormat off = new TextOutputFormat();
        SimpleCommitter committer = (SimpleCommitter)off.getOutputCommitter(this.taskAttempt(conf));
        TestPathOutputCommitterFactory.assertNull((Object)committer.getOutputPath(), (String)("Output path from " + committer));
    }

    private Configuration httpToSimpleFactory(Configuration conf) {
        conf.set(HTTP_COMMITTER_FACTORY, SimpleCommitterFactory.class.getName());
        return conf;
    }

    private Configuration newBondedConfiguration() {
        return this.httpToSimpleFactory(new Configuration());
    }

    private <E extends Throwable> E verifyCauseClass(Throwable ex, Class<E> clazz) throws AssertionError {
        Throwable cause = ex.getCause();
        if (cause == null) {
            throw new AssertionError("No cause", ex);
        }
        if (!cause.getClass().equals(clazz)) {
            throw new AssertionError("Wrong cause class", cause);
        }
        return (E)cause;
    }

    @Test
    public void testBadCommitterFactory() throws Throwable {
        this.expectFactoryConstructionFailure(HTTP_COMMITTER_FACTORY);
    }

    @Test
    public void testBoundCommitterWithSchema() throws Throwable {
        Configuration conf = this.newBondedConfiguration();
        TestPathOutputCommitter.TaskContext tac = new TestPathOutputCommitter.TaskContext(conf);
        BindingPathOutputCommitter committer = new BindingPathOutputCommitter(HTTP_PATH, (TaskAttemptContext)tac);
        LambdaTestUtils.intercept(IOException.class, (String)"setupJob", () -> committer.setupJob((JobContext)tac));
    }

    @Test
    public void testBoundCommitterWithDefault() throws Throwable {
        Configuration conf = this.newBondedConfiguration();
        TestPathOutputCommitter.TaskContext tac = new TestPathOutputCommitter.TaskContext(conf);
        BindingPathOutputCommitter committer = new BindingPathOutputCommitter(HDFS_PATH, (TaskAttemptContext)tac);
        TestPathOutputCommitterFactory.assertEquals(FileOutputCommitter.class, committer.getCommitter().getClass());
    }

    protected void expectFactoryConstructionFailure(String key) throws Throwable {
        Configuration conf = new Configuration();
        conf.set(key, "Not a factory");
        RuntimeException ex = (RuntimeException)LambdaTestUtils.intercept(RuntimeException.class, () -> PathOutputCommitterFactory.getCommitterFactory((Path)HTTP_PATH, (Configuration)conf));
        this.verifyCauseClass(this.verifyCauseClass(ex, RuntimeException.class), ClassNotFoundException.class);
    }

    private static class SimpleCommitterFactory
    extends PathOutputCommitterFactory {
        private SimpleCommitterFactory() {
        }

        public PathOutputCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
            return new SimpleCommitter(outputPath, context);
        }
    }

    private static class OtherFactory
    extends PathOutputCommitterFactory {
        private OtherFactory() {
        }

        public PathOutputCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
            return new SimpleCommitter(outputPath, context);
        }
    }

    public static final class SimpleCommitter
    extends PathOutputCommitter {
        private final Path outputPath;

        public SimpleCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
            super(outputPath, context);
            this.outputPath = outputPath;
        }

        public Path getWorkPath() throws IOException {
            return null;
        }

        public void setupJob(JobContext jobContext) throws IOException {
            throw new IOException("setupJob");
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
        }

        public Path getOutputPath() {
            return this.outputPath;
        }
    }
}

