/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.security.Credentials;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPathOutputCommitter
extends Assertions {
    @Test
    public void testFileOutputCommitterOverrride() throws Throwable {
        TaskContext context = new TaskContext();
        Path workPath = new Path("file:///work");
        context.setOutputCommitter((OutputCommitter)new SimpleCommitter(new Path("/"), (TaskAttemptContext)context, workPath));
        TestPathOutputCommitter.assertEquals((Object)workPath, (Object)FileOutputFormat.getWorkOutputPath((TaskInputOutputContext)context));
    }

    @Test
    public void testFileOutputCommitterNullWorkPath() throws Throwable {
        TaskContext context = new TaskContext();
        context.setOutputCommitter((OutputCommitter)new SimpleCommitter(new Path("/"), (TaskAttemptContext)context, null));
        TestPathOutputCommitter.assertNull((Object)FileOutputFormat.getWorkOutputPath((TaskInputOutputContext)context));
    }

    public static class TaskContext
    implements TaskInputOutputContext<String, String, String, String> {
        private final Configuration configuration;
        private OutputCommitter outputCommitter;

        public TaskContext() {
            this(new Configuration());
        }

        public TaskContext(Configuration conf) {
            this.configuration = conf;
        }

        public void setOutputCommitter(OutputCommitter outputCommitter) {
            this.outputCommitter = outputCommitter;
        }

        public OutputCommitter getOutputCommitter() {
            return this.outputCommitter;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return false;
        }

        public String getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public String getCurrentValue() throws IOException, InterruptedException {
            return null;
        }

        public void write(String key, String value) throws IOException, InterruptedException {
        }

        public TaskAttemptID getTaskAttemptID() {
            return null;
        }

        public void setStatus(String msg) {
        }

        public String getStatus() {
            return null;
        }

        public float getProgress() {
            return 0.0f;
        }

        public Counter getCounter(Enum<?> counterName) {
            return null;
        }

        public Counter getCounter(String groupName, String counterName) {
            return null;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Credentials getCredentials() {
            return null;
        }

        public JobID getJobID() {
            return null;
        }

        public int getNumReduceTasks() {
            return 0;
        }

        public Path getWorkingDirectory() throws IOException {
            return null;
        }

        public Class<?> getOutputKeyClass() {
            return null;
        }

        public Class<?> getOutputValueClass() {
            return null;
        }

        public Class<?> getMapOutputKeyClass() {
            return null;
        }

        public Class<?> getMapOutputValueClass() {
            return null;
        }

        public String getJobName() {
            return null;
        }

        public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException {
            return null;
        }

        public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException {
            return null;
        }

        public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException {
            return null;
        }

        public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException {
            return null;
        }

        public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException {
            return null;
        }

        public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException {
            return null;
        }

        public RawComparator<?> getSortComparator() {
            return null;
        }

        public String getJar() {
            return null;
        }

        public RawComparator<?> getCombinerKeyGroupingComparator() {
            return null;
        }

        public RawComparator<?> getGroupingComparator() {
            return null;
        }

        public boolean getJobSetupCleanupNeeded() {
            return false;
        }

        public boolean getTaskCleanupNeeded() {
            return false;
        }

        public boolean getProfileEnabled() {
            return false;
        }

        public String getProfileParams() {
            return null;
        }

        public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
            return null;
        }

        public String getUser() {
            return null;
        }

        public boolean getSymlink() {
            return false;
        }

        public Path[] getArchiveClassPaths() {
            return new Path[0];
        }

        public URI[] getCacheArchives() throws IOException {
            return new URI[0];
        }

        public URI[] getCacheFiles() throws IOException {
            return new URI[0];
        }

        public Path[] getLocalCacheArchives() throws IOException {
            return new Path[0];
        }

        public Path[] getLocalCacheFiles() throws IOException {
            return new Path[0];
        }

        public Path[] getFileClassPaths() {
            return new Path[0];
        }

        public String[] getArchiveTimestamps() {
            return new String[0];
        }

        public String[] getFileTimestamps() {
            return new String[0];
        }

        public int getMaxMapAttempts() {
            return 0;
        }

        public int getMaxReduceAttempts() {
            return 0;
        }

        public void progress() {
        }
    }

    private static class SimpleCommitter
    extends PathOutputCommitter {
        private final Path workPath;

        SimpleCommitter(Path outputPath, TaskAttemptContext context, Path workPath) throws IOException {
            super(outputPath, context);
            this.workPath = workPath;
        }

        SimpleCommitter(Path outputPath, JobContext context, Path workPath) throws IOException {
            super(outputPath, context);
            this.workPath = workPath;
        }

        public Path getWorkPath() throws IOException {
            return this.workPath;
        }

        public void setupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
        }

        public Path getOutputPath() {
            return null;
        }
    }
}

