/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.db.BigDecimalSplitter;
import org.apache.hadoop.mapreduce.lib.db.BooleanSplitter;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.FloatSplitter;
import org.apache.hadoop.mapreduce.lib.db.IntegerSplitter;
import org.apache.hadoop.mapreduce.lib.db.TextSplitter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestSplitters {
    private Configuration configuration;

    @BeforeEach
    public void setup() {
        this.configuration = new Configuration();
        this.configuration.setInt("mapreduce.job.maps", 2);
    }

    @Test
    @Timeout(value=2L)
    public void testBooleanSplitter() throws Exception {
        BooleanSplitter splitter = new BooleanSplitter();
        ResultSet result = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)result.getString(1)).thenReturn((Object)"result1");
        List splits = splitter.split(this.configuration, result, "column");
        this.assertSplits(new String[]{"column = FALSE column = FALSE", "column IS NULL column IS NULL"}, splits);
        Mockito.when((Object)result.getString(1)).thenReturn((Object)"result1");
        Mockito.when((Object)result.getString(2)).thenReturn((Object)"result2");
        Mockito.when((Object)result.getBoolean(1)).thenReturn((Object)true);
        Mockito.when((Object)result.getBoolean(2)).thenReturn((Object)false);
        splits = splitter.split(this.configuration, result, "column");
        Assertions.assertEquals((int)0, (int)splits.size());
        Mockito.when((Object)result.getString(1)).thenReturn((Object)"result1");
        Mockito.when((Object)result.getString(2)).thenReturn((Object)"result2");
        Mockito.when((Object)result.getBoolean(1)).thenReturn((Object)false);
        Mockito.when((Object)result.getBoolean(2)).thenReturn((Object)true);
        splits = splitter.split(this.configuration, result, "column");
        this.assertSplits(new String[]{"column = FALSE column = FALSE", ".*column = TRUE"}, splits);
    }

    @Test
    @Timeout(value=2L)
    public void testFloatSplitter() throws Exception {
        FloatSplitter splitter = new FloatSplitter();
        ResultSet results = (ResultSet)Mockito.mock(ResultSet.class);
        List splits = splitter.split(this.configuration, results, "column");
        this.assertSplits(new String[]{".*column IS NULL"}, splits);
        Mockito.when((Object)results.getString(1)).thenReturn((Object)"result1");
        Mockito.when((Object)results.getString(2)).thenReturn((Object)"result2");
        Mockito.when((Object)results.getDouble(1)).thenReturn((Object)5.0);
        Mockito.when((Object)results.getDouble(2)).thenReturn((Object)7.0);
        splits = splitter.split(this.configuration, results, "column1");
        this.assertSplits(new String[]{"column1 >= 5.0 column1 < 6.0", "column1 >= 6.0 column1 <= 7.0"}, splits);
    }

    @Test
    @Timeout(value=2L)
    public void testBigDecimalSplitter() throws Exception {
        BigDecimalSplitter splitter = new BigDecimalSplitter();
        ResultSet result = (ResultSet)Mockito.mock(ResultSet.class);
        List splits = splitter.split(this.configuration, result, "column");
        this.assertSplits(new String[]{".*column IS NULL"}, splits);
        Mockito.when((Object)result.getString(1)).thenReturn((Object)"result1");
        Mockito.when((Object)result.getString(2)).thenReturn((Object)"result2");
        Mockito.when((Object)result.getBigDecimal(1)).thenReturn((Object)new BigDecimal(10));
        Mockito.when((Object)result.getBigDecimal(2)).thenReturn((Object)new BigDecimal(12));
        splits = splitter.split(this.configuration, result, "column1");
        this.assertSplits(new String[]{"column1 >= 10 column1 < 11", "column1 >= 11 column1 <= 12"}, splits);
    }

    @Test
    @Timeout(value=2L)
    public void testIntegerSplitter() throws Exception {
        IntegerSplitter splitter = new IntegerSplitter();
        ResultSet result = (ResultSet)Mockito.mock(ResultSet.class);
        List splits = splitter.split(this.configuration, result, "column");
        this.assertSplits(new String[]{".*column IS NULL"}, splits);
        Mockito.when((Object)result.getString(1)).thenReturn((Object)"result1");
        Mockito.when((Object)result.getString(2)).thenReturn((Object)"result2");
        Mockito.when((Object)result.getLong(1)).thenReturn((Object)8L);
        Mockito.when((Object)result.getLong(2)).thenReturn((Object)19L);
        splits = splitter.split(this.configuration, result, "column1");
        this.assertSplits(new String[]{"column1 >= 8 column1 < 13", "column1 >= 13 column1 < 18", "column1 >= 18 column1 <= 19"}, splits);
    }

    @Test
    @Timeout(value=2L)
    public void testTextSplitter() throws Exception {
        TextSplitter splitter = new TextSplitter();
        ResultSet result = (ResultSet)Mockito.mock(ResultSet.class);
        List splits = splitter.split(this.configuration, result, "column");
        this.assertSplits(new String[]{"column IS NULL column IS NULL"}, splits);
        Mockito.when((Object)result.getString(1)).thenReturn((Object)"result1");
        Mockito.when((Object)result.getString(2)).thenReturn((Object)"result2");
        splits = splitter.split(this.configuration, result, "column1");
        this.assertSplits(new String[]{"column1 >= 'result1' column1 < 'result1.'", "column1 >= 'result1' column1 <= 'result2'"}, splits);
    }

    private void assertSplits(String[] expectedSplitRE, List<InputSplit> splits) throws IOException {
        Assertions.assertEquals((int)expectedSplitRE.length, (int)splits.size());
        for (int i = 0; i < expectedSplitRE.length; ++i) {
            DataDrivenDBInputFormat.DataDrivenDBInputSplit split = (DataDrivenDBInputFormat.DataDrivenDBInputSplit)splits.get(i);
            String actualExpr = split.getLowerClause() + " " + split.getUpperClause();
            Assertions.assertTrue((boolean)Pattern.matches(expectedSplitRE[i], actualExpr), (String)("Split #" + (i + 1) + " expression is wrong. Expected " + expectedSplitRE[i] + " Actual " + actualExpr));
        }
    }
}

