/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.sql.Connection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.db.BigDecimalSplitter;
import org.apache.hadoop.mapreduce.lib.db.BooleanSplitter;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DateSplitter;
import org.apache.hadoop.mapreduce.lib.db.DriverForTest;
import org.apache.hadoop.mapreduce.lib.db.FloatSplitter;
import org.apache.hadoop.mapreduce.lib.db.IntegerSplitter;
import org.apache.hadoop.mapreduce.lib.db.OracleDBRecordReader;
import org.apache.hadoop.mapreduce.lib.db.OracleDataDrivenDBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.OracleDateSplitter;
import org.apache.hadoop.mapreduce.lib.db.TextSplitter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestDbClasses {
    @Test
    @Timeout(value=10L)
    public void testDataDrivenDBInputFormatSplitter() {
        DataDrivenDBInputFormat format = new DataDrivenDBInputFormat();
        this.testCommonSplitterTypes((DataDrivenDBInputFormat<DBInputFormat.NullDBWritable>)format);
        Assertions.assertEquals(DateSplitter.class, format.getSplitter(93).getClass());
        Assertions.assertEquals(DateSplitter.class, format.getSplitter(91).getClass());
        Assertions.assertEquals(DateSplitter.class, format.getSplitter(92).getClass());
    }

    @Test
    @Timeout(value=10L)
    public void testDataDrivenDBInputFormat() throws Exception {
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Configuration configuration = new Configuration();
        configuration.setInt("mapreduce.job.maps", 1);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)configuration);
        DataDrivenDBInputFormat format = new DataDrivenDBInputFormat();
        List splits = format.getSplits(jobContext);
        Assertions.assertEquals((int)1, (int)splits.size());
        DataDrivenDBInputFormat.DataDrivenDBInputSplit split = (DataDrivenDBInputFormat.DataDrivenDBInputSplit)splits.get(0);
        Assertions.assertEquals((Object)"1=1", (Object)split.getLowerClause());
        Assertions.assertEquals((Object)"1=1", (Object)split.getUpperClause());
        configuration.setInt("mapreduce.job.maps", 2);
        DataDrivenDBInputFormat.setBoundingQuery((Configuration)configuration, (String)"query");
        Assertions.assertEquals((Object)"query", (Object)configuration.get("mapred.jdbc.input.bounding.query"));
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getConfiguration()).thenReturn((Object)configuration);
        DataDrivenDBInputFormat.setInput((Job)job, DBInputFormat.NullDBWritable.class, (String)"query", (String)"Bounding Query");
        Assertions.assertEquals((Object)"Bounding Query", (Object)configuration.get("mapred.jdbc.input.bounding.query"));
    }

    @Test
    @Timeout(value=10L)
    public void testOracleDataDrivenDBInputFormat() throws Exception {
        OracleDataDrivenDBInputFormatForTest format = new OracleDataDrivenDBInputFormatForTest();
        this.testCommonSplitterTypes((DataDrivenDBInputFormat<DBInputFormat.NullDBWritable>)format);
        Assertions.assertEquals(OracleDateSplitter.class, format.getSplitter(93).getClass());
        Assertions.assertEquals(OracleDateSplitter.class, format.getSplitter(91).getClass());
        Assertions.assertEquals(OracleDateSplitter.class, format.getSplitter(92).getClass());
    }

    @Test
    @Timeout(value=20L)
    public void testOracleDBRecordReader() throws Exception {
        DBInputFormat.DBInputSplit splitter = new DBInputFormat.DBInputSplit(1L, 10L);
        Configuration configuration = new Configuration();
        Connection connect = DriverForTest.getConnection();
        DBConfiguration dbConfiguration = new DBConfiguration(configuration);
        dbConfiguration.setInputOrderBy("Order");
        String[] fields = new String[]{"f1", "f2"};
        OracleDBRecordReader recorder = new OracleDBRecordReader(splitter, DBInputFormat.NullDBWritable.class, configuration, connect, dbConfiguration, "condition", fields, "table");
        Assertions.assertEquals((Object)"SELECT * FROM (SELECT a.*,ROWNUM dbif_rno FROM ( SELECT f1, f2 FROM table WHERE condition ORDER BY Order ) a WHERE rownum <= 10 ) WHERE dbif_rno > 1", (Object)recorder.getSelectQuery());
    }

    private void testCommonSplitterTypes(DataDrivenDBInputFormat<DBInputFormat.NullDBWritable> format) {
        Assertions.assertEquals(BigDecimalSplitter.class, format.getSplitter(3).getClass());
        Assertions.assertEquals(BigDecimalSplitter.class, format.getSplitter(2).getClass());
        Assertions.assertEquals(BooleanSplitter.class, format.getSplitter(16).getClass());
        Assertions.assertEquals(BooleanSplitter.class, format.getSplitter(-7).getClass());
        Assertions.assertEquals(IntegerSplitter.class, format.getSplitter(-5).getClass());
        Assertions.assertEquals(IntegerSplitter.class, format.getSplitter(-6).getClass());
        Assertions.assertEquals(IntegerSplitter.class, format.getSplitter(5).getClass());
        Assertions.assertEquals(IntegerSplitter.class, format.getSplitter(4).getClass());
        Assertions.assertEquals(FloatSplitter.class, format.getSplitter(8).getClass());
        Assertions.assertEquals(FloatSplitter.class, format.getSplitter(7).getClass());
        Assertions.assertEquals(FloatSplitter.class, format.getSplitter(6).getClass());
        Assertions.assertEquals(TextSplitter.class, format.getSplitter(-1).getClass());
        Assertions.assertEquals(TextSplitter.class, format.getSplitter(1).getClass());
        Assertions.assertEquals(TextSplitter.class, format.getSplitter(12).getClass());
        Assertions.assertNull((Object)format.getSplitter(-2));
    }

    private class OracleDataDrivenDBInputFormatForTest
    extends OracleDataDrivenDBInputFormat<DBInputFormat.NullDBWritable> {
        private OracleDataDrivenDBInputFormatForTest() {
        }

        public DBConfiguration getDBConf() {
            String[] names = new String[]{"field1", "field2"};
            DBConfiguration result = (DBConfiguration)Mockito.mock(DBConfiguration.class);
            Mockito.when((Object)result.getInputConditions()).thenReturn((Object)"conditions");
            Mockito.when((Object)result.getInputFieldNames()).thenReturn((Object)names);
            Mockito.when((Object)result.getInputTableName()).thenReturn((Object)"table");
            return result;
        }

        public Connection getConnection() {
            return DriverForTest.getConnection();
        }
    }
}

