/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.filecache;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDistributedCache {
    @Test
    public void testAddFileToClassPath() throws Exception {
        Configuration conf = new Configuration(false);
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf);
            Assertions.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf);
        Assertions.assertEquals((Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"file:///a", (Object)conf.get("mapreduce.job.cache.files"), (String)"The mapreduce.job.cache.files property was not set correctly");
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf);
        Assertions.assertEquals((Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"file:///a,file:///b", (Object)conf.get("mapreduce.job.cache.files"), (String)"The mapreduce.job.cache.files property was not set correctly");
        FileSystem fs = FileSystem.newInstance((Configuration)conf);
        conf.clear();
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf, (FileSystem)fs);
            Assertions.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf, (FileSystem)fs);
        Assertions.assertEquals((Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"file:///a", (Object)conf.get("mapreduce.job.cache.files"), (String)"The mapreduce.job.cache.files property was not set correctly");
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf, (FileSystem)fs);
        Assertions.assertEquals((Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"file:///a,file:///b", (Object)conf.get("mapreduce.job.cache.files"), (String)"The mapreduce.job.cache.files property was not set correctly");
        conf.clear();
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf, (FileSystem)fs, (boolean)true);
            Assertions.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf, (FileSystem)fs, (boolean)true);
        Assertions.assertEquals((Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"file:///a", (Object)conf.get("mapreduce.job.cache.files"), (String)"The mapreduce.job.cache.files property was not set correctly");
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf, (FileSystem)fs, (boolean)true);
        Assertions.assertEquals((Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"file:///a,file:///b", (Object)conf.get("mapreduce.job.cache.files"), (String)"The mapreduce.job.cache.files property was not set correctly");
        conf.clear();
        try {
            DistributedCache.addFileToClassPath(null, (Configuration)conf, (FileSystem)fs, (boolean)false);
            Assertions.fail((String)"Accepted null archives argument");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DistributedCache.addFileToClassPath((Path)new Path("file:///a"), (Configuration)conf, (FileSystem)fs, (boolean)false);
        Assertions.assertEquals((Object)"file:/a", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"", (Object)conf.get("mapreduce.job.cache.files", ""), (String)"The mapreduce.job.cache.files property was not set correctly");
        DistributedCache.addFileToClassPath((Path)new Path("file:///b"), (Configuration)conf, (FileSystem)fs, (boolean)false);
        Assertions.assertEquals((Object)"file:/a,file:/b", (Object)conf.get("mapreduce.job.classpath.files"), (String)"The mapreduce.job.classpath.files property was not set correctly");
        Assertions.assertEquals((Object)"", (Object)conf.get("mapreduce.job.cache.files", ""), (String)"The mapreduce.job.cache.files property was not set correctly");
    }
}

