/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.checkpoint;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapreduce.checkpoint.CheckpointID;
import org.apache.hadoop.mapreduce.checkpoint.CheckpointNamingService;
import org.apache.hadoop.mapreduce.checkpoint.CheckpointService;
import org.apache.hadoop.mapreduce.checkpoint.FSCheckpointID;
import org.apache.hadoop.mapreduce.checkpoint.FSCheckpointService;
import org.apache.hadoop.mapreduce.checkpoint.SimpleNamingService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFSCheckpointService {
    private final int BUFSIZE = 1024;

    @Test
    public void testCheckpointCreate() throws Exception {
        this.checkpointCreate(ByteBuffer.allocate(1024));
    }

    @Test
    public void testCheckpointCreateDirect() throws Exception {
        this.checkpointCreate(ByteBuffer.allocateDirect(1024));
    }

    public void checkpointCreate(ByteBuffer b) throws Exception {
        int WRITES = 128;
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        DataOutputBuffer dob = new DataOutputBuffer();
        FSDataOutputStream hdfs = (FSDataOutputStream)Mockito.spy((Object)new FSDataOutputStream((OutputStream)dob, null));
        DataOutputBuffer verif = new DataOutputBuffer();
        Mockito.when((Object)fs.create((Path)Mockito.isA(Path.class), Mockito.eq((short)1))).thenReturn((Object)hdfs);
        Mockito.when((Object)fs.rename((Path)Mockito.isA(Path.class), (Path)Mockito.isA(Path.class))).thenReturn((Object)true);
        Path base = new Path("/chk");
        Path finalLoc = new Path("/chk/checkpoint_chk0");
        Path tmp = FSCheckpointService.tmpfile((Path)finalLoc);
        FSCheckpointService chk = new FSCheckpointService(fs, base, (CheckpointNamingService)new SimpleNamingService("chk0"), 1);
        CheckpointService.CheckpointWriteChannel out = chk.create();
        Random r = new Random();
        byte[] randBytes = new byte[1024];
        for (int i = 0; i < WRITES; ++i) {
            r.nextBytes(randBytes);
            int s = r.nextInt(1023);
            int e = r.nextInt(1024 - s) + 1;
            verif.write(randBytes, s, e);
            b.clear();
            b.put(randBytes).flip();
            b.position(s).limit(b.position() + e);
            out.write(b);
        }
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).rename((Path)Mockito.any(Path.class), (Path)Mockito.eq((Object)finalLoc));
        CheckpointID cid = chk.commit(out);
        ((FSDataOutputStream)Mockito.verify((Object)hdfs)).close();
        ((FileSystem)Mockito.verify((Object)fs)).rename((Path)Mockito.eq((Object)tmp), (Path)Mockito.eq((Object)finalLoc));
        Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(verif.getData(), 0, verif.getLength()), (byte[])Arrays.copyOfRange(dob.getData(), 0, dob.getLength()));
    }

    @Test
    public void testDelete() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Path chkloc = new Path("/chk/chk0");
        Mockito.when((Object)fs.delete((Path)Mockito.eq((Object)chkloc), Mockito.eq((boolean)false))).thenReturn((Object)true);
        Path base = new Path("/otherchk");
        FSCheckpointID id = new FSCheckpointID(chkloc);
        FSCheckpointService chk = new FSCheckpointService(fs, base, (CheckpointNamingService)new SimpleNamingService("chk0"), 1);
        Assertions.assertTrue((boolean)chk.delete((CheckpointID)id));
        ((FileSystem)Mockito.verify((Object)fs)).delete((Path)Mockito.eq((Object)chkloc), Mockito.eq((boolean)false));
    }
}

