/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTaskID {
    @Test
    public void testGetJobID() {
        JobID jobId = new JobID("1234", 0);
        TaskID taskId = new TaskID(jobId, TaskType.MAP, 0);
        Assertions.assertSame((Object)jobId, (Object)taskId.getJobID(), (String)"TaskID did not store the JobID correctly");
        taskId = new TaskID();
        Assertions.assertEquals((Object)"", (Object)taskId.getJobID().getJtIdentifier(), (String)"Job ID was set unexpectedly in default constructor");
    }

    @Test
    public void testIsMap() {
        JobID jobId = new JobID("1234", 0);
        for (TaskType type : TaskType.values()) {
            TaskID taskId = new TaskID(jobId, type, 0);
            if (type == TaskType.MAP) {
                Assertions.assertTrue((boolean)taskId.isMap(), (String)"TaskID for map task did not correctly identify itself as a map task");
                continue;
            }
            Assertions.assertFalse((boolean)taskId.isMap(), (String)("TaskID for " + type + " task incorrectly identified itself as a map task"));
        }
        TaskID taskId = new TaskID();
        Assertions.assertFalse((boolean)taskId.isMap(), (String)"TaskID of default type incorrectly identified itself as a map task");
    }

    @Test
    public void testGetTaskType0args() {
        JobID jobId = new JobID("1234", 0);
        for (TaskType type : TaskType.values()) {
            TaskID taskId = new TaskID(jobId, type, 0);
            Assertions.assertEquals((Object)type, (Object)taskId.getTaskType(), (String)"TaskID incorrectly reported its type");
        }
        TaskID taskId = new TaskID();
        Assertions.assertEquals((Object)TaskType.REDUCE, (Object)taskId.getTaskType(), (String)"TaskID of default type incorrectly reported its type");
    }

    @Test
    public void testEquals() {
        JobID jobId1 = new JobID("1234", 1);
        JobID jobId2 = new JobID("2345", 2);
        TaskID taskId1 = new TaskID(jobId1, TaskType.MAP, 0);
        TaskID taskId2 = new TaskID(jobId1, TaskType.MAP, 0);
        Assertions.assertTrue((boolean)taskId1.equals((Object)taskId2), (String)"The equals() method reported two equal task IDs were not equal");
        taskId2 = new TaskID(jobId2, TaskType.MAP, 0);
        Assertions.assertFalse((boolean)taskId1.equals((Object)taskId2), (String)"The equals() method reported two task IDs with different job IDs were equal");
        taskId2 = new TaskID(jobId1, TaskType.MAP, 1);
        Assertions.assertFalse((boolean)taskId1.equals((Object)taskId2), (String)"The equals() method reported two task IDs with different IDs were equal");
        TaskType[] types = TaskType.values();
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < types.length; ++j) {
                taskId1 = new TaskID(jobId1, types[i], 0);
                taskId2 = new TaskID(jobId1, types[j], 0);
                if (i == j) {
                    Assertions.assertTrue((boolean)taskId1.equals((Object)taskId2), (String)"The equals() method reported two equal task IDs were not equal");
                    continue;
                }
                Assertions.assertFalse((boolean)taskId1.equals((Object)taskId2), (String)"The equals() method reported two task IDs with different types were equal");
            }
        }
        Assertions.assertFalse((boolean)taskId1.equals((Object)jobId1), (String)"The equals() method matched against a JobID object");
        Assertions.assertFalse((boolean)taskId1.equals(null), (String)"The equals() method matched against a null object");
    }

    @Test
    public void testCompareTo() {
        JobID jobId = new JobID("1234", 1);
        TaskID taskId1 = new TaskID(jobId, TaskType.REDUCE, 0);
        TaskID taskId2 = new TaskID(jobId, TaskType.REDUCE, 0);
        Assertions.assertEquals((int)0, (int)taskId1.compareTo((ID)taskId2), (String)"The compareTo() method returned non-zero for two equal task IDs");
        taskId2 = new TaskID(jobId, TaskType.MAP, 1);
        Assertions.assertTrue((taskId1.compareTo((ID)taskId2) > 0 ? 1 : 0) != 0, (String)"The compareTo() method did not weigh task type more than task ID");
        TaskType[] types = TaskType.values();
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < types.length; ++j) {
                taskId1 = new TaskID(jobId, types[i], 0);
                taskId2 = new TaskID(jobId, types[j], 0);
                if (i == j) {
                    Assertions.assertEquals((int)0, (int)taskId1.compareTo((ID)taskId2), (String)"The compareTo() method returned non-zero for two equal task IDs");
                    continue;
                }
                if (i < j) {
                    Assertions.assertTrue((taskId1.compareTo((ID)taskId2) < 0 ? 1 : 0) != 0, (String)("The compareTo() method did not order " + types[i] + " before " + types[j]));
                    continue;
                }
                Assertions.assertTrue((taskId1.compareTo((ID)taskId2) > 0 ? 1 : 0) != 0, (String)("The compareTo() method did not order " + types[i] + " after " + types[j]));
            }
        }
        try {
            taskId1.compareTo((ID)jobId);
            Assertions.fail((String)"The compareTo() method allowed comparison to a JobID object");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            taskId1.compareTo(null);
            Assertions.fail((String)"The compareTo() method allowed comparison to a null object");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        JobID jobId = new JobID("1234", 1);
        for (TaskType type : TaskType.values()) {
            TaskID taskId = new TaskID(jobId, type, 0);
            String str = String.format("task_1234_0001_%c_000000", Character.valueOf(TaskID.getRepresentingCharacter((TaskType)type)));
            Assertions.assertEquals((Object)str, (Object)taskId.toString(), (String)"The toString() method returned the wrong value");
        }
    }

    @Test
    public void testAppendTo() {
        JobID jobId = new JobID("1234", 1);
        StringBuilder builder = new StringBuilder();
        for (TaskType type : TaskType.values()) {
            builder.setLength(0);
            TaskID taskId = new TaskID(jobId, type, 0);
            String str = String.format("_1234_0001_%c_000000", Character.valueOf(TaskID.getRepresentingCharacter((TaskType)type)));
            Assertions.assertEquals((Object)str, (Object)taskId.appendTo(builder).toString(), (String)"The appendTo() method appended the wrong value.");
        }
        try {
            new TaskID().appendTo(null);
            Assertions.fail((String)"The appendTo() method allowed a null builder");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testHashCode() {
        TaskType[] types = TaskType.values();
        for (int i = 0; i < types.length; ++i) {
            JobID jobId = new JobID("1234" + i, i);
            TaskID taskId1 = new TaskID(jobId, types[i], i);
            TaskID taskId2 = new TaskID(jobId, types[i], i);
            Assertions.assertEquals((int)taskId1.hashCode(), (int)taskId2.hashCode(), (String)"The hashcode() method gave unequal hash codes for two equal task IDs");
        }
    }

    @Test
    public void testReadFields() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(0);
        out.writeInt(1);
        WritableUtils.writeVInt((DataOutput)out, (int)4);
        out.write(new byte[]{49, 50, 51, 52});
        WritableUtils.writeEnum((DataOutput)out, (Enum)TaskType.REDUCE);
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{ByteBuffer.wrap(baos.toByteArray())});
        TaskID instance = new TaskID();
        instance.readFields((DataInput)in);
        Assertions.assertEquals((Object)"task_1234_0001_r_000000", (Object)instance.toString(), (String)"The readFields() method did not produce the expected task ID");
    }

    @Test
    public void testWrite() throws Exception {
        JobID jobId = new JobID("1234", 1);
        TaskID taskId = new TaskID(jobId, TaskType.JOB_SETUP, 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        taskId.write((DataOutput)out);
        DataInputByteBuffer in = new DataInputByteBuffer();
        byte[] buffer = new byte[4];
        in.reset(new ByteBuffer[]{ByteBuffer.wrap(baos.toByteArray())});
        Assertions.assertEquals((int)0, (int)in.readInt(), (String)"The write() method did not write the expected task ID");
        Assertions.assertEquals((int)1, (int)in.readInt(), (String)"The write() method did not write the expected job ID");
        Assertions.assertEquals((int)4, (int)WritableUtils.readVInt((DataInput)in), (String)"The write() method did not write the expected job identifier length");
        in.readFully(buffer, 0, 4);
        Assertions.assertEquals((Object)"1234", (Object)new String(buffer), (String)"The write() method did not write the expected job identifier length");
        Assertions.assertEquals((Object)TaskType.JOB_SETUP, (Object)WritableUtils.readEnum((DataInput)in, TaskType.class), (String)"The write() method did not write the expected task type");
    }

    @Test
    public void testForName() {
        Assertions.assertEquals((Object)"task_1_0001_m_000000", (Object)TaskID.forName((String)"task_1_0001_m_000").toString(), (String)"The forName() method did not parse the task ID string correctly");
        Assertions.assertEquals((Object)"task_23_0002_r_000001", (Object)TaskID.forName((String)"task_23_0002_r_0001").toString(), (String)"The forName() method did not parse the task ID string correctly");
        Assertions.assertEquals((Object)"task_345_0003_s_000002", (Object)TaskID.forName((String)"task_345_0003_s_00002").toString(), (String)"The forName() method did not parse the task ID string correctly");
        Assertions.assertEquals((Object)"task_6789_0004_c_000003", (Object)TaskID.forName((String)"task_6789_0004_c_000003").toString(), (String)"The forName() method did not parse the task ID string correctly");
        Assertions.assertEquals((Object)"task_12345_0005_t_4000000", (Object)TaskID.forName((String)"task_12345_0005_t_4000000").toString(), (String)"The forName() method did not parse the task ID string correctly");
        try {
            TaskID.forName((String)"tisk_12345_0005_t_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: tisk_12345_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"tisk_12345_0005_t_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: tisk_12345_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_abc_0005_t_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: task_abc_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_xyz_t_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: task_12345_xyz_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_x_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_x_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_t_jkl");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_t_jkl");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_t");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_t");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_0005_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: task_12345_0005_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"task_12345_t_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: task_12345_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TaskID.forName((String)"12345_0005_t_4000000");
            Assertions.fail((String)"The forName() method parsed an invalid job ID: 12345_0005_t_4000000");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRepresentingCharacter() {
        Assertions.assertEquals((char)'m', (char)TaskID.getRepresentingCharacter((TaskType)TaskType.MAP), (String)"The getRepresentingCharacter() method did not return the expected character");
        Assertions.assertEquals((char)'r', (char)TaskID.getRepresentingCharacter((TaskType)TaskType.REDUCE), (String)"The getRepresentingCharacter() method did not return the expected character");
        Assertions.assertEquals((char)'s', (char)TaskID.getRepresentingCharacter((TaskType)TaskType.JOB_SETUP), (String)"The getRepresentingCharacter() method did not return the expected character");
        Assertions.assertEquals((char)'c', (char)TaskID.getRepresentingCharacter((TaskType)TaskType.JOB_CLEANUP), (String)"The getRepresentingCharacter() method did not return the expected character");
        Assertions.assertEquals((char)'t', (char)TaskID.getRepresentingCharacter((TaskType)TaskType.TASK_CLEANUP), (String)"The getRepresentingCharacter() method did not return the expected character");
    }

    @Test
    public void testGetTaskTypeChar() {
        Assertions.assertEquals((Object)TaskType.MAP, (Object)TaskID.getTaskType((char)'m'), (String)"The getTaskType() method did not return the expected type");
        Assertions.assertEquals((Object)TaskType.REDUCE, (Object)TaskID.getTaskType((char)'r'), (String)"The getTaskType() method did not return the expected type");
        Assertions.assertEquals((Object)TaskType.JOB_SETUP, (Object)TaskID.getTaskType((char)'s'), (String)"The getTaskType() method did not return the expected type");
        Assertions.assertEquals((Object)TaskType.JOB_CLEANUP, (Object)TaskID.getTaskType((char)'c'), (String)"The getTaskType() method did not return the expected type");
        Assertions.assertEquals((Object)TaskType.TASK_CLEANUP, (Object)TaskID.getTaskType((char)'t'), (String)"The getTaskType() method did not return the expected type");
        Assertions.assertNull((Object)TaskID.getTaskType((char)'x'), (String)"The getTaskType() method did not return null for an unknown type");
    }

    @Test
    public void testGetAllTaskTypes() {
        Assertions.assertEquals((Object)"(m|r|s|c|t)", (Object)TaskID.getAllTaskTypes(), (String)"The getAllTaskTypes method did not return the expected string");
    }
}

