/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.protocol.ClientProtocolProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCluster {
    @Test
    public void testProtocolProviderCreation() throws Exception {
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true});
        Mockito.when(iterator.next()).thenReturn((Object)this.getClientProtocolProvider()).thenThrow(new Throwable[]{new ServiceConfigurationError("Test error")}).thenReturn((Object)this.getClientProtocolProvider());
        Iterable frameworkLoader = (Iterable)Mockito.mock(Iterable.class);
        Mockito.when(frameworkLoader.iterator()).thenReturn((Object)iterator);
        Cluster.frameworkLoader = frameworkLoader;
        Cluster testCluster = new Cluster(new Configuration());
        Assertions.assertNotNull((Object)testCluster.getClient(), (String)"ClientProtocol is expected");
        ((Iterator)Mockito.verify((Object)iterator, (VerificationMode)Mockito.times((int)2))).next();
    }

    public ClientProtocolProvider getClientProtocolProvider() {
        return new ClientProtocolProvider(){

            public ClientProtocol create(Configuration conf) throws IOException {
                return (ClientProtocol)Mockito.mock(ClientProtocol.class);
            }

            public ClientProtocol create(InetSocketAddress addr, Configuration conf) throws IOException {
                return (ClientProtocol)Mockito.mock(ClientProtocol.class);
            }

            public void close(ClientProtocol clientProtocol) throws IOException {
            }
        };
    }
}

