/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSkipBadRecords {
    @Test
    @Timeout(value=5L)
    public void testSkipBadRecords() {
        Configuration conf = new Configuration();
        Assertions.assertEquals((int)2, (int)SkipBadRecords.getAttemptsToStartSkipping((Configuration)conf));
        Assertions.assertTrue((boolean)SkipBadRecords.getAutoIncrMapperProcCount((Configuration)conf));
        Assertions.assertTrue((boolean)SkipBadRecords.getAutoIncrReducerProcCount((Configuration)conf));
        Assertions.assertEquals((long)0L, (long)SkipBadRecords.getMapperMaxSkipRecords((Configuration)conf));
        Assertions.assertEquals((float)0.0f, (float)SkipBadRecords.getReducerMaxSkipGroups((Configuration)conf), (float)0.0f);
        Assertions.assertNull((Object)SkipBadRecords.getSkipOutputPath((Configuration)conf));
        SkipBadRecords.setAttemptsToStartSkipping((Configuration)conf, (int)5);
        SkipBadRecords.setAutoIncrMapperProcCount((Configuration)conf, (boolean)false);
        SkipBadRecords.setAutoIncrReducerProcCount((Configuration)conf, (boolean)false);
        SkipBadRecords.setMapperMaxSkipRecords((Configuration)conf, (long)6L);
        SkipBadRecords.setReducerMaxSkipGroups((Configuration)conf, (long)7L);
        JobConf jc = new JobConf();
        SkipBadRecords.setSkipOutputPath((JobConf)jc, (Path)new Path("test"));
        Assertions.assertEquals((int)5, (int)SkipBadRecords.getAttemptsToStartSkipping((Configuration)conf));
        Assertions.assertFalse((boolean)SkipBadRecords.getAutoIncrMapperProcCount((Configuration)conf));
        Assertions.assertFalse((boolean)SkipBadRecords.getAutoIncrReducerProcCount((Configuration)conf));
        Assertions.assertEquals((long)6L, (long)SkipBadRecords.getMapperMaxSkipRecords((Configuration)conf));
        Assertions.assertEquals((float)7.0f, (float)SkipBadRecords.getReducerMaxSkipGroups((Configuration)conf), (float)0.0f);
        Assertions.assertEquals((Object)"test", (Object)SkipBadRecords.getSkipOutputPath((Configuration)jc).toString());
    }
}

