/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestJobEndNotifier {
    HttpServer2 server;
    URL baseUrl;

    @BeforeEach
    public void setUp() throws Exception {
        new File(System.getProperty("build.webapps", "build/webapps") + "/test").mkdirs();
        this.server = new HttpServer2.Builder().setName("test").addEndpoint(URI.create("http://localhost:0")).setFindPort(true).build();
        this.server.addServlet("delay", "/delay", DelayServlet.class);
        this.server.addServlet("jobend", "/jobend", JobEndServlet.class);
        this.server.addServlet("fail", "/fail", FailServlet.class);
        this.server.start();
        int port = this.server.getConnectorAddress(0).getPort();
        this.baseUrl = new URL("http://localhost:" + port + "/");
        JobEndServlet.calledTimes = 0;
        JobEndServlet.requestUri = null;
        DelayServlet.calledTimes = 0;
        FailServlet.calledTimes = 0;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
    }

    @Test
    public void testLocalJobRunnerUriSubstitution() throws InterruptedException {
        JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", JobStatus.SUCCEEDED);
        JobConf jobConf = TestJobEndNotifier.createTestJobConf(new Configuration(), 0, this.baseUrl + "jobend?jobid=$jobId&status=$jobStatus");
        JobEndNotifier.localRunnerNotification((JobConf)jobConf, (JobStatus)jobStatus);
        Assertions.assertEquals((int)1, (int)JobEndServlet.calledTimes);
        Assertions.assertEquals((Object)"jobid=job_20130313155005308_0001&status=SUCCEEDED", (Object)JobEndServlet.requestUri.getQuery());
    }

    @Test
    public void testLocalJobRunnerRetryCount() throws InterruptedException {
        int retryAttempts = 3;
        JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", JobStatus.SUCCEEDED);
        JobConf jobConf = TestJobEndNotifier.createTestJobConf(new Configuration(), retryAttempts, this.baseUrl + "fail");
        JobEndNotifier.localRunnerNotification((JobConf)jobConf, (JobStatus)jobStatus);
        Assertions.assertEquals((int)(retryAttempts + 1), (int)FailServlet.calledTimes);
    }

    @Test
    public void testNotificationTimeout() throws InterruptedException {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.end-notification.timeout", 1000);
        JobStatus jobStatus = TestJobEndNotifier.createTestJobStatus("job_20130313155005308_0001", JobStatus.SUCCEEDED);
        JobConf jobConf = TestJobEndNotifier.createTestJobConf(conf, 0, this.baseUrl + "delay");
        long startTime = System.currentTimeMillis();
        JobEndNotifier.localRunnerNotification((JobConf)jobConf, (JobStatus)jobStatus);
        long elapsedTime = System.currentTimeMillis() - startTime;
        Assertions.assertEquals((int)1, (int)DelayServlet.calledTimes);
        Assertions.assertTrue((elapsedTime < 2000L ? 1 : 0) != 0);
    }

    private static JobStatus createTestJobStatus(String jobId, int state) {
        return new JobStatus(JobID.forName((String)jobId), 0.5f, 0.0f, state, "root", "TestJobEndNotifier", null, null);
    }

    private static JobConf createTestJobConf(Configuration conf, int retryAttempts, String notificationUri) {
        JobConf jobConf = new JobConf(conf);
        jobConf.setInt("job.end.retry.attempts", retryAttempts);
        jobConf.set("job.end.retry.interval", "0");
        jobConf.setJobEndNotificationURI(notificationUri);
        return jobConf;
    }

    public static class DelayServlet
    extends HttpServlet {
        public static volatile int calledTimes = 0;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            boolean timedOut = false;
            ++calledTimes;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                timedOut = true;
            }
            Assertions.assertTrue((boolean)timedOut, (String)"DelayServlet should be interrupted");
        }
    }

    public static class JobEndServlet
    extends HttpServlet {
        public static volatile int calledTimes = 0;
        public static URI requestUri;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            InputStreamReader in = new InputStreamReader((InputStream)request.getInputStream());
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            ++calledTimes;
            try {
                requestUri = new URI(null, null, request.getRequestURI(), request.getQueryString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            in.close();
            out.close();
        }
    }

    public static class FailServlet
    extends HttpServlet {
        public static volatile int calledTimes = 0;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ++calledTimes;
            throw new IOException("I am failing!");
        }
    }
}

