/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestJobConf {
    @Test
    @Timeout(value=5L)
    public void testJobConf() {
        JobConf conf = new JobConf();
        Pattern pattern = conf.getJarUnpackPattern();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Pattern.compile("(?:classes/|lib/).*").toString(), (Object)pattern.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getKeepFailedTaskFiles());
        conf.setKeepFailedTaskFiles(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getKeepFailedTaskFiles());
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.getKeepTaskFilesPattern());
        conf.setKeepTaskFilesPattern("123454");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"123454", (Object)conf.getKeepTaskFilesPattern());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conf.getWorkingDirectory());
        conf.setWorkingDirectory(new Path("test"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getWorkingDirectory().toString().endsWith("test"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)conf.getNumTasksToExecutePerJvm());
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.getKeyFieldComparatorOption());
        conf.setKeyFieldComparatorOptions("keySpec");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"keySpec", (Object)conf.getKeyFieldComparatorOption());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getUseNewReducer());
        conf.setUseNewReducer(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getUseNewReducer());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getMapSpeculativeExecution());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getReduceSpeculativeExecution());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getSpeculativeExecution());
        conf.setReduceSpeculativeExecution(false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getSpeculativeExecution());
        conf.setMapSpeculativeExecution(false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getSpeculativeExecution());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getMapSpeculativeExecution());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getReduceSpeculativeExecution());
        conf.setSessionId("ses");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ses", (Object)conf.getSessionId());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)conf.getMaxTaskFailuresPerTracker());
        conf.setMaxTaskFailuresPerTracker(2);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)conf.getMaxTaskFailuresPerTracker());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)conf.getMaxMapTaskFailuresPercent());
        conf.setMaxMapTaskFailuresPercent(50);
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)conf.getMaxMapTaskFailuresPercent());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)conf.getMaxReduceTaskFailuresPercent());
        conf.setMaxReduceTaskFailuresPercent(70);
        org.junit.jupiter.api.Assertions.assertEquals((int)70, (int)conf.getMaxReduceTaskFailuresPercent());
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.DEFAULT);
        conf.setJobPriority(JobPriority.HIGH);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.HIGH);
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.getJobSubmitHostName());
        conf.setJobSubmitHostName("hostname");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hostname", (Object)conf.getJobSubmitHostName());
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.getJobSubmitHostAddress());
        conf.setJobSubmitHostAddress("ww");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ww", (Object)conf.getJobSubmitHostAddress());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getProfileEnabled());
        conf.setProfileEnabled(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getProfileEnabled());
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getProfileTaskRange(true).toString(), (Object)"0-2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getProfileTaskRange(false).toString(), (Object)"0-2");
        conf.setProfileTaskRange(true, "0-3");
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getProfileTaskRange(false).toString(), (Object)"0-2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getProfileTaskRange(true).toString(), (Object)"0-3");
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.getMapDebugScript());
        conf.setMapDebugScript("mDbgScript");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mDbgScript", (Object)conf.getMapDebugScript());
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.getReduceDebugScript());
        conf.setReduceDebugScript("rDbgScript");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"rDbgScript", (Object)conf.getReduceDebugScript());
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.getJobLocalDir());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"default", (Object)conf.getQueueName());
        conf.setQueueName("qname");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"qname", (Object)conf.getQueueName());
        conf.setMemoryForMapTask(100000L);
        org.junit.jupiter.api.Assertions.assertEquals((long)100000L, (long)conf.getMemoryForMapTask());
        conf.setMemoryForReduceTask(1000000L);
        org.junit.jupiter.api.Assertions.assertEquals((long)1000000L, (long)conf.getMemoryForReduceTask());
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)conf.getMaxPhysicalMemoryForTask());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The variable key is no longer used.", (Object)JobConf.deprecatedString((String)"key"));
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.get("mapreduce.map.java.opts"), (String)"mapreduce.map.java.opts should not be set by default");
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.get("mapreduce.reduce.java.opts"), (String)"mapreduce.reduce.java.opts should not be set by default");
    }

    @Test
    @Timeout(value=10L)
    public void testDeprecatedPropertyNameForTaskVmem() {
        JobConf configuration = new JobConf();
        configuration.setLong("mapred.job.map.memory.mb", 1024L);
        configuration.setLong("mapred.job.reduce.memory.mb", 1024L);
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)configuration.getMemoryForMapTask());
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)configuration.getMemoryForReduceTask());
        configuration.setLong("mapreduce.map.memory.mb", 1025L);
        configuration.setLong("mapreduce.reduce.memory.mb", 1025L);
        org.junit.jupiter.api.Assertions.assertEquals((long)1025L, (long)configuration.getMemoryForMapTask());
        org.junit.jupiter.api.Assertions.assertEquals((long)1025L, (long)configuration.getMemoryForReduceTask());
        configuration.setMemoryForMapTask(2048L);
        configuration.setMemoryForReduceTask(2048L);
        org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)configuration.getLong("mapred.job.map.memory.mb", -1L));
        org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)configuration.getLong("mapred.job.reduce.memory.mb", -1L));
        org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)configuration.getLong("mapreduce.map.memory.mb", -1L));
        org.junit.jupiter.api.Assertions.assertEquals((long)2048L, (long)configuration.getLong("mapreduce.reduce.memory.mb", -1L));
    }

    @Test
    public void testProfileParamsDefaults() {
        JobConf configuration = new JobConf();
        String result = configuration.getProfileParams();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.contains("file=%s"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.startsWith("-agentlib:hprof"));
    }

    @Test
    public void testProfileParamsSetter() {
        JobConf configuration = new JobConf();
        configuration.setProfileParams("test");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)configuration.get("mapreduce.task.profile.params"));
    }

    @Test
    public void testProfileParamsGetter() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.task.profile.params", "test");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)configuration.getProfileParams());
    }

    @Test
    public void testMemoryConfigForMapOrReduceTask() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(300));
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(300L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(300L);
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(300));
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", "-1");
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(400));
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(300L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(400L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", "-1");
        configuration.set("mapreduce.reduce.memory.mb", "-1");
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(-1));
        configuration.set("mapreduce.map.memory.mb", "-1");
        configuration.set("mapreduce.reduce.memory.mb", "-1");
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(1024L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(1024L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", "3");
        configuration.set("mapreduce.reduce.memory.mb", "3");
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
    }

    @Test
    public void testNegativeValueForTaskVmem() {
        JobConf configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", "-3");
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)configuration.getMemoryForMapTask());
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)configuration.getMemoryForReduceTask());
        configuration.set("mapreduce.map.memory.mb", "4");
        configuration.set("mapreduce.reduce.memory.mb", "5");
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)configuration.getMemoryForMapTask());
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)configuration.getMemoryForReduceTask());
    }

    @Test
    public void testNegativeValuesForMemoryParams() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", "-5");
        configuration.set("mapreduce.reduce.memory.mb", "-6");
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)configuration.getMemoryForMapTask());
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)configuration.getMemoryForReduceTask());
    }

    @Test
    public void testMaxVirtualMemoryForTask() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(-1));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x40000000L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(-1));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(200));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x40000000L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(-1));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(-1));
        configuration.set("mapred.task.maxvmem", String.valueOf(0x100000));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x100000L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x100000));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x100000L);
        configuration = new JobConf();
        configuration.setMaxVirtualMemoryForTask(0x200000L);
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(400));
        configuration.setMaxVirtualMemoryForTask(0x200000L);
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
    }

    @Test
    public void testMaxTaskFailuresPerTracker() {
        JobConf jobConf = new JobConf(true);
        org.junit.jupiter.api.Assertions.assertTrue((jobConf.getMaxTaskFailuresPerTracker() < jobConf.getMaxMapAttempts() && jobConf.getMaxTaskFailuresPerTracker() < jobConf.getMaxReduceAttempts() ? 1 : 0) != 0, (String)"By default JobContext.MAX_TASK_FAILURES_PER_TRACKER was not less than JobContext.MAP_MAX_ATTEMPTS and REDUCE_MAX_ATTEMPTS");
    }

    @Test
    public void testParseMaximumHeapSizeMB() {
        org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4294967296"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4194304k"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4096m"));
        org.junit.jupiter.api.Assertions.assertEquals((int)4096, (int)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4g"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4?"));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)JobConf.parseMaximumHeapSizeMB((String)""));
    }

    @Test
    public void testJobPriorityConf() {
        JobConf conf = new JobConf();
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.DEFAULT);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)conf.getJobPriorityAsInteger());
        conf.setJobPriority(JobPriority.LOW);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.LOW);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)conf.getJobPriorityAsInteger());
        conf.setJobPriority(JobPriority.VERY_HIGH);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.VERY_HIGH);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)conf.getJobPriorityAsInteger());
        conf.setJobPriorityAsInteger(3);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.NORMAL);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)conf.getJobPriorityAsInteger());
        conf.setJobPriorityAsInteger(4);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.HIGH);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)conf.getJobPriorityAsInteger());
        conf.setJobPriorityAsInteger(57);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.UNDEFINED_PRIORITY);
        org.junit.jupiter.api.Assertions.assertEquals((int)57, (int)conf.getJobPriorityAsInteger());
        conf.setJobPriority(JobPriority.UNDEFINED_PRIORITY);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.UNDEFINED_PRIORITY);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)conf.getJobPriorityAsInteger());
    }
}

