/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJobAclsManager {
    @Test
    public void testClusterAdmins() {
        Map tmpJobACLs = new HashMap();
        Configuration conf = new Configuration();
        String jobOwner = "testuser";
        conf.set(JobACL.VIEW_JOB.getAclName(), jobOwner);
        conf.set(JobACL.MODIFY_JOB.getAclName(), jobOwner);
        conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        String clusterAdmin = "testuser2";
        conf.set("mapreduce.cluster.administrators", clusterAdmin);
        JobACLsManager aclsManager = new JobACLsManager(conf);
        Map jobACLs = tmpJobACLs = aclsManager.constructJobACLs(conf);
        UserGroupInformation callerUGI = UserGroupInformation.createUserForTesting((String)clusterAdmin, (String[])new String[0]);
        boolean val = aclsManager.checkAccess(callerUGI, JobACL.VIEW_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.VIEW_JOB));
        Assertions.assertTrue((boolean)val, (String)"cluster admin should have view access");
        val = aclsManager.checkAccess(callerUGI, JobACL.MODIFY_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.MODIFY_JOB));
        Assertions.assertTrue((boolean)val, (String)"cluster admin should have modify access");
    }

    @Test
    public void testClusterNoAdmins() {
        Map tmpJobACLs = new HashMap();
        Configuration conf = new Configuration();
        String jobOwner = "testuser";
        conf.set(JobACL.VIEW_JOB.getAclName(), "");
        conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        String noAdminUser = "testuser2";
        JobACLsManager aclsManager = new JobACLsManager(conf);
        Map jobACLs = tmpJobACLs = aclsManager.constructJobACLs(conf);
        UserGroupInformation callerUGI = UserGroupInformation.createUserForTesting((String)noAdminUser, (String[])new String[0]);
        boolean val = aclsManager.checkAccess(callerUGI, JobACL.VIEW_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.VIEW_JOB));
        Assertions.assertFalse((boolean)val, (String)"random user should not have view access");
        val = aclsManager.checkAccess(callerUGI, JobACL.MODIFY_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.MODIFY_JOB));
        Assertions.assertFalse((boolean)val, (String)"random user should not have modify access");
        callerUGI = UserGroupInformation.createUserForTesting((String)jobOwner, (String[])new String[0]);
        val = aclsManager.checkAccess(callerUGI, JobACL.VIEW_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.VIEW_JOB));
        Assertions.assertTrue((boolean)val, (String)"owner should have view access");
        val = aclsManager.checkAccess(callerUGI, JobACL.MODIFY_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.MODIFY_JOB));
        Assertions.assertTrue((boolean)val, (String)"owner should have modify access");
    }

    @Test
    public void testAclsOff() {
        Map tmpJobACLs = new HashMap();
        Configuration conf = new Configuration();
        String jobOwner = "testuser";
        conf.set(JobACL.VIEW_JOB.getAclName(), jobOwner);
        conf.setBoolean("mapreduce.cluster.acls.enabled", false);
        String noAdminUser = "testuser2";
        JobACLsManager aclsManager = new JobACLsManager(conf);
        Map jobACLs = tmpJobACLs = aclsManager.constructJobACLs(conf);
        UserGroupInformation callerUGI = UserGroupInformation.createUserForTesting((String)noAdminUser, (String[])new String[0]);
        boolean val = aclsManager.checkAccess(callerUGI, JobACL.VIEW_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.VIEW_JOB));
        Assertions.assertTrue((boolean)val, (String)"acls off so anyone should have access");
    }

    @Test
    public void testGroups() {
        Map tmpJobACLs = new HashMap();
        Configuration conf = new Configuration();
        String jobOwner = "testuser";
        conf.set(JobACL.VIEW_JOB.getAclName(), jobOwner);
        conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        String user = "testuser2";
        String adminGroup = "adminGroup";
        conf.set("mapreduce.cluster.administrators", " " + adminGroup);
        JobACLsManager aclsManager = new JobACLsManager(conf);
        Map jobACLs = tmpJobACLs = aclsManager.constructJobACLs(conf);
        UserGroupInformation callerUGI = UserGroupInformation.createUserForTesting((String)user, (String[])new String[]{adminGroup});
        boolean val = aclsManager.checkAccess(callerUGI, JobACL.VIEW_JOB, jobOwner, (AccessControlList)jobACLs.get(JobACL.VIEW_JOB));
        Assertions.assertTrue((boolean)val, (String)"user in admin group should have access");
    }
}

