/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestIndexCache {
    private JobConf conf;
    private FileSystem fs;
    private Path p;

    @BeforeEach
    public void setUp() throws IOException {
        this.conf = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)this.conf).getRaw();
        this.p = new Path(System.getProperty("test.build.data", "/tmp"), "cache").makeQualified(this.fs.getUri(), this.fs.getWorkingDirectory());
    }

    @Test
    public void testLRCPolicy() throws Exception {
        int totalsize;
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("seed: " + seed);
        this.fs.delete(this.p, true);
        this.conf.setInt("mapreduce.reduce.shuffle.indexcache.mb", 1);
        int partsPerMap = 1000;
        int bytesPerFile = 24000;
        IndexCache cache = new IndexCache(this.conf);
        for (totalsize = 24000; totalsize < 0x100000; totalsize += 24000) {
            Path f = new Path(this.p, Integer.toString(totalsize, 36));
            TestIndexCache.writeFile(this.fs, f, totalsize, 1000);
            IndexRecord rec = cache.getIndexInformation(Integer.toString(totalsize, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
            TestIndexCache.checkRecord(rec, totalsize);
        }
        for (Path stat : this.fs.listStatus(this.p)) {
            this.fs.delete(stat.getPath(), true);
        }
        for (int i = 24000; i < 0x100000; i += 24000) {
            Path f = new Path(this.p, Integer.toString(i, 36));
            IndexRecord rec = cache.getIndexInformation(Integer.toString(i, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
            TestIndexCache.checkRecord(rec, i);
        }
        Path f = new Path(this.p, Integer.toString(totalsize, 36));
        TestIndexCache.writeFile(this.fs, f, totalsize, 1000);
        cache.getIndexInformation(Integer.toString(totalsize, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
        this.fs.delete(f, false);
        boolean fnf = false;
        try {
            cache.getIndexInformation(Integer.toString(24000, 36), r.nextInt(1000), new Path(this.p, Integer.toString(24000)), UserGroupInformation.getCurrentUser().getShortUserName());
        }
        catch (IOException e) {
            if (e.getCause() == null || !(e.getCause() instanceof FileNotFoundException)) {
                throw e;
            }
            fnf = true;
        }
        if (!fnf) {
            Assertions.fail((String)"Failed to push out last entry");
        }
        for (int i = 48000; i < 0x100000; i += 24000) {
            IndexRecord rec = cache.getIndexInformation(Integer.toString(i, 36), r.nextInt(1000), new Path(this.p, Integer.toString(i, 36)), UserGroupInformation.getCurrentUser().getShortUserName());
            TestIndexCache.checkRecord(rec, i);
        }
        IndexRecord rec = cache.getIndexInformation(Integer.toString(totalsize, 36), r.nextInt(1000), f, UserGroupInformation.getCurrentUser().getShortUserName());
        TestIndexCache.checkRecord(rec, totalsize);
    }

    @Test
    public void testBadIndex() throws Exception {
        block5: {
            int parts = 30;
            this.fs.delete(this.p, true);
            this.conf.setInt("mapreduce.reduce.shuffle.indexcache.mb", 1);
            IndexCache cache = new IndexCache(this.conf);
            Path f = new Path(this.p, "badindex");
            FSDataOutputStream out = this.fs.create(f, false);
            CheckedOutputStream iout = new CheckedOutputStream((OutputStream)out, new CRC32());
            DataOutputStream dout = new DataOutputStream(iout);
            for (int i = 0; i < 30; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (0 == i % 3) {
                        dout.writeLong(i);
                        continue;
                    }
                    out.writeLong((long)i);
                }
            }
            out.writeLong(iout.getChecksum().getValue());
            dout.close();
            try {
                cache.getIndexInformation("badindex", 7, f, UserGroupInformation.getCurrentUser().getShortUserName());
                Assertions.fail((String)"Did not detect bad checksum");
            }
            catch (IOException e) {
                if (e.getCause() instanceof ChecksumException) break block5;
                throw e;
            }
        }
    }

    @Test
    public void testInvalidReduceNumberOrLength() throws Exception {
        block5: {
            Path feq;
            IndexCache cache;
            block4: {
                this.fs.delete(this.p, true);
                this.conf.setInt("mapreduce.reduce.shuffle.indexcache.mb", 1);
                int partsPerMap = 1000;
                int bytesPerFile = 24000;
                cache = new IndexCache(this.conf);
                feq = new Path(this.p, "invalidReduceOrPartsPerMap");
                TestIndexCache.writeFile(this.fs, feq, 24000L, 1000);
                try {
                    cache.getIndexInformation("reduceEqualPartsPerMap", 1000, feq, UserGroupInformation.getCurrentUser().getShortUserName());
                    Assertions.fail((String)"Number of reducers equal to partsPerMap did not fail");
                }
                catch (Exception e) {
                    if (e instanceof IOException) break block4;
                    throw e;
                }
            }
            try {
                cache.getIndexInformation("reduceMorePartsPerMap", 1001, feq, UserGroupInformation.getCurrentUser().getShortUserName());
                Assertions.fail((String)"Number of reducers more than partsPerMap did not fail");
            }
            catch (Exception e) {
                if (e instanceof IOException) break block5;
                throw e;
            }
        }
    }

    @Test
    public void testRemoveMap() throws Exception {
        this.fs.delete(this.p, true);
        this.conf.setInt("mapreduce.reduce.shuffle.indexcache.mb", 10);
        int partsPerMap = 100000;
        int bytesPerFile = 2400000;
        final IndexCache cache = new IndexCache(this.conf);
        final Path big = new Path(this.p, "bigIndex");
        final String user = UserGroupInformation.getCurrentUser().getShortUserName();
        TestIndexCache.writeFile(this.fs, big, 2400000L, 100000);
        for (int i = 0; i < 20; ++i) {
            Thread getInfoThread = new Thread(){

                @Override
                public void run() {
                    try {
                        cache.getIndexInformation("bigIndex", 100000, big, user);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Thread removeMapThread = new Thread(){

                @Override
                public void run() {
                    cache.removeMap("bigIndex");
                }
            };
            if (i % 2 == 0) {
                getInfoThread.start();
                removeMapThread.start();
            } else {
                removeMapThread.start();
                getInfoThread.start();
            }
            getInfoThread.join();
            removeMapThread.join();
            Assertions.assertTrue((boolean)cache.checkTotalMemoryUsed());
        }
    }

    @Test
    public void testCreateRace() throws Exception {
        int i;
        this.fs.delete(this.p, true);
        this.conf.setInt("mapreduce.reduce.shuffle.indexcache.mb", 1);
        int partsPerMap = 1000;
        int bytesPerFile = 24000;
        final IndexCache cache = new IndexCache(this.conf);
        final Path racy = new Path(this.p, "racyIndex");
        final String user = UserGroupInformation.getCurrentUser().getShortUserName();
        TestIndexCache.writeFile(this.fs, racy, 24000L, 1000);
        Thread[] getInfoThreads = new Thread[50];
        for (i = 0; i < 50; ++i) {
            getInfoThreads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        cache.getIndexInformation("racyIndex", 1000, racy, user);
                        cache.removeMap("racyIndex");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
        for (i = 0; i < 50; ++i) {
            getInfoThreads[i].start();
        }
        final Thread mainTestThread = Thread.currentThread();
        Thread timeoutThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(15000L);
                    mainTestThread.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        for (int i2 = 0; i2 < 50; ++i2) {
            try {
                getInfoThreads[i2].join();
                continue;
            }
            catch (InterruptedException ie) {
                Assertions.fail((String)"Unexpectedly long delay during concurrent cache entry creations");
            }
        }
        timeoutThread.interrupt();
    }

    private static void checkRecord(IndexRecord rec, long fill) {
        Assertions.assertEquals((long)fill, (long)rec.startOffset);
        Assertions.assertEquals((long)fill, (long)rec.rawLength);
        Assertions.assertEquals((long)fill, (long)rec.partLength);
    }

    private static void writeFile(FileSystem fs, Path f, long fill, int parts) throws IOException {
        FSDataOutputStream out = fs.create(f, false);
        CheckedOutputStream iout = new CheckedOutputStream((OutputStream)out, new CRC32());
        DataOutputStream dout = new DataOutputStream(iout);
        for (int i = 0; i < parts; ++i) {
            for (int j = 0; j < 3; ++j) {
                dout.writeLong(fill);
            }
        }
        out.writeLong(iout.getChecksum().getValue());
        dout.close();
    }
}

