/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileInputFormat.class);
    private static String testTmpDir = System.getProperty("test.build.data", "/tmp");
    private static final Path TEST_ROOT_DIR = new Path(testTmpDir, "TestFIF");
    private static FileSystem localFs;
    private int numThreads;

    public void initTestFileInputFormat(int pNumThreads) {
        this.numThreads = pNumThreads;
        LOG.info("Running with numThreads: " + pNumThreads);
    }

    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{1}, {5}};
        return Arrays.asList(data);
    }

    @BeforeEach
    public void setup() throws IOException {
        LOG.info("Using Test Dir: " + TEST_ROOT_DIR);
        localFs = FileSystem.getLocal((Configuration)new Configuration());
        localFs.delete(TEST_ROOT_DIR, true);
        localFs.mkdirs(TEST_ROOT_DIR);
    }

    @AfterEach
    public void cleanup() throws IOException {
        localFs.delete(TEST_ROOT_DIR, true);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testListLocatedStatus(int pNumThreads) throws Exception {
        this.initTestFileInputFormat(pNumThreads);
        Configuration conf = this.getConfiguration();
        conf.setBoolean("fs.test.impl.disable.cache", false);
        conf.setInt("mapreduce.input.fileinputformat.list-status.num-threads", this.numThreads);
        conf.set("mapreduce.input.fileinputformat.inputdir", "test:///a1/a2");
        MockFileSystem mockFs = (MockFileSystem)new Path("test:///").getFileSystem(conf);
        Assertions.assertEquals((int)0, (int)mockFs.numListLocatedStatusCalls, (String)"listLocatedStatus already called");
        JobConf job = new JobConf(conf);
        TextInputFormat fileInputFormat = new TextInputFormat();
        fileInputFormat.configure(job);
        InputSplit[] splits = fileInputFormat.getSplits(job, 1);
        Assertions.assertEquals((int)2, (int)splits.length, (String)"Input splits are not correct");
        Assertions.assertEquals((int)1, (int)mockFs.numListLocatedStatusCalls, (String)"listLocatedStatus calls");
        FileSystem.closeAll();
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testIgnoreDirs(int pNumThreads) throws Exception {
        this.initTestFileInputFormat(pNumThreads);
        Configuration conf = this.getConfiguration();
        conf.setBoolean("mapreduce.input.fileinputformat.input.dir.nonrecursive.ignore.subdirs", true);
        conf.setInt("mapreduce.input.fileinputformat.list-status.num-threads", this.numThreads);
        conf.set("mapreduce.input.fileinputformat.inputdir", "test:///a1");
        MockFileSystem mockFs = (MockFileSystem)new Path("test:///").getFileSystem(conf);
        JobConf job = new JobConf(conf);
        TextInputFormat fileInputFormat = new TextInputFormat();
        fileInputFormat.configure(job);
        InputSplit[] splits = fileInputFormat.getSplits(job, 1);
        Assertions.assertEquals((int)1, (int)splits.length, (String)"Input splits are not correct");
        FileSystem.closeAll();
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testSplitLocationInfo(int pNumThreads) throws Exception {
        this.initTestFileInputFormat(pNumThreads);
        Configuration conf = this.getConfiguration();
        conf.set("mapreduce.input.fileinputformat.inputdir", "test:///a1/a2");
        JobConf job = new JobConf(conf);
        TextInputFormat fileInputFormat = new TextInputFormat();
        fileInputFormat.configure(job);
        FileSplit[] splits = (FileSplit[])fileInputFormat.getSplits(job, 1);
        String[] locations = splits[0].getLocations();
        Assertions.assertEquals((int)2, (int)locations.length);
        SplitLocationInfo[] locationInfo = splits[0].getLocationInfo();
        Assertions.assertEquals((int)2, (int)locationInfo.length);
        SplitLocationInfo localhostInfo = locations[0].equals("localhost") ? locationInfo[0] : locationInfo[1];
        SplitLocationInfo otherhostInfo = locations[0].equals("otherhost") ? locationInfo[0] : locationInfo[1];
        Assertions.assertTrue((boolean)localhostInfo.isOnDisk());
        Assertions.assertTrue((boolean)localhostInfo.isInMemory());
        Assertions.assertTrue((boolean)otherhostInfo.isOnDisk());
        Assertions.assertFalse((boolean)otherhostInfo.isInMemory());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testListStatusSimple(int pNumThreads) throws IOException {
        this.initTestFileInputFormat(pNumThreads);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.fileinputformat.list-status.num-threads", this.numThreads);
        List<Path> expectedPaths = org.apache.hadoop.mapreduce.lib.input.TestFileInputFormat.configureTestSimple(conf, localFs);
        JobConf jobConf = new JobConf(conf);
        TextInputFormat fif = new TextInputFormat();
        fif.configure(jobConf);
        Object[] statuses = fif.listStatus(jobConf);
        org.apache.hadoop.mapreduce.lib.input.TestFileInputFormat.verifyFileStatuses(expectedPaths, Lists.newArrayList((Object[])statuses), localFs);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testListStatusNestedRecursive(int pNumThreads) throws IOException {
        this.initTestFileInputFormat(pNumThreads);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.fileinputformat.list-status.num-threads", this.numThreads);
        List<Path> expectedPaths = org.apache.hadoop.mapreduce.lib.input.TestFileInputFormat.configureTestNestedRecursive(conf, localFs);
        JobConf jobConf = new JobConf(conf);
        TextInputFormat fif = new TextInputFormat();
        fif.configure(jobConf);
        Object[] statuses = fif.listStatus(jobConf);
        org.apache.hadoop.mapreduce.lib.input.TestFileInputFormat.verifyFileStatuses(expectedPaths, Lists.newArrayList((Object[])statuses), localFs);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testListStatusNestedNonRecursive(int pNumThreads) throws IOException {
        this.initTestFileInputFormat(pNumThreads);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.fileinputformat.list-status.num-threads", this.numThreads);
        List<Path> expectedPaths = org.apache.hadoop.mapreduce.lib.input.TestFileInputFormat.configureTestNestedNonRecursive(conf, localFs);
        JobConf jobConf = new JobConf(conf);
        TextInputFormat fif = new TextInputFormat();
        fif.configure(jobConf);
        Object[] statuses = fif.listStatus(jobConf);
        org.apache.hadoop.mapreduce.lib.input.TestFileInputFormat.verifyFileStatuses(expectedPaths, Lists.newArrayList((Object[])statuses), localFs);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testListStatusErrorOnNonExistantDir(int pNumThreads) throws IOException {
        this.initTestFileInputFormat(pNumThreads);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.fileinputformat.list-status.num-threads", this.numThreads);
        org.apache.hadoop.mapreduce.lib.input.TestFileInputFormat.configureTestErrorOnNonExistantDir(conf, localFs);
        JobConf jobConf = new JobConf(conf);
        TextInputFormat fif = new TextInputFormat();
        fif.configure(jobConf);
        try {
            fif.listStatus(jobConf);
            Assertions.fail((String)"Expecting an IOException for a missing Input path");
        }
        catch (IOException e) {
            Path expectedExceptionPath = new Path(TEST_ROOT_DIR, "input2");
            expectedExceptionPath = localFs.makeQualified(expectedExceptionPath);
            Assertions.assertInstanceOf(InvalidInputException.class, (Object)e);
            Assertions.assertEquals((Object)("Input path does not exist: " + expectedExceptionPath.toString()), (Object)e.getMessage());
        }
    }

    private Configuration getConfiguration() {
        Configuration conf = new Configuration();
        conf.set("fs.test.impl.disable.cache", "true");
        conf.setClass("fs.test.impl", MockFileSystem.class, FileSystem.class);
        conf.set("mapreduce.input.fileinputformat.inputdir", "test:///a1");
        return conf;
    }

    static class MockFileSystem
    extends RawLocalFileSystem {
        int numListLocatedStatusCalls = 0;

        MockFileSystem() {
        }

        public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
            if (f.toString().equals("test:/a1")) {
                return new FileStatus[]{new FileStatus(0L, true, 1, 150L, 150L, new Path("test:/a1/a2")), new FileStatus(10L, false, 1, 150L, 150L, new Path("test:/a1/file1"))};
            }
            if (f.toString().equals("test:/a1/a2")) {
                return new FileStatus[]{new FileStatus(10L, false, 1, 150L, 150L, new Path("test:/a1/a2/file2")), new FileStatus(10L, false, 1, 151L, 150L, new Path("test:/a1/a2/file3"))};
            }
            return new FileStatus[0];
        }

        public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
            return new FileStatus[]{new FileStatus(10L, true, 1, 150L, 150L, pathPattern)};
        }

        public FileStatus[] listStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
            return this.listStatus(f);
        }

        public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
            return new BlockLocation[]{new BlockLocation(new String[]{"localhost:9866", "otherhost:9866"}, new String[]{"localhost", "otherhost"}, new String[]{"localhost"}, new String[0], 0L, len, false)};
        }

        protected RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
            ++this.numListLocatedStatusCalls;
            return super.listLocatedStatus(f, filter);
        }
    }
}

