/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.junit.Assert;
import org.junit.Test;

public class TestJobSplitWriter {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), "TestJobSplitWriter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxBlockLocationsNewSplits() throws Exception {
        TEST_DIR.mkdirs();
        try {
            Configuration conf = new Configuration();
            conf.setInt("mapreduce.job.max.split.locations", 4);
            Path submitDir = new Path(TEST_DIR.getAbsolutePath());
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            org.apache.hadoop.mapreduce.lib.input.FileSplit split = new org.apache.hadoop.mapreduce.lib.input.FileSplit(new Path("/some/path"), 0L, 1L, new String[]{"loc1", "loc2", "loc3", "loc4", "loc5"});
            JobSplitWriter.createSplitFiles((Path)submitDir, (Configuration)conf, (FileSystem)fs, (InputSplit[])new org.apache.hadoop.mapreduce.lib.input.FileSplit[]{split});
            JobSplit.TaskSplitMetaInfo[] infos = SplitMetaInfoReader.readSplitMetaInfo((JobID)new JobID(), (FileSystem)fs, (Configuration)conf, (Path)submitDir);
            Assert.assertEquals((String)"unexpected number of splits", (long)1L, (long)infos.length);
            Assert.assertEquals((String)"unexpected number of split locations", (long)4L, (long)infos[0].getLocations().length);
        }
        finally {
            FileUtil.fullyDelete((File)TEST_DIR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxBlockLocationsOldSplits() throws Exception {
        TEST_DIR.mkdirs();
        try {
            Configuration conf = new Configuration();
            conf.setInt("mapreduce.job.max.split.locations", 4);
            Path submitDir = new Path(TEST_DIR.getAbsolutePath());
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileSplit split = new FileSplit(new Path("/some/path"), 0L, 1L, new String[]{"loc1", "loc2", "loc3", "loc4", "loc5"});
            JobSplitWriter.createSplitFiles((Path)submitDir, (Configuration)conf, (FileSystem)fs, (org.apache.hadoop.mapred.InputSplit[])new org.apache.hadoop.mapred.InputSplit[]{split});
            JobSplit.TaskSplitMetaInfo[] infos = SplitMetaInfoReader.readSplitMetaInfo((JobID)new JobID(), (FileSystem)fs, (Configuration)conf, (Path)submitDir);
            Assert.assertEquals((String)"unexpected number of splits", (long)1L, (long)infos.length);
            Assert.assertEquals((String)"unexpected number of split locations", (long)4L, (long)infos[0].getLocations().length);
        }
        finally {
            FileUtil.fullyDelete((File)TEST_DIR);
        }
    }
}

