/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.lib.partition.RehashPartitioner;
import org.junit.Assert;
import org.junit.Test;

public class TestRehashPartitioner {
    private static final int PARTITIONS = 32;
    private static final int STEP = 3;
    private static final int END = 100000;
    private static final double MAX_ERROR = 0.2;
    private static final double MAX_BADBUCKETS = 0.1;

    @Test
    public void testPatterns() {
        int[] results = new int[32];
        RehashPartitioner p = new RehashPartitioner();
        for (int i = 0; i < 100000; i += 3) {
            int n = p.getPartition((Object)new IntWritable(i), null, 32);
            results[n] = results[n] + 1;
        }
        int badbuckets = 0;
        Integer min = Collections.min(Arrays.asList(ArrayUtils.toObject((int[])results)));
        Integer max = Collections.max(Arrays.asList(ArrayUtils.toObject((int[])results)));
        Integer avg = (int)Math.round((double)(max + min) / 2.0);
        System.out.println("Dumping buckets distribution: min=" + min + " avg=" + avg + " max=" + max);
        for (int i = 0; i < 32; ++i) {
            double var = (double)(results[i] - avg) / (double)avg.intValue();
            System.out.println("bucket " + i + " " + results[i] + " items, variance " + var);
            if (!(Math.abs(var) > 0.2)) continue;
            ++badbuckets;
        }
        System.out.println(badbuckets + " of 32 are too small or large buckets");
        Assert.assertTrue((String)"too many overflow buckets", ((double)badbuckets < 3.2 ? 1 : 0) != 0);
    }
}

