/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UnreliableManifestStoreOperations
extends ManifestStoreOperations {
    private static final Logger LOG = LoggerFactory.getLogger(UnreliableManifestStoreOperations.class);
    public static final String E_TIMEOUT = "Operation could not be completed within the specified time";
    public static final String SIMULATED_FAILURE = "Simulated failure";
    private static final int DEFAULT_FAILURE_LIMIT = Integer.MAX_VALUE;
    private final ManifestStoreOperations wrappedOperations;
    private final Set<Path> deletePathsToFail = new HashSet<Path>();
    private final Set<Path> deletePathsToTimeOut = new HashSet<Path>();
    private final Set<Path> listToFail = new HashSet<Path>();
    private final Set<Path> mkdirsToFail = new HashSet<Path>();
    private final Set<Path> pathNotFound = new HashSet<Path>();
    private final Set<Path> renameSourceFilesToFail = new HashSet<Path>();
    private final Set<Path> renameDestDirsToFail = new HashSet<Path>();
    private final Set<Path> renamePathsToTimeoutBeforeRename = new HashSet<Path>();
    private final Set<Path> renamePathsToTimeoutAfterRename = new HashSet<Path>();
    private final Set<Path> saveToFail = new HashSet<Path>();
    private int timeoutSleepTimeMillis;
    private boolean renameToFailWithException = true;
    private final AtomicInteger failureLimit = new AtomicInteger(Integer.MAX_VALUE);

    public UnreliableManifestStoreOperations(ManifestStoreOperations wrappedOperations) {
        this.wrappedOperations = wrappedOperations;
    }

    public void reset() {
        this.deletePathsToFail.clear();
        this.deletePathsToTimeOut.clear();
        this.failureLimit.set(Integer.MAX_VALUE);
        this.pathNotFound.clear();
        this.renameSourceFilesToFail.clear();
        this.renameDestDirsToFail.clear();
        this.renamePathsToTimeoutBeforeRename.clear();
        this.renamePathsToTimeoutAfterRename.clear();
        this.saveToFail.clear();
        this.timeoutSleepTimeMillis = 0;
    }

    public int getTimeoutSleepTimeMillis() {
        return this.timeoutSleepTimeMillis;
    }

    public void setTimeoutSleepTimeMillis(int timeoutSleepTimeMillis) {
        this.timeoutSleepTimeMillis = timeoutSleepTimeMillis;
    }

    public boolean getRenameToFailWithException() {
        return this.renameToFailWithException;
    }

    public void setRenameToFailWithException(boolean renameToFailWithException) {
        this.renameToFailWithException = renameToFailWithException;
    }

    public void addDeletePathToFail(Path path) {
        this.deletePathsToFail.add(Objects.requireNonNull(path));
    }

    public void addDeletePathToTimeOut(Path path) {
        this.deletePathsToTimeOut.add(Objects.requireNonNull(path));
    }

    public void addListToFail(Path path) {
        this.listToFail.add(Objects.requireNonNull(path));
    }

    public void addMkdirsToFail(Path path) {
        this.mkdirsToFail.add(Objects.requireNonNull(path));
    }

    public void addPathNotFound(Path path) {
        this.pathNotFound.add(Objects.requireNonNull(path));
    }

    public void addRenameSourceFilesToFail(Path path) {
        this.renameSourceFilesToFail.add(Objects.requireNonNull(path));
    }

    public void addRenameDestDirsFail(Path path) {
        this.renameDestDirsToFail.add(Objects.requireNonNull(path));
    }

    public void addTimeoutBeforeRename(Path path) {
        this.renamePathsToTimeoutBeforeRename.add(Objects.requireNonNull(path));
    }

    public void addTimeoutAfterRename(Path path) {
        this.renamePathsToTimeoutAfterRename.add(Objects.requireNonNull(path));
    }

    public void addSaveToFail(Path path) {
        this.saveToFail.add(Objects.requireNonNull(path));
    }

    public void setFailureLimit(int limit) {
        this.failureLimit.set(limit);
    }

    private void maybeRaiseIOE(String operation, Path path, Set<Path> paths) throws IOException {
        if (paths.contains(path) && this.decrementAndCheckFailureLimit()) {
            this.maybeRaiseIOENoFailureLimitCheck(operation, path, paths);
        }
    }

    private void maybeRaiseIOENoFailureLimitCheck(String operation, Path path, Set<Path> paths) throws IOException {
        if (paths.contains(path)) {
            LOG.info("Simulating failure of {} with {}", (Object)operation, (Object)path);
            throw new PathIOException(path.toString(), UnreliableManifestStoreOperations.generatedErrorMessage(operation));
        }
    }

    public static String generatedErrorMessage(String operation) {
        return "Simulated failure of " + operation;
    }

    private boolean decrementAndCheckFailureLimit() {
        return this.failureLimit.decrementAndGet() > 0;
    }

    private void verifyExists(Path path) throws FileNotFoundException {
        if (this.pathNotFound.contains(path) && this.decrementAndCheckFailureLimit()) {
            throw new FileNotFoundException(path.toString());
        }
    }

    private void maybeTimeout(String operation, Path path, Set<Path> paths) throws SocketTimeoutException, InterruptedIOException {
        if (paths.contains(path) && this.decrementAndCheckFailureLimit()) {
            LOG.info("Simulating timeout of {} with {}", (Object)operation, (Object)path);
            try {
                if (this.timeoutSleepTimeMillis > 0) {
                    Thread.sleep(this.timeoutSleepTimeMillis);
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.toString());
            }
            throw new SocketTimeoutException(path.toString() + ": " + operation + " ErrorCode=OperationTimedOut ErrorMessage=Operation could not be completed within the specified time");
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        this.maybeTimeout("getFileStatus()", path, this.pathNotFound);
        this.verifyExists(path);
        return this.wrappedOperations.getFileStatus(path);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        String op = "delete";
        this.maybeTimeout(op, path, this.deletePathsToTimeOut);
        this.maybeRaiseIOE(op, path, this.deletePathsToFail);
        return this.wrappedOperations.delete(path, recursive);
    }

    public boolean mkdirs(Path path) throws IOException {
        this.maybeRaiseIOE("mkdirs", path, this.mkdirsToFail);
        return this.wrappedOperations.mkdirs(path);
    }

    public boolean renameFile(Path source, Path dest) throws IOException {
        String op = "rename";
        this.maybeTimeout(op, source, this.renamePathsToTimeoutBeforeRename);
        if (this.renameToFailWithException) {
            this.maybeRaiseIOE(op, source, this.renameSourceFilesToFail);
            this.maybeRaiseIOE(op, dest.getParent(), this.renameDestDirsToFail);
        } else if (this.renameSourceFilesToFail.contains(source) || this.renameDestDirsToFail.contains(dest.getParent()) && this.decrementAndCheckFailureLimit()) {
            LOG.info("Failing rename({}, {})", (Object)source, (Object)dest);
            return false;
        }
        boolean b = this.wrappedOperations.renameFile(source, dest);
        this.maybeTimeout(op, source, this.renamePathsToTimeoutAfterRename);
        return b;
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path path) throws IOException {
        this.verifyExists(path);
        this.maybeRaiseIOE("listStatus", path, this.listToFail);
        return this.wrappedOperations.listStatusIterator(path);
    }

    public TaskManifest loadTaskManifest(JsonSerialization<TaskManifest> serializer, FileStatus st) throws IOException {
        this.verifyExists(st.getPath());
        return this.wrappedOperations.loadTaskManifest(serializer, st);
    }

    public <T extends AbstractManifestData<T>> void save(T manifestData, Path path, boolean overwrite) throws IOException {
        this.maybeRaiseIOE("save", path, this.saveToFail);
        this.wrappedOperations.save(manifestData, path, overwrite);
    }

    public void msync(Path path) throws IOException {
        this.wrappedOperations.msync(path);
    }

    public String getEtag(FileStatus status) {
        return this.wrappedOperations.getEtag(status);
    }

    public boolean storeSupportsResilientCommit() {
        return this.wrappedOperations.storeSupportsResilientCommit();
    }

    public ManifestStoreOperations.CommitFileResult commitFile(FileEntry entry) throws IOException {
        String op = "commitFile";
        Path source = entry.getSourcePath();
        this.maybeTimeout("commitFile", source, this.renamePathsToTimeoutBeforeRename);
        if (this.renameToFailWithException) {
            this.maybeRaiseIOE("commitFile", source, this.renameSourceFilesToFail);
            this.maybeRaiseIOE("commitFile", entry.getDestPath().getParent(), this.renameDestDirsToFail);
        }
        ManifestStoreOperations.CommitFileResult result = this.wrappedOperations.commitFile(entry);
        this.maybeTimeout("commitFile", source, this.renamePathsToTimeoutAfterRename);
        return result;
    }

    public boolean storePreservesEtagsThroughRenames(Path path) {
        return this.wrappedOperations.storePreservesEtagsThroughRenames(path);
    }

    public void close() throws IOException {
        this.wrappedOperations.close();
    }
}

