/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;

public class ThreadLeakTracker {
    private final Set<String> trackedThreads = ThreadLeakTracker.listInitialThreadsForLifecycleChecks();

    public void assertNoThreadLeakage() {
        ((IterableAssert)Assertions.assertThat(ThreadLeakTracker.getCurrentThreadNames()).describedAs("The threads at the end of the test run", new Object[0])).isSubsetOf(this.trackedThreads);
    }

    public Set<String> getTrackedThreads() {
        return this.trackedThreads;
    }

    public static Set<String> getCurrentThreadNames() {
        TreeSet threads = Thread.getAllStackTraces().keySet().stream().map(Thread::getName).filter(n -> n.startsWith("JUnit")).filter(n -> n.startsWith("surefire")).collect(Collectors.toCollection(TreeSet::new));
        return threads;
    }

    public static Set<String> listInitialThreadsForLifecycleChecks() {
        Set<String> threadSet = ThreadLeakTracker.getCurrentThreadNames();
        threadSet.add("org.apache.hadoop.fs.FileSystem$Statistics$StatisticsDataReferenceCleaner");
        threadSet.add("process reaper");
        threadSet.add("MutableQuantiles-0");
        threadSet.add("Attach Listener");
        return threadSet;
    }
}

