/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterTestSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.EntryFileIO;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.LoadedManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.UnreliableManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.RenameFilesStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assume;
import org.junit.Test;

public class TestRenameStageFailure
extends AbstractManifestCommitterTest {
    public static final String RENAME_FAILURES = "commit_file_rename.failures";
    private static final int FAILING_FILE_INDEX = 5;
    private UnreliableManifestStoreOperations failures;
    private boolean etagsSupported;
    private boolean etagsPreserved;
    private boolean resilientCommit;
    private EntryFileIO entryFileIO;

    protected boolean isResilientCommit() {
        return this.resilientCommit;
    }

    protected boolean isEtagsPreserved() {
        return this.etagsPreserved;
    }

    protected boolean isEtagsSupported() {
        return this.etagsSupported;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        FileSystem fs = this.getFileSystem();
        Path methodPath = this.methodPath();
        this.etagsSupported = fs.hasPathCapability(methodPath, "fs.capability.etags.available");
        this.etagsPreserved = fs.hasPathCapability(methodPath, "fs.capability.etags.preserved.in.rename");
        ManifestStoreOperations wrappedOperations = this.getStoreOperations();
        this.failures = new UnreliableManifestStoreOperations(wrappedOperations);
        this.setStoreOperations(this.failures);
        this.resilientCommit = wrappedOperations.storeSupportsResilientCommit();
        this.entryFileIO = new EntryFileIO(this.getConfiguration());
    }

    protected boolean requireRenameResilience() throws IOException {
        return false;
    }

    @Test
    public void testResilienceAsExpected() throws Throwable {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isResilientCommit()).describedAs("resilient commit support", new Object[0])).isEqualTo(this.requireRenameResilience());
    }

    @Test
    public void testRenameSourceException() throws Throwable {
        this.describe("rename fails raising an IOE -expect stage to fail and exception message preserved");
        Path destDir = this.methodPath();
        StageConfig stageConfig = this.createStageConfigForJob(1, destDir);
        Path jobAttemptTaskSubDir = stageConfig.getJobAttemptTaskSubDir();
        TaskManifest manifest = new TaskManifest();
        this.createFileset(destDir, jobAttemptTaskSubDir, manifest, this.filesToCreate());
        List filesToCommit = manifest.getFilesToCommit();
        FileEntry entry = (FileEntry)filesToCommit.get(5);
        this.failures.addRenameSourceFilesToFail(entry.getSourcePath());
        this.expectRenameFailure(new RenameFilesStage(stageConfig), manifest, filesToCommit.size(), "Simulated failure", PathIOException.class);
    }

    protected int filesToCreate() {
        return 100;
    }

    @Test
    public void testCommitMissingFile() throws Throwable {
        this.describe("commit a file which doesn't exist. Expect FNFE always");
        Path destDir = this.methodPath();
        StageConfig stageConfig = this.createStageConfigForJob(1, destDir);
        Path jobAttemptTaskSubDir = stageConfig.getJobAttemptTaskSubDir();
        TaskManifest manifest = new TaskManifest();
        List filesToCommit = manifest.getFilesToCommit();
        Path source = new Path(jobAttemptTaskSubDir, "source.parquet");
        Path dest = new Path(destDir, "destdir.parquet");
        filesToCommit.add(new FileEntry(source, dest, 0L, null));
        FileNotFoundException ex = this.expectRenameFailure(new RenameFilesStage(stageConfig), manifest, 0, "", FileNotFoundException.class);
        LOG.info("Exception raised: {}", (Object)ex.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTargetPaths() throws Throwable {
        this.describe("Verify that target path deletion works");
        Path destDir = this.methodPath();
        StageConfig stageConfig = this.createStageConfigForJob(1, destDir).withDeleteTargetPaths(true);
        Path jobAttemptTaskSubDir = stageConfig.getJobAttemptTaskSubDir();
        Path source = new Path(jobAttemptTaskSubDir, "source.txt");
        Path dest = new Path(destDir, "source.txt");
        byte[] sourceData = "data".getBytes(StandardCharsets.UTF_8);
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.createFile((FileSystem)fs, (Path)source, (boolean)false, (byte[])sourceData);
        ContractTestUtils.touch((FileSystem)fs, (Path)dest);
        TaskManifest manifest = new TaskManifest();
        FileEntry entry = this.createEntryWithEtag(source, dest);
        manifest.addFileToCommit(entry);
        ArrayList<TaskManifest> manifests = new ArrayList<TaskManifest>();
        manifests.add(manifest);
        boolean renameOverwritesDest = this.isSupported("rename-overwrites-dest");
        if (!renameOverwritesDest) {
            IOException ex = this.expectRenameFailure(new RenameFilesStage(stageConfig.withDeleteTargetPaths(false)), manifest, 0, "", IOException.class);
            LOG.info("Exception raised: {}", (Object)ex.toString());
        }
        LoadedManifestData manifestData = ManifestCommitterTestSupport.saveManifest(this.entryFileIO, manifest);
        try {
            new RenameFilesStage(stageConfig.withDeleteTargetPaths(true)).apply((Object)Triple.of((Object)manifestData, Collections.emptySet(), (Object)100));
        }
        finally {
            manifestData.getEntrySequenceFile().delete();
        }
        ContractTestUtils.verifyFileContents((FileSystem)fs, (Path)dest, (byte[])sourceData);
        if (this.isEtagsPreserved()) {
            ((AbstractStringAssert)Assertions.assertThat((String)ManifestCommitterSupport.getEtag((FileStatus)fs.getFileStatus(dest))).describedAs("Etag of destination file %s", new Object[]{dest})).isEqualTo((Object)entry.getEtag());
        }
    }

    @Test
    public void testRenameReturnsFalse() throws Throwable {
        this.describe("commit where rename() returns false for one file. Expect failure to be escalated to an IOE");
        Assume.assumeTrue((String)"not used when resilient commits are available", (!this.resilientCommit ? 1 : 0) != 0);
        Path destDir = this.methodPath();
        StageConfig stageConfig = this.createStageConfigForJob(1, destDir);
        Path jobAttemptTaskSubDir = stageConfig.getJobAttemptTaskSubDir();
        TaskManifest manifest = new TaskManifest();
        this.createFileset(destDir, jobAttemptTaskSubDir, manifest, this.filesToCreate());
        List filesToCommit = manifest.getFilesToCommit();
        FileEntry entry = (FileEntry)filesToCommit.get(5);
        this.failures.addRenameSourceFilesToFail(entry.getSourcePath());
        this.failures.setRenameToFailWithException(false);
        this.expectRenameFailure(new RenameFilesStage(stageConfig), manifest, filesToCommit.size(), "Failed to ", PathIOException.class);
    }

    private void createFileset(Path destDir, Path taskAttemptDir, TaskManifest manifest, int fileCount) throws IOException {
        FileSystem fs = this.getFileSystem();
        for (int i = 0; i < fileCount; ++i) {
            String name = String.format("file%04d", i);
            Path src = new Path(taskAttemptDir, name);
            Path dest = new Path(destDir, name);
            ContractTestUtils.touch((FileSystem)fs, (Path)src);
            FileEntry entry = this.createEntryWithEtag(src, dest);
            manifest.addFileToCommit(entry);
        }
    }

    private FileEntry createEntryWithEtag(Path source, Path dest) throws IOException {
        FileStatus st = this.getFileSystem().getFileStatus(source);
        String etag = this.isEtagsSupported() ? ManifestCommitterSupport.getEtag((FileStatus)st) : null;
        return new FileEntry(source, dest, st.getLen(), etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Throwable> E expectRenameFailure(RenameFilesStage stage, TaskManifest manifest, int files, String errorText, Class<E> exceptionClass) throws Exception {
        Throwable ex;
        ArrayList<TaskManifest> manifests = new ArrayList<TaskManifest>();
        manifests.add(manifest);
        AbstractManifestCommitterTest.ProgressCounter progressCounter = this.getProgressCounter();
        progressCounter.reset();
        IOStatisticsStore iostatistics = stage.getIOStatistics();
        long failures0 = (Long)iostatistics.counters().get(RENAME_FAILURES);
        LoadedManifestData manifestData = ManifestCommitterTestSupport.saveManifest(this.entryFileIO, manifest);
        try {
            ex = LambdaTestUtils.intercept(exceptionClass, (String)errorText, () -> (ManifestSuccessData)stage.apply((Object)Triple.of((Object)manifestData, Collections.emptySet(), (Object)100)));
        }
        finally {
            manifestData.getEntrySequenceFile().delete();
        }
        LOG.info("Statistics {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)iostatistics));
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)iostatistics, (String)RENAME_FAILURES).isEqualTo(failures0 + 1L);
        if (files > 0) {
            ((ListAssert)((ListAssert)Assertions.assertThat((List)stage.getFilesCommitted()).describedAs("Files Committed by stage", new Object[0])).isNotEmpty()).hasSizeLessThan(files);
        }
        ((AbstractLongAssert)Assertions.assertThat((long)progressCounter.value()).describedAs("Progress counter %s", new Object[]{progressCounter})).isGreaterThan(0L);
        return (E)ex;
    }
}

