/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSetters;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestPrinter;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CreateOutputDirectoriesStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.LoadManifestsStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.Test;

public class TestLoadManifestsStage
extends AbstractManifestCommitterTest {
    public static final int FILES_PER_TASK_ATTEMPT = 100;
    private int taskAttemptCount;
    private File entryFile;

    protected int numberOfTaskAttempts() {
        return 2000;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.taskAttemptCount = this.numberOfTaskAttempts();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.taskAttemptCount).describedAs("Task attempt count", new Object[0])).isGreaterThan(0);
    }

    @Override
    public void teardown() throws Exception {
        if (this.entryFile != null) {
            this.entryFile.delete();
        }
        super.teardown();
    }

    public long heapSize() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Test
    public void testSaveThenLoadManyManifests() throws Throwable {
        this.describe("Creating many manifests with fake file/dir entries, load them and prepare the output dirs.");
        int filesPerTaskAttempt = 100;
        LOG.info("Number of task attempts: {}, files per task attempt {}", (Object)this.taskAttemptCount, (Object)filesPerTaskAttempt);
        StageConfig stageConfig = this.createStageConfigForJob(1, this.getDestDir());
        this.setJobStageConfig(stageConfig);
        new SetupJobStage(stageConfig).apply((Object)false);
        LOG.info("Creating manifest files for {}", (Object)this.taskAttemptCount);
        this.executeTaskAttempts(this.taskAttemptCount, filesPerTaskAttempt);
        IOStatisticsSnapshot heapInfo = new IOStatisticsSnapshot();
        TestLoadManifestsStage.heapinfo(heapInfo, "initial");
        LOG.info("Loading in the manifests");
        LoadManifestsStage stage = new LoadManifestsStage(stageConfig);
        this.entryFile = File.createTempFile("entry", ".seq");
        LoadManifestsStage.Arguments args = new LoadManifestsStage.Arguments(this.entryFile, 32);
        LoadManifestsStage.Result loadManifestsResult = (LoadManifestsStage.Result)stage.apply((Object)args);
        LoadManifestsStage.SummaryInfo summary = loadManifestsResult.getSummary();
        LOG.info("\nJob statistics after loading {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)this.getStageStatistics()));
        LOG.info("Heap size = {}", (Object)this.heapSize());
        TestLoadManifestsStage.heapinfo(heapInfo, "load.manifests");
        ((AbstractLongAssert)Assertions.assertThat((long)summary.getManifestCount()).describedAs("Manifest count of  %s", new Object[]{summary})).isEqualTo((long)this.taskAttemptCount);
        ((AbstractLongAssert)Assertions.assertThat((long)summary.getFileCount()).describedAs("File count of  %s", new Object[]{summary})).isEqualTo((long)this.taskAttemptCount * (long)filesPerTaskAttempt);
        ((AbstractLongAssert)Assertions.assertThat((long)summary.getTotalFileSize()).describedAs("File Size of  %s", new Object[]{summary})).isEqualTo(this.getTotalDataSize());
        List manifestTaskIds = summary.getTaskIDs();
        ((ListAssert)Assertions.assertThat(this.getTaskIds()).describedAs("Task IDs of all tasks", new Object[0])).containsExactlyInAnyOrderElementsOf((Iterable)manifestTaskIds);
        Set createdDirectories = ((CreateOutputDirectoriesStage.Result)new CreateOutputDirectoriesStage(stageConfig).apply((Object)loadManifestsResult.getLoadedManifestData().getDirectories())).getCreatedDirectories();
        TestLoadManifestsStage.heapinfo(heapInfo, "create.directories");
        ((IterableAssert)Assertions.assertThat((Iterable)createdDirectories).describedAs("Directories created", new Object[0])).hasSize(filesPerTaskAttempt);
        new CleanupJobStage(stageConfig).apply((Object)new CleanupJobStage.Arguments("", true, true, false, false, 0L));
        TestLoadManifestsStage.heapinfo(heapInfo, "cleanup");
        ManifestSuccessData success = ManifestCommitterSupport.createManifestOutcome((StageConfig)stageConfig, (String)"committer_commit_job");
        success.snapshotIOStatistics((IOStatistics)this.getStageStatistics());
        success.getIOStatistics().aggregate((IOStatistics)heapInfo);
        Configuration conf = this.getConfiguration();
        this.enableManifestCommitter(conf);
        String reportDir = conf.getTrimmed("mapreduce.manifest.committer.summary.report.directory", "");
        Path reportDirPath = new Path(reportDir);
        Path path = new Path(reportDirPath, ManifestCommitterSupport.createJobSummaryFilename((String)"TestLoadManifestsStage"));
        FileSystem summaryFS = path.getFileSystem(conf);
        success.save(summaryFS, path, true);
        LOG.info("Saved summary to {}", (Object)path);
        new ManifestPrinter().loadAndPrintManifest(summaryFS, path);
    }

    private static void heapinfo(IOStatisticsSnapshot stats, String stage) {
        System.gc();
        ManifestCommitterSupport.addHeapInformation((IOStatisticsSetters)stats, (String)stage);
    }
}

