/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.EntryStatus;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CreateOutputDirectoriesStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class TestCreateOutputDirectoriesStage
extends AbstractManifestCommitterTest {
    protected static final int DEEP_TREE_WIDTH = 4;
    private static final int DIRECTORIES_CREATED_IN_SETUP = 2;
    private Path destDir;
    private CreateOutputDirectoriesStage mkdirStage;
    private StageConfig stageConfig;
    private IOStatisticsStore iostats;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.destDir = this.methodPath();
        this.destDir.getFileSystem(this.getConfiguration()).delete(this.destDir, true);
        this.setStoreOperations(this.createManifestStoreOperations());
        this.stageConfig = this.createStageConfigForJob(1, this.destDir).withDeleteTargetPaths(true);
        this.setJobStageConfig(this.stageConfig);
        new SetupJobStage(this.stageConfig).apply((Object)true);
        this.mkdirStage = new CreateOutputDirectoriesStage(this.stageConfig);
        this.iostats = this.stageConfig.getIOStatistics();
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_mkdirs", (long)2L);
        this.iostats.getCounterReference("op_mkdirs").set(0L);
    }

    @Test
    public void testPrepareSomeDirs() throws Throwable {
        long initialFileStatusCount = IOStatisticAssertions.lookupCounterStatistic((IOStatistics)this.iostats, (String)"op_get_file_status");
        int dirCount = 8;
        List<Path> dirs = this.subpaths(this.destDir, 8);
        List<DirEntry> dirEntries = this.dirEntries(dirs, 1, EntryStatus.not_found);
        dirEntries.addAll(this.dirEntries(dirs, 1, EntryStatus.not_found));
        CreateOutputDirectoriesStage.Result result = (CreateOutputDirectoriesStage.Result)this.mkdirStage.apply(dirEntries);
        ((IterableAssert)Assertions.assertThat((Iterable)result.getCreatedDirectories()).describedAs("output of %s", new Object[]{this.mkdirStage})).containsExactlyInAnyOrderElementsOf(dirs);
        LOG.info("Job Statistics\n{}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)this.iostats));
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_mkdirs", (long)8L);
        CreateOutputDirectoriesStage s2 = new CreateOutputDirectoriesStage(this.stageConfig);
        CreateOutputDirectoriesStage.Result r2 = (CreateOutputDirectoriesStage.Result)s2.apply(this.dirEntries(dirs, 1, EntryStatus.dir));
        ((IterableAssert)Assertions.assertThat((Iterable)r2.getCreatedDirectories()).describedAs("output of %s", new Object[]{s2})).isEmpty();
        LOG.info("Job Statistics after second pass\n{}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)this.iostats));
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_get_file_status", (long)initialFileStatusCount);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_mkdirs", (long)8L);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_delete_file_under_destination", (long)0L);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_is_file", (long)0L);
    }

    protected List<DirEntry> dirEntries(Collection<Path> paths, int level, EntryStatus entryStatus) {
        return paths.stream().map(p -> DirEntry.dirEntry((Path)p, (EntryStatus)entryStatus, (int)level)).collect(Collectors.toList());
    }

    private static void assertDirMapStatus(CreateOutputDirectoriesStage.Result result, Path path, CreateOutputDirectoriesStage.DirMapState expected) {
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)result.getDirMap()).describedAs("Directory Map entry for %s", new Object[]{path})).isNotNull()).containsKey((Object)path)).containsEntry((Object)path, (Object)expected);
    }

    @Test
    public void testPrepareDirtyTree() throws Throwable {
        int c = this.getDeepTreeWidth();
        List<Path> level1 = this.subpaths(this.destDir, c);
        List<Path> level2 = level1.stream().flatMap(p -> this.subpaths((Path)p, c).stream()).collect(Collectors.toList());
        List<Path> level3 = level2.stream().flatMap(p -> this.subpaths((Path)p, c).stream()).collect(Collectors.toList());
        ArrayList<DirEntry> directories = new ArrayList<DirEntry>();
        List<DirEntry> l1 = this.dirEntries(level1, 1, EntryStatus.not_found);
        directories.addAll(l1);
        List<DirEntry> l3 = this.dirEntries(level3, 3, EntryStatus.not_found);
        directories.addAll(l3);
        List<DirEntry> l2 = this.dirEntries(level2, 2, EntryStatus.not_found);
        directories.addAll(l2);
        DirEntry parentIsFile = l1.get(1);
        DirEntry parentIsDir = l2.get(0);
        DirEntry leafIsFile = l3.get(0);
        CompletableFuture.allOf(this.asyncPut(parentIsFile.getDestPath(), NO_DATA), this.asyncPut(leafIsFile.getDestPath(), NO_DATA), this.asyncMkdir(parentIsDir.getDestPath())).join();
        parentIsFile.setStatus(EntryStatus.file);
        parentIsDir.setStatus(EntryStatus.dir);
        leafIsFile.setStatus(EntryStatus.file);
        CreateOutputDirectoriesStage.Result result = (CreateOutputDirectoriesStage.Result)this.mkdirStage.apply(directories);
        LOG.info("Job Statistics\n{}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)this.iostats));
        TestCreateOutputDirectoriesStage.assertDirMapStatus(result, leafIsFile.getDestPath(), CreateOutputDirectoriesStage.DirMapState.fileNowDeleted);
        TestCreateOutputDirectoriesStage.assertDirMapStatus(result, parentIsFile.getDestPath(), CreateOutputDirectoriesStage.DirMapState.fileNowDeleted);
        ((IterableAssert)Assertions.assertThat((Iterable)result.getCreatedDirectories()).describedAs("output of %s", new Object[]{this.mkdirStage})).containsExactlyInAnyOrderElementsOf(level3);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_mkdirs", (long)level3.size());
        CreateOutputDirectoriesStage attempt2 = new CreateOutputDirectoriesStage(this.createStageConfigForJob(1, this.destDir).withDeleteTargetPaths(false));
        LOG.info("Executing failing attempt to create the directories");
        LambdaTestUtils.intercept(IOException.class, () -> (CreateOutputDirectoriesStage.Result)attempt2.apply((Object)directories));
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_prepare_dir_ancestors.failures", (long)1L);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.iostats, (String)"op_delete.failures", (long)1L);
        ArrayList<DirEntry> directories3 = new ArrayList<DirEntry>();
        directories3.addAll(this.dirEntries(level1, 1, EntryStatus.dir));
        directories3.addAll(this.dirEntries(level2, 2, EntryStatus.dir));
        directories3.addAll(this.dirEntries(level3, 3, EntryStatus.dir));
        CreateOutputDirectoriesStage attempt3 = new CreateOutputDirectoriesStage(this.createStageConfigForJob(1, this.destDir).withDeleteTargetPaths(true));
        CreateOutputDirectoriesStage.Result r3 = (CreateOutputDirectoriesStage.Result)attempt3.apply(directories3);
        TestCreateOutputDirectoriesStage.assertDirMapStatus(r3, leafIsFile.getDestPath(), CreateOutputDirectoriesStage.DirMapState.dirFoundInStore);
        ((IterableAssert)Assertions.assertThat((Iterable)r3.getCreatedDirectories()).describedAs("created directories", new Object[0])).isEmpty();
    }

    protected int getDeepTreeWidth() {
        return 4;
    }
}

