/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.contract.localfs.LocalFSContract;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConstants;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterTestSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ThreadLeakTracker;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.UnreliableManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SaveTaskManifestStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.functional.CloseableTaskPoolSubmitter;
import org.apache.hadoop.util.functional.FutureIO;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.apache.hadoop.util.functional.TaskPool;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.AfterClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManifestCommitterTest
extends AbstractFSContractTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractManifestCommitterTest.class);
    protected static final ManifestCommitterTestSupport.JobAndTaskIDsForTests TASK_IDS = new ManifestCommitterTestSupport.JobAndTaskIDsForTests(2, 2);
    public static final int JOB1 = 1;
    public static final int TASK0 = 0;
    public static final int TASK1 = 1;
    public static final int TA0 = 0;
    public static final int TA1 = 1;
    public static final int DEPTH = 3;
    public static final int WIDTH = 2;
    public static final int FILES_PER_DIRECTORY = 4;
    public static final int POOL_SIZE = 32;
    protected static final IOStatisticsSnapshot FILESYSTEM_IOSTATS = IOStatisticsSupport.snapshotIOStatistics();
    private static final AtomicLong CREATE_FILE_COUNTER = new AtomicLong();
    protected static final byte[] NO_DATA = new byte[0];
    private static final ThreadLeakTracker THREAD_LEAK_TRACKER = new ThreadLeakTracker();
    private static final int MAX_LEN = 64000;
    public static final int SAVE_ATTEMPTS = 4;
    private CloseableTaskPoolSubmitter submitter;
    private IOStatisticsStore stageStatistics;
    private ManifestStoreOperations storeOperations;
    private final ProgressCounter progressCounter = new ProgressCounter();
    private File reportDir;
    private final List<String> taskAttemptIds = new ArrayList<String>();
    private final List<String> taskIds = new ArrayList<String>();
    private StageConfig jobStageConfig;
    private Path destDir;
    private final AtomicLong totalDataSize = new AtomicLong();
    private Path manifestDir;
    private final AtomicLong fileDataGenerator = new AtomicLong();

    protected Configuration getConfiguration() {
        return this.getContract().getConf();
    }

    protected ManifestStoreOperations getStoreOperations() {
        return this.storeOperations;
    }

    protected void setStoreOperations(ManifestStoreOperations storeOperations) {
        this.storeOperations = storeOperations;
    }

    public List<String> getTaskAttemptIds() {
        return this.taskAttemptIds;
    }

    public List<String> getTaskIds() {
        return this.taskIds;
    }

    public long getTotalDataSize() {
        return this.totalDataSize.get();
    }

    public Path getManifestDir() {
        return this.manifestDir;
    }

    public AbstractManifestCommitterTest withManifestDir(Path value) {
        this.manifestDir = value;
        return this;
    }

    protected void describe(String text, Object ... args) {
        LOG.info("\n\n{}: {}\n", (Object)this.getMethodName(), (Object)String.format(text, args));
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new LocalFSContract(conf);
    }

    protected Configuration createConfiguration() {
        return this.enableManifestCommitter(super.createConfiguration());
    }

    public void setup() throws Exception {
        this.reportDir = new File(ManifestCommitterTestSupport.getProjectBuildDir(), "reports");
        this.reportDir.mkdirs();
        super.setup();
        this.manifestDir = this.path("manifests");
        this.setDestDir(this.methodPath());
        this.setStageStatistics(ManifestCommitterSupport.createIOStatisticsStore().build());
        this.setSubmitter(ManifestCommitterConfig.createCloseableTaskSubmitter((int)32, (String)TASK_IDS.getJobId()));
        this.storeOperations = this.createManifestStoreOperations();
    }

    protected ManifestStoreOperations createManifestStoreOperations() throws IOException {
        FileSystem fs = this.getFileSystem();
        return ManifestCommitterSupport.createManifestStoreOperations((Configuration)fs.getConf(), (FileSystem)fs, (Path)this.getTestPath());
    }

    public void teardown() throws Exception {
        Thread.currentThread().setName("teardown");
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.storeOperations, this.getSubmitter()});
        this.storeOperations = null;
        super.teardown();
        FILESYSTEM_IOSTATS.aggregate(IOStatisticsSupport.retrieveIOStatistics((Object)this.getFileSystem()));
        FILESYSTEM_IOSTATS.aggregate((IOStatistics)this.getStageStatistics());
    }

    protected int getTestTimeoutMillis() {
        return 600000;
    }

    protected Path getTestPath() {
        return this.getContract().getTestPath();
    }

    protected CloseableTaskPoolSubmitter getSubmitter() {
        return this.submitter;
    }

    protected void setSubmitter(CloseableTaskPoolSubmitter submitter) {
        this.submitter = submitter;
    }

    protected ExecutorService getExecutorService() {
        return this.getSubmitter().getPool();
    }

    protected final IOStatisticsStore getStageStatistics() {
        return this.stageStatistics;
    }

    protected final void setStageStatistics(IOStatisticsStore stageStatistics) {
        this.stageStatistics = stageStatistics;
    }

    protected final ProgressCounter getProgressCounter() {
        return this.progressCounter;
    }

    public final File getReportDir() {
        return this.reportDir;
    }

    public final URI getReportDirUri() {
        return this.getReportDir().toURI();
    }

    protected static ThreadLeakTracker getThreadLeakTracker() {
        return THREAD_LEAK_TRACKER;
    }

    @AfterClass
    public static void threadLeakage() {
        THREAD_LEAK_TRACKER.assertNoThreadLeakage();
    }

    @AfterClass
    public static void dumpFileSystemIOStatistics() {
        LOG.info("Aggregate FileSystem Statistics {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)FILESYSTEM_IOSTATS));
    }

    public final List<Path> createFilesOrDirs(Path base, String prefix, ExecutorService executor, int depth, int width, int files, boolean createDirs) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, true, "Creating Files %s (%d, %d, %d) under %s", new Object[]{prefix, depth, width, files, base});){
            this.assertPathExists("Task attempt dir", base);
            List<Future<Path>> futures = this.createFilesOrDirs(new ArrayList<Future<Path>>(), base, prefix, executor, depth, width, files, createDirs);
            ArrayList<Path> result = new ArrayList<Path>();
            for (Future<Path> f : futures) {
                result.add((Path)FutureIO.awaitFuture(f));
            }
            ArrayList<Path> arrayList = result;
            return arrayList;
        }
    }

    private List<Future<Path>> createFilesOrDirs(List<Future<Path>> futures, Path base, String prefix, ExecutorService executor, int depth, int width, int files, boolean createDirs) {
        if (depth > 0) {
            for (int i = 0; i < width; ++i) {
                Path child = new Path(base, String.format("dir-%02d-%02d", depth, i));
                this.createFilesOrDirs(futures, child, prefix, executor, depth - 1, width, files, false);
            }
        } else {
            for (int i = 0; i < files; ++i) {
                Path file = new Path(base, String.format("%s-%04d", prefix, CREATE_FILE_COUNTER.incrementAndGet()));
                long entry = this.fileDataGenerator.incrementAndGet() & 0xFFFFL;
                byte[] data = new byte[]{(byte)(entry & 0xFFL), (byte)((entry & 0xFF00L) >> 8)};
                Future<Path> f = executor.submit(() -> {
                    if (!createDirs) {
                        ContractTestUtils.createFile((FileSystem)this.getFileSystem(), (Path)file, (boolean)true, (byte[])data);
                    } else {
                        this.mkdirs(file);
                    }
                    return file;
                });
                futures.add(f);
            }
        }
        return futures;
    }

    protected List<Path> subpaths(Path base, int count) {
        return IntStream.rangeClosed(1, count).mapToObj(i -> new Path(base, String.format("entry-%02d", i))).collect(Collectors.toList());
    }

    protected CompletableFuture<Path> asyncMkdir(Path path) {
        CompletableFuture<Path> f = new CompletableFuture<Path>();
        this.getExecutorService().submit(() -> {
            try {
                this.mkdirs(path);
                f.complete(path);
            }
            catch (IOException e) {
                f.completeExceptionally(e);
            }
        });
        return f;
    }

    protected void asyncMkdirs(Collection<Path> paths) throws IOException {
        ArrayList<CompletableFuture<Path>> futures = new ArrayList<CompletableFuture<Path>>();
        for (Path path : paths) {
            futures.add(this.asyncMkdir(path));
        }
        for (Future future : futures) {
            FutureIO.awaitFuture((Future)future);
        }
    }

    protected CompletableFuture<Path> asyncPut(Path path, byte[] data) {
        CompletableFuture<Path> f = new CompletableFuture<Path>();
        this.getExecutorService().submit(() -> {
            try {
                ContractTestUtils.createFile((FileSystem)this.getFileSystem(), (Path)path, (boolean)true, (byte[])data);
                f.complete(path);
            }
            catch (IOException e) {
                f.completeExceptionally(e);
            }
        });
        return f;
    }

    protected Map<String, TaskManifest> toMap(List<TaskManifest> list) {
        return list.stream().collect(Collectors.toMap(TaskManifest::getTaskAttemptID, x -> x));
    }

    protected void verifyManifestFilesMatch(TaskManifest manifest, List<Path> files) {
        Set filesToRename = manifest.getFilesToCommit().stream().map(FileEntry::getSourcePath).collect(Collectors.toSet());
        Assertions.assertThat(filesToRename).containsExactlyInAnyOrderElementsOf(files);
    }

    protected TaskManifest verifyManifestTaskAttemptID(TaskManifest manifest, String attemptId) {
        ((ObjectAssert)Assertions.assertThat((Object)manifest).describedAs("Manifest of task %s", new Object[]{attemptId})).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)manifest.getTaskAttemptID()).describedAs("Task Attempt ID of manifest %s", new Object[]{manifest})).isEqualTo((Object)attemptId);
        return manifest;
    }

    Path pathMustExist(String message, Path path) throws IOException {
        this.assertPathExists(message, path);
        return path;
    }

    Path verifyPath(String message, Path expectedPath, Path actualPath) throws IOException {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualPath).describedAs(message, new Object[0])).isEqualTo((Object)expectedPath);
        return this.pathMustExist(message, actualPath);
    }

    protected ManifestSuccessData verifySuccessMarker(Path dir, String jobId) throws IOException {
        return ManifestCommitterTestSupport.validateSuccessFile(this.getFileSystem(), dir, 0, jobId);
    }

    protected String readFile(Path path) throws IOException {
        return ContractTestUtils.readUTF8((FileSystem)this.getFileSystem(), (Path)path, (int)-1);
    }

    protected Configuration enableManifestCommitter(Configuration conf) {
        conf.set("mapreduce.outputcommitter.factory.class", ManifestCommitterConstants.MANIFEST_COMMITTER_FACTORY);
        conf.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true);
        conf.setBoolean("mapreduce.manifest.committer.validate.output", true);
        if (this.getManifestDir() != null) {
            conf.set("mapreduce.manifest.committer.diagnostics.manifest.directory", this.getManifestDir().toUri().toString());
        }
        conf.set("mapreduce.manifest.committer.summary.report.directory", this.getReportDirUri().toString());
        return conf;
    }

    protected StageConfig createStageConfigForJob(int jobAttemptNumber, Path outputPath) {
        return this.createStageConfig(jobAttemptNumber, -1, 0, outputPath);
    }

    protected StageConfig createStageConfig(int jobAttemptNumber, int taskIndex, int taskAttemptNumber, Path outputPath) {
        String jobId = TASK_IDS.getJobId();
        ManifestCommitterSupport.AttemptDirectories attemptDirs = new ManifestCommitterSupport.AttemptDirectories(outputPath, jobId, jobAttemptNumber);
        StageConfig config = new StageConfig();
        config.withConfiguration(this.getConfiguration()).withIOProcessors((TaskPool.Submitter)this.getSubmitter()).withIOStatistics(this.getStageStatistics()).withJobId(jobId).withJobIdSource("JobID").withJobAttemptNumber(jobAttemptNumber).withJobDirectories(attemptDirs).withName(String.format("[Job-Attempt %s]", jobId)).withManifestSaveAttempts(4).withOperations(this.getStoreOperations()).withProgressable((Progressable)this.getProgressCounter()).withSuccessMarkerFileLimit(100000).withWriterQueueCapacity(32);
        if (taskIndex >= 0) {
            String taskAttempt = TASK_IDS.getTaskAttempt(taskIndex, taskAttemptNumber);
            config.withTaskAttemptId(taskAttempt).withTaskId(TASK_IDS.getTaskIdType(taskIndex).toString()).withTaskAttemptDir(attemptDirs.getTaskAttemptPath(taskAttempt));
        }
        return config;
    }

    protected StageConfig getJobStageConfig() {
        return this.jobStageConfig;
    }

    protected void setJobStageConfig(StageConfig jobStageConfig) {
        this.jobStageConfig = jobStageConfig;
    }

    protected Path getDestDir() {
        return this.destDir;
    }

    protected void setDestDir(Path destDir) {
        this.destDir = destDir;
    }

    protected List<TaskManifest> executeTaskAttempts(int taskAttemptCount, int filesPerTaskAttempt) throws IOException {
        try (DurationInfo di = new DurationInfo(LOG, true, "create manifests", new Object[0]);){
            ArrayList<Integer> taskIdList = new ArrayList<Integer>(taskAttemptCount);
            for (int t = 0; t < taskAttemptCount; ++t) {
                taskIdList.add(t);
            }
            List<TaskManifest> manifests = Collections.synchronizedList(new ArrayList());
            TaskPool.foreach(taskIdList).executeWith((TaskPool.Submitter)this.getSubmitter()).stopOnFailure().run(i -> manifests.add(this.executeOneTaskAttempt((int)i, i & 3, filesPerTaskAttempt)));
            List<TaskManifest> list = manifests;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskManifest executeOneTaskAttempt(int task, int taskAttempt, int filesPerTaskAttempt) throws IOException {
        String tid = String.format("task_%03d", task);
        String taskAttemptId = String.format("%s_%02d", tid, taskAttempt);
        AbstractManifestCommitterTest abstractManifestCommitterTest = this;
        synchronized (abstractManifestCommitterTest) {
            this.taskIds.add(tid);
            this.taskAttemptIds.add(taskAttemptId);
        }
        StageConfig taskStageConfig = this.createTaskStageConfig(1, tid, taskAttemptId);
        LOG.info("Generating manifest for {}", (Object)taskAttemptId);
        new SetupTaskStage(taskStageConfig).apply((Object)("task " + taskAttemptId));
        TaskManifest manifest = ManifestCommitterSupport.createTaskManifest((StageConfig)taskStageConfig);
        Path taDir = taskStageConfig.getTaskAttemptDir();
        long size = (long)task * 10000000L;
        for (int i = 0; i < filesPerTaskAttempt; ++i) {
            Path in = new Path(taDir, "dir-" + i);
            Path out = new Path(this.getDestDir(), "dir-" + i);
            manifest.addDirectory(DirEntry.dirEntry((Path)out, (int)0, (int)1));
            String name = taskStageConfig.getTaskAttemptId() + ".csv";
            Path src = new Path(in, name);
            Path dest = new Path(out, name);
            long fileSize = size + (long)i * 1000L;
            manifest.addFileToCommit(new FileEntry(src, dest, fileSize, Long.toString(fileSize, 16)));
            this.totalDataSize.addAndGet(fileSize);
        }
        new SaveTaskManifestStage(taskStageConfig).apply(() -> manifest);
        return manifest;
    }

    public StageConfig createTaskStageConfig(int jobId, String tid, String taskAttemptId) {
        Path jobAttemptTaskSubDir = this.getJobStageConfig().getJobAttemptTaskSubDir();
        StageConfig taskStageConfig = this.createStageConfigForJob(jobId, this.getDestDir()).withTaskId(tid).withTaskAttemptId(taskAttemptId).withTaskAttemptDir(new Path(jobAttemptTaskSubDir, taskAttemptId));
        return taskStageConfig;
    }

    protected void verifyJobDirsCleanedUp() throws IOException {
        StageConfig stageConfig = this.getJobStageConfig();
        this.assertPathDoesNotExist("Job attempt dir", stageConfig.getJobAttemptDir());
        this.assertPathDoesNotExist("dest temp dir", stageConfig.getOutputTempSubDir());
    }

    public static long lsR(FileSystem fileSystem, Path path, boolean recursive) throws Exception {
        if (path == null) {
            LOG.info("Empty path");
            return 0L;
        }
        LOG.info("Listing of {}", (Object)path);
        long count = RemoteIterators.foreach((RemoteIterator)fileSystem.listFiles(path, recursive), status -> LOG.info("{}", status));
        LOG.info("Count of entries: {}", (Object)count);
        return count;
    }

    protected void assertCleanupResult(CleanupJobStage.Result result, CleanupJobStage.Outcome outcome, int expectedDirsDeleted) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)result.getOutcome()).describedAs("Outcome of cleanup() in %s", new Object[]{result})).isEqualTo((Object)outcome);
        if (expectedDirsDeleted >= 0) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)result.getDeleteCalls()).describedAs("Number of directories deleted in cleanup %s", new Object[]{result})).isEqualTo(expectedDirsDeleted);
        }
    }

    protected CleanupJobStage.Result cleanup(boolean enabled, boolean deleteTaskAttemptDirsInParallel, boolean attemptBaseDeleteFirst, boolean suppressExceptions, CleanupJobStage.Outcome outcome, int expectedDirsDeleted) throws IOException {
        StageConfig stageConfig = this.getJobStageConfig();
        CleanupJobStage.Result result = (CleanupJobStage.Result)new CleanupJobStage(stageConfig).apply((Object)new CleanupJobStage.Arguments("job_stage_cleanup", enabled, deleteTaskAttemptDirsInParallel, attemptBaseDeleteFirst, suppressExceptions, 0L));
        this.assertCleanupResult(result, outcome, expectedDirsDeleted);
        return result;
    }

    protected String readText(Path path) throws IOException {
        FileSystem fs = this.getFileSystem();
        FileStatus st = fs.getFileStatus(path);
        ((AbstractLongAssert)Assertions.assertThat((long)st.getLen()).describedAs("length of file %s", new Object[]{st})).isLessThanOrEqualTo(64000L);
        return new String(ContractTestUtils.readDataset((FileSystem)fs, (Path)path, (int)((int)st.getLen())), StandardCharsets.UTF_8);
    }

    protected UnreliableManifestStoreOperations makeStoreOperationsUnreliable() {
        UnreliableManifestStoreOperations failures;
        ManifestStoreOperations wrappedOperations = this.getStoreOperations();
        if (wrappedOperations instanceof UnreliableManifestStoreOperations) {
            failures = (UnreliableManifestStoreOperations)wrappedOperations;
            failures.reset();
        } else {
            failures = new UnreliableManifestStoreOperations(wrappedOperations);
            this.setStoreOperations(failures);
        }
        return failures;
    }

    ProgressCounter progressOf(StageConfig stageConfig) {
        return (ProgressCounter)stageConfig.getProgressable();
    }

    protected static final class ProgressCounter
    implements Progressable {
        private final AtomicLong counter = new AtomicLong();

        protected ProgressCounter() {
        }

        public void progress() {
            this.counter.incrementAndGet();
        }

        public long value() {
            return this.counter.get();
        }

        public void reset() {
            this.counter.set(0L);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ProgressCounter{");
            sb.append("counter=").append(this.counter.get());
            sb.append('}');
            return sb.toString();
        }
    }
}

