/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.BaseLineRecordReaderHelper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public final class LineRecordReaderHelper
extends BaseLineRecordReaderHelper {
    public LineRecordReaderHelper(Path filePath, Configuration conf) {
        super(filePath, conf);
    }

    @Override
    public long countRecords(long start, long length) throws IOException {
        try (LineRecordReader reader = this.newReader(start, length);){
            long numRecords = 0L;
            while (reader.nextKeyValue()) {
                ++numRecords;
            }
            long l = numRecords;
            return l;
        }
    }

    private LineRecordReader newReader(long start, long length) throws IOException {
        FileSplit split = new FileSplit(this.getFilePath(), start, length, null);
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(this.getConf(), new TaskAttemptID());
        LineRecordReader reader = new LineRecordReader(this.getRecordDelimiterBytes());
        try {
            reader.initialize((InputSplit)split, (TaskAttemptContext)context);
            return reader;
        }
        catch (Throwable e) {
            reader.close();
            throw e;
        }
    }
}

