/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public abstract class BaseLineRecordReaderHelper {
    private final Configuration conf;
    private final Path filePath;
    private final byte[] recordDelimiterBytes;

    public BaseLineRecordReaderHelper(Path filePath, Configuration conf) {
        this.conf = conf;
        this.filePath = filePath;
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        String delimiter = conf.get("textinputformat.record.delimiter");
        this.recordDelimiterBytes = null != delimiter ? delimiter.getBytes(StandardCharsets.UTF_8) : null;
    }

    public abstract long countRecords(long var1, long var3) throws IOException;

    public Configuration getConf() {
        return this.conf;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public byte[] getRecordDelimiterBytes() {
        return this.recordDelimiterBytes;
    }
}

