/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.filecache;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.filecache.ClientDistributedCacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClientDistributedCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestClientDistributedCacheManager.class);
    private static final Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestClientDistributedCacheManager.class.getSimpleName());
    private static final Path TEST_VISIBILITY_PARENT_DIR = new Path(TEST_ROOT_DIR, "TestCacheVisibility_Parent");
    private static final Path TEST_VISIBILITY_CHILD_DIR = new Path(TEST_VISIBILITY_PARENT_DIR, "TestCacheVisibility_Child");
    private static final String FIRST_CACHE_FILE = "firstcachefile";
    private static final String SECOND_CACHE_FILE = "secondcachefile";
    private FileSystem fs;
    private Path firstCacheFile;
    private Path secondCacheFile;
    private Configuration conf;

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.firstCacheFile = new Path(TEST_VISIBILITY_PARENT_DIR, FIRST_CACHE_FILE);
        this.secondCacheFile = new Path(TEST_VISIBILITY_CHILD_DIR, SECOND_CACHE_FILE);
        this.createTempFile(this.firstCacheFile, this.conf);
        this.createTempFile(this.secondCacheFile, this.conf);
    }

    @After
    public void tearDown() throws IOException {
        if (this.fs.delete(TEST_ROOT_DIR, true)) {
            LOG.warn("Failed to delete test root dir and its content under " + TEST_ROOT_DIR);
        }
    }

    @Test
    public void testDetermineTimestamps() throws IOException {
        Job job = Job.getInstance((Configuration)this.conf);
        job.addCacheFile(this.firstCacheFile.toUri());
        job.addCacheFile(this.secondCacheFile.toUri());
        Configuration jobConf = job.getConfiguration();
        HashMap statCache = new HashMap();
        ClientDistributedCacheManager.determineTimestamps((Configuration)jobConf, statCache);
        FileStatus firstStatus = (FileStatus)statCache.get(this.firstCacheFile.toUri());
        FileStatus secondStatus = (FileStatus)statCache.get(this.secondCacheFile.toUri());
        Assert.assertNotNull((String)(this.firstCacheFile + " was not found in the stats cache"), (Object)firstStatus);
        Assert.assertNotNull((String)(this.secondCacheFile + " was not found in the stats cache"), (Object)secondStatus);
        Assert.assertEquals((String)"Missing/extra entries found in the stats cache", (long)2L, (long)statCache.size());
        Object expected = firstStatus.getModificationTime() + "," + secondStatus.getModificationTime();
        Assert.assertEquals((Object)expected, (Object)jobConf.get("mapreduce.job.cache.files.timestamps"));
        job = Job.getInstance((Configuration)this.conf);
        job.addCacheFile(new Path(TEST_VISIBILITY_CHILD_DIR, "*").toUri());
        jobConf = job.getConfiguration();
        statCache.clear();
        ClientDistributedCacheManager.determineTimestamps((Configuration)jobConf, statCache);
        FileStatus thirdStatus = (FileStatus)statCache.get(TEST_VISIBILITY_CHILD_DIR.toUri());
        Assert.assertEquals((String)"Missing/extra entries found in the stats cache", (long)1L, (long)statCache.size());
        Assert.assertNotNull((String)(TEST_VISIBILITY_CHILD_DIR + " was not found in the stats cache"), (Object)thirdStatus);
        expected = Long.toString(thirdStatus.getModificationTime());
        Assert.assertEquals((String)("Incorrect timestamp for " + TEST_VISIBILITY_CHILD_DIR), (Object)expected, (Object)jobConf.get("mapreduce.job.cache.files.timestamps"));
    }

    @Test
    public void testDetermineCacheVisibilities() throws IOException {
        this.fs.setPermission(TEST_VISIBILITY_PARENT_DIR, new FsPermission(511));
        this.fs.setPermission(TEST_VISIBILITY_CHILD_DIR, new FsPermission(511));
        this.fs.setWorkingDirectory(TEST_VISIBILITY_CHILD_DIR);
        Job job = Job.getInstance((Configuration)this.conf);
        Path relativePath = new Path(SECOND_CACHE_FILE);
        Path wildcardPath = new Path("*");
        HashMap<URI, FileStatus> statCache = new HashMap<URI, FileStatus>();
        job.addCacheFile(this.firstCacheFile.toUri());
        job.addCacheFile(relativePath.toUri());
        Configuration jobConf = job.getConfiguration();
        Assume.assumeTrue((String)(TEST_VISIBILITY_PARENT_DIR + " is not public"), (boolean)ClientDistributedCacheManager.isPublic((Configuration)jobConf, (URI)TEST_VISIBILITY_PARENT_DIR.toUri(), statCache));
        ClientDistributedCacheManager.determineCacheVisibilities((Configuration)jobConf, statCache);
        Assert.assertEquals((String)"The file paths were not found to be publicly visible even though the full path is publicly accessible", (Object)"true,true", (Object)jobConf.get("mapreduce.job.cache.files.visibilities"));
        this.checkCacheEntries(statCache, null, this.firstCacheFile, relativePath);
        job = Job.getInstance((Configuration)this.conf);
        job.addCacheFile(wildcardPath.toUri());
        jobConf = job.getConfiguration();
        statCache.clear();
        ClientDistributedCacheManager.determineCacheVisibilities((Configuration)jobConf, statCache);
        Assert.assertEquals((String)"The file path was not found to be publicly visible even though the full path is publicly accessible", (Object)"true", (Object)jobConf.get("mapreduce.job.cache.files.visibilities"));
        this.checkCacheEntries(statCache, null, wildcardPath.getParent());
        Path qualifiedParent = this.fs.makeQualified(TEST_VISIBILITY_PARENT_DIR);
        this.fs.setPermission(TEST_VISIBILITY_PARENT_DIR, new FsPermission(448));
        job = Job.getInstance((Configuration)this.conf);
        job.addCacheFile(this.firstCacheFile.toUri());
        job.addCacheFile(relativePath.toUri());
        jobConf = job.getConfiguration();
        statCache.clear();
        ClientDistributedCacheManager.determineCacheVisibilities((Configuration)jobConf, statCache);
        Assert.assertEquals((String)"The file paths were found to be publicly visible even though the parent directory is not publicly accessible", (Object)"false,false", (Object)jobConf.get("mapreduce.job.cache.files.visibilities"));
        this.checkCacheEntries(statCache, qualifiedParent, this.firstCacheFile, relativePath);
        job = Job.getInstance((Configuration)this.conf);
        job.addCacheFile(wildcardPath.toUri());
        jobConf = job.getConfiguration();
        statCache.clear();
        ClientDistributedCacheManager.determineCacheVisibilities((Configuration)jobConf, statCache);
        Assert.assertEquals((String)"The file path was found to be publicly visible even though the parent directory is not publicly accessible", (Object)"false", (Object)jobConf.get("mapreduce.job.cache.files.visibilities"));
        this.checkCacheEntries(statCache, qualifiedParent, wildcardPath.getParent());
    }

    private void checkCacheEntries(Map<URI, FileStatus> statCache, Path top, Path ... paths) {
        HashSet<URI> expected = new HashSet<URI>();
        for (Path path : paths) {
            Path p = this.fs.makeQualified(path);
            while (!p.isRoot() && !p.equals((Object)top)) {
                expected.add(p.toUri());
                p = p.getParent();
            }
            expected.add(p.toUri());
        }
        Set<URI> uris = statCache.keySet();
        HashSet<URI> missing = new HashSet<URI>(uris);
        HashSet extra = new HashSet(expected);
        missing.removeAll(expected);
        extra.removeAll(uris);
        Assert.assertTrue((String)("File status cache does not contain an entries for " + missing), (boolean)missing.isEmpty());
        Assert.assertTrue((String)("File status cache contains extra extries: " + extra), (boolean)extra.isEmpty());
    }

    void createTempFile(Path p, Configuration conf) throws IOException {
        SequenceFile.Writer writer = null;
        try {
            writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)conf, (Path)p, Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
            writer.append((Writable)new Text("text"), (Writable)new Text("moretext"));
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            writer = null;
        }
        LOG.info("created: " + p);
    }
}

