/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestJobMonitorAndPrint {
    private Job job;
    private Configuration conf;
    private ClientProtocol clientProtocol;

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.clientProtocol = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)cluster.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)cluster.getClient()).thenReturn((Object)this.clientProtocol);
        JobStatus jobStatus = new JobStatus(new JobID("job_000", 1), 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.RUNNING, JobPriority.HIGH, "tmp-user", "tmp-jobname", "tmp-jobfile", "tmp-url");
        this.job = Job.getInstance((Cluster)cluster, (JobStatus)jobStatus, (Configuration)this.conf);
        this.job = (Job)Mockito.spy((Object)this.job);
    }

    @Test
    public void testJobMonitorAndPrint() throws Exception {
        String line;
        JobStatus jobStatus_1 = new JobStatus(new JobID("job_000", 1), 1.0f, 0.1f, 0.1f, 0.0f, JobStatus.State.RUNNING, JobPriority.HIGH, "tmp-user", "tmp-jobname", "tmp-queue", "tmp-jobfile", "tmp-url", true);
        JobStatus jobStatus_2 = new JobStatus(new JobID("job_000", 1), 1.0f, 1.0f, 1.0f, 1.0f, JobStatus.State.SUCCEEDED, JobPriority.HIGH, "tmp-user", "tmp-jobname", "tmp-queue", "tmp-jobfile", "tmp-url", true);
        ((Job)Mockito.doAnswer(invocation -> TaskCompletionEvent.EMPTY_ARRAY).when((Object)this.job)).getTaskCompletionEvents(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((Job)Mockito.doReturn((Object)new TaskReport[5]).when((Object)this.job)).getTaskReports((TaskType)ArgumentMatchers.isA(TaskType.class));
        Mockito.when((Object)this.clientProtocol.getJobStatus((JobID)ArgumentMatchers.any(JobID.class))).thenReturn((Object)jobStatus_1, (Object[])new JobStatus[]{jobStatus_2});
        Layout layout = Logger.getRootLogger().getAppender("stdout").getLayout();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender(layout, (OutputStream)os);
        appender.setThreshold((Priority)Level.ALL);
        Logger qlogger = Logger.getLogger(Job.class);
        qlogger.addAppender((Appender)appender);
        this.job.monitorAndPrintJob();
        qlogger.removeAppender((Appender)appender);
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        boolean foundHundred = false;
        boolean foundComplete = false;
        boolean foundUber = false;
        String uberModeMatch = "uber mode : true";
        String progressMatch = "map 100% reduce 100%";
        String completionMatch = "completed successfully";
        while ((line = r.readLine()) != null) {
            if (line.contains(uberModeMatch)) {
                foundUber = true;
            }
            if (!(foundHundred = line.contains(progressMatch))) continue;
        }
        line = r.readLine();
        foundComplete = line.contains(completionMatch);
        Assert.assertTrue((boolean)foundUber);
        Assert.assertTrue((boolean)foundHundred);
        Assert.assertTrue((boolean)foundComplete);
        System.out.println("The output of job.toString() is : \n" + this.job.toString());
        Assert.assertTrue((boolean)this.job.toString().contains("Number of maps: 5\n"));
        Assert.assertTrue((boolean)this.job.toString().contains("Number of reduces: 5\n"));
    }
}

