/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobInfo;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestJobInfo {
    @Test(timeout=5000L)
    public void testJobInfo() throws IOException {
        JobID jid = new JobID("001", 1);
        Text user = new Text("User");
        Path path = new Path("/tmp/test");
        JobInfo info = new JobInfo(jid, user, path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        info.write((DataOutput)new DataOutputStream(out));
        JobInfo copyinfo = new JobInfo();
        copyinfo.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
        Assert.assertEquals((Object)info.getJobID().toString(), (Object)copyinfo.getJobID().toString());
        Assert.assertEquals((Object)info.getJobSubmitDir().getName(), (Object)copyinfo.getJobSubmitDir().getName());
        Assert.assertEquals((Object)info.getUser().toString(), (Object)copyinfo.getUser().toString());
    }

    @Test(timeout=5000L)
    public void testTaskID() throws IOException, InterruptedException {
        JobID jobid = new JobID("1014873536921", 6);
        TaskID tid = new TaskID(jobid, TaskType.MAP, 0);
        org.apache.hadoop.mapred.TaskID tid1 = org.apache.hadoop.mapred.TaskID.downgrade((TaskID)tid);
        TaskReport treport = new TaskReport(tid1, 0.0f, JobStatus.State.FAILED.toString(), null, TIPStatus.FAILED, 100L, 100L, new Counters());
        Assertions.assertThat((String)treport.getTaskId()).isEqualTo((Object)"task_1014873536921_0006_m_000000");
        Assertions.assertThat((String)treport.getTaskID().toString()).isEqualTo((Object)"task_1014873536921_0006_m_000000");
    }
}

