/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapreduce.lib.input.BaseLineRecordReaderHelper;

public final class LineRecordReaderHelper
extends BaseLineRecordReaderHelper {
    public LineRecordReaderHelper(Path filePath, Configuration conf) {
        super(filePath, conf);
    }

    @Override
    public long countRecords(long start, long length) throws IOException {
        try (LineRecordReader reader = this.newReader(start, length);){
            LongWritable key = new LongWritable();
            Text value = new Text();
            long numRecords = 0L;
            while (reader.next(key, value)) {
                ++numRecords;
            }
            long l = numRecords;
            return l;
        }
    }

    private LineRecordReader newReader(long start, long length) throws IOException {
        FileSplit split = new FileSplit(this.getFilePath(), start, length, (String[])null);
        return new LineRecordReader(this.getConf(), split, this.getRecordDelimiterBytes());
    }
}

