/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextOutputForTests<K, V>
extends TextOutputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(TextOutputForTests.class);
    public static final String NAME = "org.apache.hadoop.fs.s3a.commit.LoggingTextOutputFormat";

    public LoggingLineRecordWriter<K, V> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        boolean isCompressed = TextOutputForTests.getCompressOutput((JobContext)job);
        String keyValueSeparator = conf.get(SEPARATOR, "\t");
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = TextOutputForTests.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(job, extension);
        FileSystem fs = file.getFileSystem(conf);
        FSDataOutputStream fileOut = fs.create(file, true);
        LOG.debug("Creating LineRecordWriter with destination {}", (Object)file);
        if (isCompressed) {
            return new LoggingLineRecordWriter(file, new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut)), keyValueSeparator);
        }
        return new LoggingLineRecordWriter(file, (DataOutputStream)fileOut, keyValueSeparator);
    }

    public static void bind(Configuration conf) {
        conf.setClass("mapreduce.job.outputformat.class", TextOutputForTests.class, OutputFormat.class);
    }

    public static class LoggingLineRecordWriter<K, V>
    extends TextOutputFormat.LineRecordWriter<K, V> {
        private final Path dest;
        private long lines;

        public LoggingLineRecordWriter(Path dest, DataOutputStream out, String keyValueSeparator) {
            super(out, keyValueSeparator);
            this.dest = dest;
        }

        public LoggingLineRecordWriter(DataOutputStream out, Path dest) {
            super(out);
            this.dest = dest;
        }

        public synchronized void write(K key, V value) throws IOException {
            super.write(key, value);
            ++this.lines;
        }

        public synchronized void close(TaskAttemptContext context) throws IOException {
            LOG.debug("Closing output file {} with {} lines :{}", new Object[]{this.dest, this.lines, this.out});
            this.out.close();
        }

        public Path getDest() {
            return this.dest;
        }

        public long getLines() {
            return this.lines;
        }
    }
}

