/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.FileNotFoundException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.AbstractManifestCommitterTest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.UnreliableManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CommitJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CommitTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;

public class TestCommitTaskStage
extends AbstractManifestCommitterTest {
    public static final String TASK1 = String.format("task_%03d", 1);
    public static final String TASK1_ATTEMPT1 = String.format("%s_%02d", TASK1, 1);

    @Override
    public void setup() throws Exception {
        super.setup();
        Path destDir = this.methodPath();
        StageConfig stageConfig = this.createStageConfigForJob(1, destDir);
        this.setJobStageConfig(stageConfig);
        new SetupJobStage(stageConfig).apply((Object)true);
    }

    private StageConfig createStageConfig() {
        return this.createTaskStageConfig(1, TASK1, TASK1_ATTEMPT1);
    }

    @Test
    public void testCommitMissingDirectory() throws Throwable {
        String tid = String.format("task_%03d", 1);
        String taskAttemptId = String.format("%s_%02d", tid, 1);
        StageConfig taskStageConfig = this.createTaskStageConfig(1, tid, taskAttemptId);
        Path taDir = taskStageConfig.getTaskAttemptDir();
        this.assertPathDoesNotExist("task attempt path", taDir);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (CommitTaskStage.Result)new CommitTaskStage(taskStageConfig).apply(null));
    }

    @Test
    public void testCommitEmptyDirectory() throws Throwable {
        this.describe("Commit an empty directory as task then job");
        String tid = String.format("task_%03d", 2);
        String taskAttemptId = String.format("%s_%02d", tid, 1);
        StageConfig taskStageConfig = this.createTaskStageConfig(1, tid, taskAttemptId);
        new SetupTaskStage(taskStageConfig).apply((Object)"setup");
        CommitTaskStage.Result result = (CommitTaskStage.Result)new CommitTaskStage(taskStageConfig).apply(null);
        TaskManifest manifest = result.getTaskManifest();
        ((ListAssert)Assertions.assertThat((List)manifest.getDestDirectories()).as("directories to create", new Object[0])).isEmpty();
        ((ListAssert)Assertions.assertThat((List)manifest.getFilesToCommit()).as("files to commit", new Object[0])).isEmpty();
        Path path = result.getPath();
        String manifestBody = this.readText(path);
        LOG.info("manifest at {} of length {}:\n{}", new Object[]{path, manifestBody.length(), manifestBody});
        CommitJobStage.Result outcome = (CommitJobStage.Result)new CommitJobStage(this.getJobStageConfig()).apply((Object)new CommitJobStage.Arguments(true, true, null, new CleanupJobStage.Arguments("job_stage_cleanup", true, true, false, false, 0L)));
        Path successPath = outcome.getSuccessPath();
        String successBody = this.readText(successPath);
        LOG.info("successBody at {} of length {}:\n{}", new Object[]{successPath, successBody.length(), successBody});
        ManifestSuccessData successData = outcome.getJobSuccessData();
        ((ListAssert)Assertions.assertThat((List)successData.getFilenames()).as("Filenames in _SUCCESS", new Object[0])).isEmpty();
    }

    @Test
    public void testManifestSaveFailures() throws Throwable {
        this.describe("Test recovery of manifest save/rename failures");
        UnreliableManifestStoreOperations failures = this.makeStoreOperationsUnreliable();
        StageConfig stageConfig = this.createStageConfig();
        new SetupTaskStage(stageConfig).apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestFile = ManifestCommitterSupport.manifestPathForTask((Path)manifestDir, (String)stageConfig.getTaskId());
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        failures.addSaveToFail(manifestTempFile);
        failures.setFailureLimit(5);
        LambdaTestUtils.intercept(PathIOException.class, (String)UnreliableManifestStoreOperations.generatedErrorMessage("save"), () -> (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null));
        failures.setFailureLimit(3);
        new CommitTaskStage(stageConfig).apply(null);
        this.describe("Testing timeouts on rename operations.");
        failures.reset();
        failures.addTimeoutBeforeRename(manifestTempFile);
        failures.setFailureLimit(5);
        LambdaTestUtils.intercept(SocketTimeoutException.class, (String)"Operation could not be completed within the specified time", () -> (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null));
        failures.setFailureLimit(3);
        new CommitTaskStage(stageConfig).apply(null);
    }

    @Test
    public void testManifestRenameEarlyTimeouts() throws Throwable {
        this.describe("Testing timeouts on rename operations.");
        UnreliableManifestStoreOperations failures = this.makeStoreOperationsUnreliable();
        StageConfig stageConfig = this.createStageConfig();
        new SetupTaskStage(stageConfig).apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestFile = ManifestCommitterSupport.manifestPathForTask((Path)manifestDir, (String)stageConfig.getTaskId());
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        failures.addTimeoutBeforeRename(manifestTempFile);
        failures.setFailureLimit(5);
        LambdaTestUtils.intercept(SocketTimeoutException.class, (String)"Operation could not be completed within the specified time", () -> (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null));
        IOStatisticsStore iostats = stageConfig.getIOStatistics();
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)iostats, (String)"task_stage_save_task_manifest.failures").isEqualTo(4L);
        iostats.reset();
        failures.setFailureLimit(4);
        CommitTaskStage.Result r = (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null);
        TaskManifest loadedManifest = TaskManifest.load((FileSystem)this.getFileSystem(), (Path)r.getPath());
        IOStatisticsSnapshot loadedIOStats = loadedManifest.getIOStatistics();
        LOG.info("Statistics of file successfully saved:\nD {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)loadedIOStats));
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)loadedIOStats, (String)"task_stage_save_task_manifest.failures").isEqualTo(3L);
    }

    @Test
    public void testManifestRenameLateTimeoutsFailure() throws Throwable {
        this.describe("Testing timeouts on rename operations.");
        UnreliableManifestStoreOperations failures = this.makeStoreOperationsUnreliable();
        StageConfig stageConfig = this.createStageConfig();
        new SetupTaskStage(stageConfig).apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        failures.addTimeoutAfterRename(manifestTempFile);
        failures.setFailureLimit(5);
        LambdaTestUtils.intercept(SocketTimeoutException.class, (String)"Operation could not be completed within the specified time", () -> (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null));
    }

    @Test
    public void testManifestRenameLateTimeoutsRecovery() throws Throwable {
        this.describe("Testing recovery from late timeouts on rename operations.");
        UnreliableManifestStoreOperations failures = this.makeStoreOperationsUnreliable();
        StageConfig stageConfig = this.createStageConfig();
        new SetupTaskStage(stageConfig).apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        failures.addTimeoutAfterRename(manifestTempFile);
        failures.setFailureLimit(4);
        stageConfig.getIOStatistics().reset();
        new CommitTaskStage(stageConfig).apply(null);
        CommitTaskStage.Result r = (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null);
        TaskManifest loadedManifest = TaskManifest.load((FileSystem)this.getFileSystem(), (Path)r.getPath());
        IOStatisticsSnapshot loadedIOStats = loadedManifest.getIOStatistics();
        LOG.info("Statistics of file successfully saved:\n{}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)loadedIOStats));
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)loadedIOStats, (String)"task_stage_save_task_manifest.failures").isEqualTo(3L);
    }

    @Test
    public void testFailureToDeleteManifestPath() throws Throwable {
        this.describe("Testing failure in the delete call made before renaming the manifest");
        UnreliableManifestStoreOperations failures = this.makeStoreOperationsUnreliable();
        StageConfig stageConfig = this.createStageConfig();
        new SetupTaskStage(stageConfig).apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestFile = ManifestCommitterSupport.manifestPathForTask((Path)manifestDir, (String)stageConfig.getTaskId());
        ContractTestUtils.touch((FileSystem)this.getFileSystem(), (Path)manifestFile);
        failures.addDeletePathToFail(manifestFile);
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        failures.setFailureLimit(5);
        LambdaTestUtils.intercept(PathIOException.class, () -> (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null));
        failures.setFailureLimit(3);
        new CommitTaskStage(stageConfig).apply(null);
    }

    @Test
    public void testFailureOfDeleteBeforeSavingTemporaryFile() throws Throwable {
        this.describe("Testing failure in the delete call made before rename");
        UnreliableManifestStoreOperations failures = this.makeStoreOperationsUnreliable();
        StageConfig stageConfig = this.createStageConfig();
        new SetupTaskStage(stageConfig).apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        failures.addDeletePathToFail(manifestTempFile);
        failures.setFailureLimit(5);
        LambdaTestUtils.intercept(PathIOException.class, () -> (CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null));
        failures.setFailureLimit(3);
        new CommitTaskStage(stageConfig).apply(null);
    }

    @Test
    public void testRenameTargetIsDir() throws Throwable {
        this.describe("Rename target is a directory");
        ManifestStoreOperations operations = this.getStoreOperations();
        StageConfig stageConfig = this.createStageConfig();
        SetupTaskStage setup = new SetupTaskStage(stageConfig);
        setup.apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestFile = ManifestCommitterSupport.manifestPathForTask((Path)manifestDir, (String)stageConfig.getTaskId());
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        setup.mkdirs(manifestFile, true);
        ContractTestUtils.assertIsDirectory((FileSystem)this.getFileSystem(), (Path)manifestFile);
        new CommitTaskStage(stageConfig).apply(null);
        FileStatus st = operations.getFileStatus(manifestFile);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)st).describedAs("File status of %s", new Object[]{manifestFile})).matches(FileStatus::isFile, "is a file");
        TaskManifest manifest = setup.loadManifest(st);
        ((ObjectAssert)Assertions.assertThat((Object)manifest).matches(m -> m.getTaskID().equals(TASK1))).matches(m -> m.getTaskAttemptID().equals(TASK1_ATTEMPT1));
    }

    @Test
    public void testManifestTempFileIsDir() throws Throwable {
        this.describe("Manifest temp file path is a directory");
        ManifestStoreOperations operations = this.getStoreOperations();
        StageConfig stageConfig = this.createStageConfig();
        SetupTaskStage setup = new SetupTaskStage(stageConfig);
        setup.apply((Object)"setup");
        Path manifestDir = stageConfig.getTaskManifestDir();
        Path manifestFile = ManifestCommitterSupport.manifestPathForTask((Path)manifestDir, (String)stageConfig.getTaskId());
        Path manifestTempFile = ManifestCommitterSupport.manifestTempPathForTaskAttempt((Path)manifestDir, (String)stageConfig.getTaskAttemptId());
        setup.mkdirs(manifestTempFile, true);
        new CommitTaskStage(stageConfig).apply(null);
        TaskManifest manifest = setup.loadManifest(operations.getFileStatus(manifestFile));
        ((ObjectAssert)Assertions.assertThat((Object)manifest).matches(m -> m.getTaskID().equals(TASK1))).matches(m -> m.getTaskAttemptID().equals(TASK1_ATTEMPT1));
    }
}

