/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConstants;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.DirEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestPrinter;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.EntryFileIO;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.LoadedManifestData;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestCommitterTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestCommitterTestSupport.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final String PROJECT_BUILD_DIRECTORY_PROPERTY = "project.build.directory";
    public static final int NUMBER_OF_TASK_ATTEMPTS = 2000;
    public static final int NUMBER_OF_TASK_ATTEMPTS_SMALL = 200;
    public static final String ATTEMPT_STRING = "attempt_%s_m_%06d_%d";

    private ManifestCommitterTestSupport() {
    }

    public static String randomJobId() {
        int digitValue;
        String testUniqueForkId = System.getProperty("test.unique.fork.id", "0001");
        int l = testUniqueForkId.length();
        String trailingDigits = testUniqueForkId.substring(l - 4, l);
        try {
            digitValue = Integer.valueOf(trailingDigits);
        }
        catch (NumberFormatException e) {
            digitValue = 0;
        }
        return String.format("%s%04d_%04d", FORMATTER.format(LocalDateTime.now()), (long)(Math.random() * 1000.0), digitValue);
    }

    public static File getProjectBuildDir() {
        String propval = System.getProperty(PROJECT_BUILD_DIRECTORY_PROPERTY);
        if (StringUtils.isEmpty((CharSequence)propval)) {
            propval = "target";
        }
        return new File(propval).getAbsoluteFile();
    }

    public static ManifestSuccessData loadSuccessFile(FileSystem fs, Path outputPath) throws IOException {
        Path success = new Path(outputPath, "_SUCCESS");
        return ManifestSuccessData.load((FileSystem)fs, (Path)success);
    }

    public static ManifestSuccessData validateSuccessFile(FileSystem fs, Path outputDir, int minimumFileCount, String jobId) throws IOException {
        Path successPath = new Path(outputDir, "_SUCCESS");
        ManifestSuccessData successData = ManifestCommitterTestSupport.loadAndPrintSuccessData(fs, successPath);
        ((AbstractStringAssert)Assertions.assertThat((String)successData.getCommitter()).describedAs("Committer field", new Object[0])).isEqualTo((Object)ManifestCommitterConstants.MANIFEST_COMMITTER_CLASSNAME);
        ((ListAssert)Assertions.assertThat((List)successData.getFilenames()).describedAs("Files committed", new Object[0])).hasSizeGreaterThanOrEqualTo(minimumFileCount);
        if (StringUtils.isNotEmpty((CharSequence)jobId)) {
            ((AbstractStringAssert)Assertions.assertThat((String)successData.getJobId()).describedAs("JobID", new Object[0])).isEqualTo((Object)jobId);
        }
        return successData;
    }

    public static ManifestSuccessData loadAndPrintSuccessData(FileSystem fs, Path successPath) throws IOException {
        LOG.info("Manifest {}", (Object)successPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ManifestPrinter showManifest = new ManifestPrinter(fs.getConf(), ps);
        ManifestSuccessData successData = showManifest.loadAndPrintManifest(fs, successPath);
        LOG.info("{}", (Object)baos);
        return successData;
    }

    public static Map<Path, LocatedFileStatus> validateGeneratedFiles(FileSystem fs, Path destDir, ManifestSuccessData successData, boolean exclusive) throws IOException {
        HashMap<Path, LocatedFileStatus> fileListing = new HashMap<Path, LocatedFileStatus>();
        RemoteIterators.foreach((RemoteIterator)fs.listFiles(destDir, true), e -> {
            if (!e.getPath().getName().startsWith("_")) {
                fileListing.put(e.getPath(), (LocatedFileStatus)e);
            }
        });
        List actual = fileListing.keySet().stream().sorted(Comparator.comparing(Path::getName)).collect(Collectors.toList());
        List<Path> expected = ManifestCommitterTestSupport.filesInManifest(successData);
        expected.sort(Comparator.comparing(Path::getName));
        ((ListAssert)Assertions.assertThat(actual).describedAs("Files in FS expected to contain all listed in manifest", new Object[0])).containsAll(expected);
        if (exclusive) {
            ((ListAssert)((ListAssert)Assertions.assertThat(actual).describedAs("Files in FS expected to be exclusively of the job", new Object[0])).hasSize(expected.size())).containsExactlyInAnyOrderElementsOf(expected);
        }
        return fileListing;
    }

    public static List<Path> filesInManifest(ManifestSuccessData successData) {
        return successData.getFilenames().stream().map(AbstractManifestData::unmarshallPath).collect(Collectors.toList());
    }

    public static long lsR(FileSystem fileSystem, Path path, boolean recursive) throws Exception {
        if (path == null) {
            LOG.info("Empty path");
            return 0L;
        }
        return RemoteIterators.foreach((RemoteIterator)fileSystem.listFiles(path, recursive), status -> LOG.info("{}", status));
    }

    static void assertFileEntryMatch(FileEntry fileOrDir, Path src, Path dest, long l) {
        String entry = fileOrDir.toString();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)fileOrDir.getSourcePath()).describedAs("Source path of " + entry, new Object[0])).isEqualTo((Object)src);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)fileOrDir.getDestPath()).describedAs("Dest path of " + entry, new Object[0])).isEqualTo((Object)dest);
        ((AbstractLongAssert)Assertions.assertThat((long)fileOrDir.getSize()).describedAs("Size of " + entry, new Object[0])).isEqualTo(l);
    }

    static void assertDirEntryMatch(DirEntry fileOrDir, Path dest, long type) {
        String entry = fileOrDir.toString();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)fileOrDir.getDestPath()).describedAs("Dest path of " + entry, new Object[0])).isEqualTo((Object)dest);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fileOrDir.getType()).describedAs("type of " + entry, new Object[0])).isEqualTo(type);
    }

    public static void assertNoFailureStatistics(IOStatistics iostats, String ... names) {
        Map counters = iostats.counters();
        for (String name : names) {
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)counters.get(name + ".failures"))).describedAs("Failure count of %s", new Object[]{name})).matches(f -> f == null || f == 0L);
        }
    }

    public static LoadedManifestData saveManifest(EntryFileIO entryFileIO, TaskManifest manifest) throws IOException {
        File tempFile = File.createTempFile("entries", ".seq");
        SequenceFile.Writer writer = entryFileIO.createWriter(tempFile);
        return new LoadedManifestData((Collection)manifest.getDestDirectories(), EntryFileIO.toPath((File)tempFile), EntryFileIO.write((SequenceFile.Writer)writer, (Collection)manifest.getFilesToCommit(), (boolean)true));
    }

    public static final class JobAndTaskIDsForTests {
        private final String jobId;
        private final String[][] taskAttempts;

        public JobAndTaskIDsForTests(int tasks, int attempts) {
            this(ManifestCommitterTestSupport.randomJobId(), tasks, attempts);
        }

        public JobAndTaskIDsForTests(String jobId, int tasks, int attempts) {
            this.jobId = jobId;
            this.taskAttempts = new String[tasks][attempts];
            for (int i = 0; i < tasks; ++i) {
                for (int j = 0; j < attempts; ++j) {
                    String a;
                    this.taskAttempts[i][j] = a = String.format(ManifestCommitterTestSupport.ATTEMPT_STRING, jobId, i, j);
                }
            }
        }

        public String getJobId() {
            return this.jobId;
        }

        public JobID getJobIdType() {
            return this.getTaskIdType(0).getJobID();
        }

        public String getTaskAttempt(int task, int attempt) {
            return this.taskAttempts[task][attempt];
        }

        public TaskAttemptID getTaskAttemptIdType(int task, int attempt) {
            return TaskAttemptID.forName((String)this.getTaskAttempt(task, attempt));
        }

        public TaskID getTaskIdType(int task) {
            return TaskAttemptID.forName((String)this.getTaskAttempt(task, 0)).getTaskID();
        }

        public String getTaskId(int task) {
            return this.getTaskIdType(task).toString();
        }
    }

    public static final class CloseWriter<K, V>
    implements AutoCloseable {
        private final RecordWriter<K, V> writer;
        private final TaskAttemptContext context;

        public CloseWriter(RecordWriter<K, V> writer, TaskAttemptContext context) {
            this.writer = writer;
            this.context = context;
        }

        @Override
        public void close() {
            try {
                this.writer.close(this.context);
            }
            catch (IOException | InterruptedException e) {
                LOG.error("When closing {} on context {}", new Object[]{this.writer, this.context, e});
            }
        }
    }
}

