/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestLineRecordReader {
    private static Path workDir = new Path(new Path(System.getProperty("test.build.data", "target"), "data"), "TestTextInputFormat");
    private static Path inputDir = new Path(workDir, "input");

    private void testSplitRecords(String testFileName, long firstSplitLength) throws IOException {
        URL testFileUrl = this.getClass().getClassLoader().getResource(testFileName);
        Assert.assertNotNull((String)("Cannot find " + testFileName), (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        long testFileSize = testFile.length();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        Configuration conf = new Configuration();
        this.testSplitRecordsForFile(conf, firstSplitLength, testFileSize, testFilePath);
    }

    private void testSplitRecordsForFile(Configuration conf, long firstSplitLength, long testFileSize, Path testFilePath) throws IOException {
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        Assert.assertTrue((String)("unexpected test data at " + testFilePath), (testFileSize > firstSplitLength ? 1 : 0) != 0);
        String delimiter = conf.get("textinputformat.record.delimiter");
        byte[] recordDelimiterBytes = null;
        if (null != delimiter) {
            recordDelimiterBytes = delimiter.getBytes(StandardCharsets.UTF_8);
        }
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(recordDelimiterBytes);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        int numRecordsNoSplits = 0;
        while (reader.nextKeyValue()) {
            ++numRecordsNoSplits;
        }
        reader.close();
        split = new FileSplit(testFilePath, 0L, firstSplitLength, (String[])null);
        reader = new LineRecordReader(recordDelimiterBytes);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        int numRecordsFirstSplit = 0;
        while (reader.nextKeyValue()) {
            ++numRecordsFirstSplit;
        }
        reader.close();
        split = new FileSplit(testFilePath, firstSplitLength, testFileSize - firstSplitLength, (String[])null);
        reader = new LineRecordReader(recordDelimiterBytes);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        int numRecordsRemainingSplits = 0;
        while (reader.nextKeyValue()) {
            ++numRecordsRemainingSplits;
        }
        reader.close();
        Assert.assertEquals((String)"Unexpected number of records in split ", (long)numRecordsNoSplits, (long)(numRecordsFirstSplit + numRecordsRemainingSplits));
    }

    @Test
    public void testBzip2SplitEndsAtCR() throws IOException {
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136498L);
    }

    @Test
    public void testBzip2SplitEndsAtCRThenLF() throws IOException {
        this.testSplitRecords("blockEndingInCRThenLF.txt.bz2", 136498L);
    }

    @Test(expected=IOException.class)
    public void testSafeguardSplittingUnsplittableFiles() throws IOException {
        this.testSplitRecords("TestSafeguardSplittingUnsplittableFiles.txt.gz", 2L);
    }

    public ArrayList<String> readRecords(URL testFileUrl, int splitSize) throws IOException {
        File testFile = new File(testFileUrl.getFile());
        long testFileSize = testFile.length();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 1);
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
        ArrayList<String> records = new ArrayList<String>();
        for (long offset = 0L; offset < testFileSize; offset += (long)splitSize) {
            FileSplit split = new FileSplit(testFilePath, offset, (long)splitSize, null);
            LineRecordReader reader = new LineRecordReader();
            reader.initialize((InputSplit)split, (TaskAttemptContext)context);
            while (reader.nextKeyValue()) {
                records.add(reader.getCurrentValue().toString());
            }
        }
        return records;
    }

    public String[] readRecordsDirectly(URL testFileUrl, boolean bzip) throws IOException {
        int count;
        int MAX_DATA_SIZE = 0x100000;
        byte[] data = new byte[MAX_DATA_SIZE];
        FileInputStream fis = new FileInputStream(testFileUrl.getFile());
        if (bzip) {
            BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream((InputStream)fis);
            count = bzIn.read(data);
            bzIn.close();
        } else {
            count = fis.read(data);
        }
        fis.close();
        Assert.assertTrue((String)"Test file data too big for buffer", (count < data.length ? 1 : 0) != 0);
        return new String(data, 0, count, StandardCharsets.UTF_8).split("\n");
    }

    public void checkRecordSpanningMultipleSplits(String testFile, int splitSize, boolean bzip) throws IOException {
        URL testFileUrl = this.getClass().getClassLoader().getResource(testFile);
        ArrayList<String> records = this.readRecords(testFileUrl, splitSize);
        String[] actuals = this.readRecordsDirectly(testFileUrl, bzip);
        Assert.assertEquals((String)"Wrong number of records", (long)actuals.length, (long)records.size());
        boolean hasLargeRecord = false;
        for (int i = 0; i < actuals.length; ++i) {
            Assert.assertEquals((Object)actuals[i], (Object)records.get(i));
            if (actuals[i].length() <= 2 * splitSize) continue;
            hasLargeRecord = true;
        }
        Assert.assertTrue((String)"Invalid test data. Doesn't have a large enough record", (boolean)hasLargeRecord);
    }

    @Test
    public void testRecordSpanningMultipleSplits() throws IOException {
        this.checkRecordSpanningMultipleSplits("recordSpanningMultipleSplits.txt", 10, false);
    }

    @Test
    public void testRecordSpanningMultipleSplitsCompressed() throws IOException {
        this.checkRecordSpanningMultipleSplits("recordSpanningMultipleSplits.txt.bz2", 200000, true);
    }

    @Test
    public void testStripBOM() throws IOException {
        String UTF8_BOM = "\ufeff";
        URL testFileUrl = this.getClass().getClassLoader().getResource("testBOM.txt");
        Assert.assertNotNull((String)"Cannot find testBOM.txt", (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        Path testFilePath = new Path(testFile.getAbsolutePath());
        long testFileSize = testFile.length();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader();
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        int numRecords = 0;
        boolean firstLine = true;
        boolean skipBOM = true;
        while (reader.nextKeyValue()) {
            if (firstLine) {
                firstLine = false;
                if (reader.getCurrentValue().toString().startsWith(UTF8_BOM)) {
                    skipBOM = false;
                }
            }
            ++numRecords;
        }
        reader.close();
        Assert.assertTrue((String)"BOM is not skipped", (boolean)skipBOM);
    }

    @Test
    public void testMultipleClose() throws IOException {
        URL testFileUrl = this.getClass().getClassLoader().getResource("recordSpanningMultipleSplits.txt.bz2");
        Assert.assertNotNull((String)"Cannot find recordSpanningMultipleSplits.txt.bz2", (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        Path testFilePath = new Path(testFile.getAbsolutePath());
        long testFileSize = testFile.length();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, null);
        LineRecordReader reader = new LineRecordReader();
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        while (reader.nextKeyValue()) {
        }
        reader.close();
        reader.close();
        BZip2Codec codec = new BZip2Codec();
        codec.setConf(conf);
        HashSet<Decompressor> decompressors = new HashSet<Decompressor>();
        for (int i = 0; i < 10; ++i) {
            decompressors.add(CodecPool.getDecompressor((CompressionCodec)codec));
        }
        Assert.assertEquals((long)10L, (long)decompressors.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path createInputFile(Configuration conf, String data) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path file = new Path(inputDir, "test.txt");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
            writer.write(data);
        }
        return file;
    }

    @Test
    public void testUncompressedInput() throws Exception {
        int splitSize;
        int bufferSize;
        Configuration conf = new Configuration();
        String inputData = "abc+def+ghi+jkl+mno+pqr+stu+vw +xyz";
        Path inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc|+|def|+|ghi|+|jkl|+|mno|+|pqr|+|stu|+|vw |+|xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "|+|");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc+def++ghi+jkl++mno+pqr++stu+vw ++xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc|+||+|defghi|+|jkl|+||+|mno|+|pqr|+||+|stu|+|vw |+||+|xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "|+|");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc+def+-ghi+jkl+-mno+pqr+-stu+vw +-xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+-");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc\n+def\n+ghi\n+jkl\n+mno";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "\n+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc\ndef+\nghi+\njkl\nmno";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+\n");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
    }

    @Test
    public void testUncompressedInputContainingCRLF() throws Exception {
        Configuration conf = new Configuration();
        String inputData = "a\r\nb\rc\nd\r\n";
        Path inputFile = this.createInputFile(conf, inputData);
        for (int bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (int splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
    }

    @Test
    public void testUncompressedInputCustomDelimiterPosValue() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 10);
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        String inputData = "abcdefghij++kl++mno";
        Path inputFile = this.createInputFile(conf, inputData);
        String delimiter = "++";
        byte[] recordDelimiterBytes = delimiter.getBytes(StandardCharsets.UTF_8);
        int splitLength = 15;
        FileSplit split = new FileSplit(inputFile, 0L, (long)splitLength, (String[])null);
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
        LineRecordReader reader = new LineRecordReader(recordDelimiterBytes);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.nextKeyValue());
        LongWritable key = reader.getCurrentKey();
        Text value = reader.getCurrentValue();
        Assert.assertEquals((String)"Wrong length for record value", (long)10L, (long)value.getLength());
        Assert.assertEquals((String)"Wrong position after record read", (long)0L, (long)key.get());
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.nextKeyValue());
        Assert.assertEquals((String)"Wrong length for record value", (long)2L, (long)value.getLength());
        Assert.assertEquals((String)"Wrong position after record read", (long)12L, (long)key.get());
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.nextKeyValue());
        Assert.assertEquals((String)"Wrong length for record value", (long)3L, (long)value.getLength());
        Assert.assertEquals((String)"Wrong position after record read", (long)16L, (long)key.get());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)key.get());
        key = reader.getCurrentKey();
        Assert.assertNull((String)"Unexpected key returned", (Object)key);
        reader.close();
        split = new FileSplit(inputFile, (long)splitLength, (long)(inputData.length() - splitLength), (String[])null);
        reader = new LineRecordReader(recordDelimiterBytes);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertFalse((String)"Unexpected record returned", (boolean)reader.nextKeyValue());
        key = reader.getCurrentKey();
        Assert.assertNull((String)"Unexpected key returned", (Object)key);
        reader.close();
        inputData = "abcd+efgh++ijk++mno";
        inputFile = this.createInputFile(conf, inputData);
        splitLength = 5;
        split = new FileSplit(inputFile, 0L, (long)splitLength, (String[])null);
        reader = new LineRecordReader(recordDelimiterBytes);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.nextKeyValue());
        key = reader.getCurrentKey();
        value = reader.getCurrentValue();
        Assert.assertEquals((String)"Wrong position after record read", (long)0L, (long)key.get());
        Assert.assertEquals((String)"Wrong length for record value", (long)9L, (long)value.getLength());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        Assert.assertEquals((String)"Wrong position after record read", (long)11L, (long)key.get());
        key = reader.getCurrentKey();
        Assert.assertNull((String)"Unexpected key returned", (Object)key);
        reader.close();
        split = new FileSplit(inputFile, (long)splitLength, (long)(inputData.length() - splitLength), (String[])null);
        reader = new LineRecordReader(recordDelimiterBytes);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.nextKeyValue());
        key = reader.getCurrentKey();
        value = reader.getCurrentValue();
        Assert.assertEquals((String)"Wrong position after record read", (long)11L, (long)key.get());
        Assert.assertEquals((String)"Wrong length for record value", (long)3L, (long)value.getLength());
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.nextKeyValue());
        Assert.assertEquals((String)"Wrong position after record read", (long)16L, (long)key.get());
        Assert.assertEquals((String)"Wrong length for record value", (long)3L, (long)value.getLength());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)key.get());
        reader.close();
        inputData = "abcd|efgh|+|ij|kl|+|mno|pqr";
        inputFile = this.createInputFile(conf, inputData);
        delimiter = "|+|";
        recordDelimiterBytes = delimiter.getBytes(StandardCharsets.UTF_8);
        for (int bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (int splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                int keyPosition = 0;
                conf.setInt("io.file.buffer.size", bufferSize);
                split = new FileSplit(inputFile, 0L, (long)bufferSize, (String[])null);
                reader = new LineRecordReader(recordDelimiterBytes);
                reader.initialize((InputSplit)split, (TaskAttemptContext)context);
                Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.nextKeyValue());
                key = reader.getCurrentKey();
                value = reader.getCurrentValue();
                Assert.assertTrue((boolean)"abcd|efgh".equals(value.toString()));
                Assert.assertEquals((String)"Wrong position after record read", (long)keyPosition, (long)key.get());
                keyPosition = 12;
                if (reader.nextKeyValue()) {
                    Assert.assertTrue((boolean)"ij|kl".equals(value.toString()));
                    Assert.assertEquals((String)"Wrong position after record read", (long)keyPosition, (long)key.get());
                    keyPosition = 20;
                }
                if (reader.nextKeyValue()) {
                    Assert.assertTrue((boolean)"mno|pqr".equals(value.toString()));
                    Assert.assertEquals((String)"Wrong position after record read", (long)keyPosition, (long)key.get());
                    keyPosition = inputData.length();
                }
                Assert.assertFalse((String)"Unexpected record returned", (boolean)reader.nextKeyValue());
                Assert.assertEquals((String)"Wrong position after record read", (long)keyPosition, (long)key.get());
                key = reader.getCurrentKey();
                Assert.assertNull((String)"Unexpected key returned", (Object)key);
                reader.close();
            }
        }
    }

    @Test
    public void testUncompressedInputDefaultDelimiterPosValue() throws Exception {
        Configuration conf = new Configuration();
        String inputData = "1234567890\r\n12\r\n345";
        Path inputFile = this.createInputFile(conf, inputData);
        conf.setInt("io.file.buffer.size", 10);
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        FileSplit split = new FileSplit(inputFile, 0L, 15L, (String[])null);
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
        LineRecordReader reader = new LineRecordReader(null);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        reader.nextKeyValue();
        LongWritable key = reader.getCurrentKey();
        Text value = reader.getCurrentValue();
        Assert.assertEquals((long)10L, (long)value.getLength());
        Assert.assertEquals((long)0L, (long)key.get());
        reader.nextKeyValue();
        Assert.assertEquals((long)2L, (long)value.getLength());
        Assert.assertEquals((long)12L, (long)key.get());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        Assert.assertEquals((long)16L, (long)key.get());
        split = new FileSplit(inputFile, 15L, 4L, (String[])null);
        reader = new LineRecordReader(null);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        reader.nextKeyValue();
        key = reader.getCurrentKey();
        value = reader.getCurrentValue();
        Assert.assertEquals((long)3L, (long)value.getLength());
        Assert.assertEquals((long)16L, (long)key.get());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        Assert.assertEquals((long)19L, (long)key.get());
        inputData = "123456789\r\r\n";
        inputFile = this.createInputFile(conf, inputData);
        split = new FileSplit(inputFile, 0L, 12L, (String[])null);
        reader = new LineRecordReader(null);
        reader.initialize((InputSplit)split, (TaskAttemptContext)context);
        reader.nextKeyValue();
        key = reader.getCurrentKey();
        value = reader.getCurrentValue();
        Assert.assertEquals((long)9L, (long)value.getLength());
        Assert.assertEquals((long)0L, (long)key.get());
        reader.nextKeyValue();
        Assert.assertEquals((long)0L, (long)value.getLength());
        Assert.assertEquals((long)10L, (long)key.get());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        Assert.assertEquals((long)12L, (long)key.get());
    }

    @Test
    public void testBzipWithMultibyteDelimiter() throws IOException {
        String testFileName = "compressedMultibyteDelimiter.txt.bz2";
        int firstSplitLength = 100;
        URL testFileUrl = this.getClass().getClassLoader().getResource(testFileName);
        Assert.assertNotNull((String)("Cannot find " + testFileName), (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        long testFileSize = testFile.length();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        Assert.assertTrue((String)"Split size is smaller than header length", (firstSplitLength > 9 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Split size is larger than compressed file size " + testFilePath), (testFileSize > (long)firstSplitLength ? 1 : 0) != 0);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        String delimiter = "<E-LINE>\r\r\n";
        conf.set("textinputformat.record.delimiter", delimiter);
        this.testSplitRecordsForFile(conf, firstSplitLength, testFileSize, testFilePath);
    }
}

