/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobSubmissionFiles {
    private static final String USER_1 = "user1@HADOOP.APACHE.ORG";
    private static final String USER_1_SHORT_NAME = "user1";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2", "group3"};

    @Test
    public void testGetStagingDirWhenFullFileOwnerNameAndFullUserName() throws IOException, InterruptedException {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Configuration conf = new Configuration();
        Path stagingPath = (Path)Mockito.mock(Path.class);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)USER_1, (String[])GROUP_NAMES);
        Assert.assertEquals((Object)USER_1, (Object)user.getUserName());
        FileSystemTestHelper.MockFileSystem fs = new FileSystemTestHelper.MockFileSystem();
        Mockito.when((Object)cluster.getStagingAreaDir()).thenReturn((Object)stagingPath);
        Mockito.when((Object)stagingPath.getFileSystem(conf)).thenReturn((Object)fs);
        String stagingDirOwner = USER_1.toLowerCase();
        FileStatus fileStatus = new FileStatus(1L, true, 1, 1L, 100L, 100L, FsPermission.getDefault(), stagingDirOwner, stagingDirOwner, stagingPath);
        Mockito.when((Object)fs.getFileStatus(stagingPath)).thenReturn((Object)fileStatus);
        Assert.assertEquals((Object)stagingPath, (Object)JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)conf, (UserGroupInformation)user));
        stagingDirOwner = USER_1;
        fileStatus = new FileStatus(1L, true, 1, 1L, 100L, 100L, FsPermission.getDefault(), stagingDirOwner, stagingDirOwner, stagingPath);
        Mockito.when((Object)fs.getFileStatus(stagingPath)).thenReturn((Object)fileStatus);
        Assert.assertEquals((Object)stagingPath, (Object)JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)conf, (UserGroupInformation)user));
    }

    @Test(expected=IOException.class)
    public void testGetStagingWhenFileOwnerNameAndCurrentUserNameDoesNotMatch() throws IOException, InterruptedException {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Configuration conf = new Configuration();
        String stagingDirOwner = "someuser";
        Path stagingPath = (Path)Mockito.mock(Path.class);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)USER_1, (String[])GROUP_NAMES);
        Assert.assertEquals((Object)USER_1, (Object)user.getUserName());
        FileSystemTestHelper.MockFileSystem fs = new FileSystemTestHelper.MockFileSystem();
        FileStatus fileStatus = new FileStatus(1L, true, 1, 1L, 100L, 100L, FsPermission.getDefault(), stagingDirOwner, stagingDirOwner, stagingPath);
        Mockito.when((Object)stagingPath.getFileSystem(conf)).thenReturn((Object)fs);
        Mockito.when((Object)fs.getFileStatus(stagingPath)).thenReturn((Object)fileStatus);
        Mockito.when((Object)cluster.getStagingAreaDir()).thenReturn((Object)stagingPath);
        Assert.assertEquals((Object)stagingPath, (Object)JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)conf, (UserGroupInformation)user));
    }

    @Test
    public void testGetStagingDirWhenShortFileOwnerNameAndFullUserName() throws IOException, InterruptedException {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Configuration conf = new Configuration();
        String stagingDirOwner = USER_1_SHORT_NAME;
        Path stagingPath = (Path)Mockito.mock(Path.class);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)USER_1, (String[])GROUP_NAMES);
        Assert.assertEquals((Object)USER_1, (Object)user.getUserName());
        FileSystemTestHelper.MockFileSystem fs = new FileSystemTestHelper.MockFileSystem();
        FileStatus fileStatus = new FileStatus(1L, true, 1, 1L, 100L, 100L, FsPermission.getDefault(), stagingDirOwner, stagingDirOwner, stagingPath);
        Mockito.when((Object)stagingPath.getFileSystem(conf)).thenReturn((Object)fs);
        Mockito.when((Object)fs.getFileStatus(stagingPath)).thenReturn((Object)fileStatus);
        Mockito.when((Object)cluster.getStagingAreaDir()).thenReturn((Object)stagingPath);
        Assert.assertEquals((Object)stagingPath, (Object)JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)conf, (UserGroupInformation)user));
    }

    @Test
    public void testGetStagingDirWhenShortFileOwnerNameAndShortUserName() throws IOException, InterruptedException {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Configuration conf = new Configuration();
        String stagingDirOwner = USER_1_SHORT_NAME;
        Path stagingPath = (Path)Mockito.mock(Path.class);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)USER_1_SHORT_NAME, (String[])GROUP_NAMES);
        Assert.assertEquals((Object)USER_1_SHORT_NAME, (Object)user.getUserName());
        FileSystemTestHelper.MockFileSystem fs = new FileSystemTestHelper.MockFileSystem();
        FileStatus fileStatus = new FileStatus(1L, true, 1, 1L, 100L, 100L, FsPermission.getDefault(), stagingDirOwner, stagingDirOwner, stagingPath);
        Mockito.when((Object)stagingPath.getFileSystem(conf)).thenReturn((Object)fs);
        Mockito.when((Object)fs.getFileStatus(stagingPath)).thenReturn((Object)fileStatus);
        Mockito.when((Object)cluster.getStagingAreaDir()).thenReturn((Object)stagingPath);
        Assert.assertEquals((Object)stagingPath, (Object)JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)conf, (UserGroupInformation)user));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirPermission() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.permissions.umask-mode", "700");
        MiniDFSCluster dfsCluster = null;
        try {
            dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem fs = dfsCluster.getFileSystem();
            UserGroupInformation user = UserGroupInformation.createUserForTesting((String)USER_1_SHORT_NAME, (String[])GROUP_NAMES);
            Path stagingPath = new Path(fs.getUri().toString() + "/testDirPermission");
            Mockito.when((Object)cluster.getStagingAreaDir()).thenReturn((Object)stagingPath);
            Path res = JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)conf, (UserGroupInformation)user);
            Assert.assertEquals((Object)new FsPermission(448), (Object)fs.getFileStatus(res).getPermission());
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
        }
    }
}

