/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.junit.Assert;
import org.junit.Test;

public class TestSkipBadRecords {
    @Test(timeout=5000L)
    public void testSkipBadRecords() {
        Configuration conf = new Configuration();
        Assert.assertEquals((long)2L, (long)SkipBadRecords.getAttemptsToStartSkipping((Configuration)conf));
        Assert.assertTrue((boolean)SkipBadRecords.getAutoIncrMapperProcCount((Configuration)conf));
        Assert.assertTrue((boolean)SkipBadRecords.getAutoIncrReducerProcCount((Configuration)conf));
        Assert.assertEquals((long)0L, (long)SkipBadRecords.getMapperMaxSkipRecords((Configuration)conf));
        Assert.assertEquals((float)0.0f, (float)SkipBadRecords.getReducerMaxSkipGroups((Configuration)conf), (float)0.0f);
        Assert.assertNull((Object)SkipBadRecords.getSkipOutputPath((Configuration)conf));
        SkipBadRecords.setAttemptsToStartSkipping((Configuration)conf, (int)5);
        SkipBadRecords.setAutoIncrMapperProcCount((Configuration)conf, (boolean)false);
        SkipBadRecords.setAutoIncrReducerProcCount((Configuration)conf, (boolean)false);
        SkipBadRecords.setMapperMaxSkipRecords((Configuration)conf, (long)6L);
        SkipBadRecords.setReducerMaxSkipGroups((Configuration)conf, (long)7L);
        JobConf jc = new JobConf();
        SkipBadRecords.setSkipOutputPath((JobConf)jc, (Path)new Path("test"));
        Assert.assertEquals((long)5L, (long)SkipBadRecords.getAttemptsToStartSkipping((Configuration)conf));
        Assert.assertFalse((boolean)SkipBadRecords.getAutoIncrMapperProcCount((Configuration)conf));
        Assert.assertFalse((boolean)SkipBadRecords.getAutoIncrReducerProcCount((Configuration)conf));
        Assert.assertEquals((long)6L, (long)SkipBadRecords.getMapperMaxSkipRecords((Configuration)conf));
        Assert.assertEquals((float)7.0f, (float)SkipBadRecords.getReducerMaxSkipGroups((Configuration)conf), (float)0.0f);
        Assert.assertEquals((Object)"test", (Object)SkipBadRecords.getSkipOutputPath((Configuration)jc).toString());
    }
}

