/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestOldMethodsJobID {
    @Test(timeout=5000L)
    public void testDepricatedMethods() throws IOException {
        JobID jid = new JobID();
        TaskID test = new TaskID((org.apache.hadoop.mapreduce.JobID)jid, true, 1);
        Assertions.assertThat((Comparable)test.getTaskType()).isEqualTo((Object)TaskType.MAP);
        test = new TaskID((org.apache.hadoop.mapreduce.JobID)jid, false, 1);
        Assertions.assertThat((Comparable)test.getTaskType()).isEqualTo((Object)TaskType.REDUCE);
        test = new TaskID("001", 1, false, 1);
        Assertions.assertThat((Comparable)test.getTaskType()).isEqualTo((Object)TaskType.REDUCE);
        test = new TaskID("001", 1, true, 1);
        Assertions.assertThat((Comparable)test.getTaskType()).isEqualTo((Object)TaskType.MAP);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        test.write((DataOutput)new DataOutputStream(out));
        TaskID ti = TaskID.read((DataInput)new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
        Assert.assertEquals((Object)ti.toString(), (Object)test.toString());
        Assert.assertEquals((Object)"task_001_0001_m_000002", (Object)TaskID.getTaskIDsPattern((String)"001", (Integer)1, (Boolean)true, (Integer)2));
        Assert.assertEquals((Object)"task_003_0001_m_000004", (Object)TaskID.getTaskIDsPattern((String)"003", (Integer)1, (TaskType)TaskType.MAP, (Integer)4));
        Assert.assertEquals((Object)"003_0001_m_000004", (Object)TaskID.getTaskIDsPatternWOPrefix((String)"003", (Integer)1, (TaskType)TaskType.MAP, (Integer)4).toString());
    }

    @Test(timeout=5000L)
    public void testJobID() throws IOException {
        JobID jid = new JobID("001", 2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        jid.write((DataOutput)new DataOutputStream(out));
        Assert.assertEquals((Object)jid, (Object)JobID.read((DataInput)new DataInputStream(new ByteArrayInputStream(out.toByteArray()))));
        Assert.assertEquals((Object)"job_001_0001", (Object)JobID.getJobIDsPattern((String)"001", (Integer)1));
    }

    @Test(timeout=5000L)
    public void testTaskCompletionEvent() {
        TaskAttemptID taid = new TaskAttemptID("001", 1, TaskType.REDUCE, 2, 3);
        TaskCompletionEvent template = new TaskCompletionEvent(12, taid, 13, true, TaskCompletionEvent.Status.SUCCEEDED, "httptracker");
        TaskCompletionEvent testEl = TaskCompletionEvent.downgrade((org.apache.hadoop.mapreduce.TaskCompletionEvent)template);
        testEl.setTaskAttemptId(taid);
        testEl.setTaskTrackerHttp("httpTracker");
        testEl.setTaskId("attempt_001_0001_m_000002_04");
        Assert.assertEquals((Object)"attempt_001_0001_m_000002_4", (Object)testEl.getTaskId());
        testEl.setTaskStatus(TaskCompletionEvent.Status.OBSOLETE);
        Assert.assertEquals((Object)TaskCompletionEvent.Status.OBSOLETE.toString(), (Object)testEl.getStatus().toString());
        testEl.setTaskRunTime(20);
        Assertions.assertThat((int)testEl.getTaskRunTime()).isEqualTo(20);
        testEl.setEventId(16);
        Assertions.assertThat((int)testEl.getEventId()).isEqualTo(16);
    }

    @Test(timeout=5000L)
    public void testJobProfile() throws IOException {
        JobProfile profile = new JobProfile("user", "job_001_03", "jobFile", "uri", "name");
        Assert.assertEquals((Object)"job_001_0003", (Object)profile.getJobId());
        Assert.assertEquals((Object)"default", (Object)profile.getQueueName());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        profile.write((DataOutput)new DataOutputStream(out));
        JobProfile profile2 = new JobProfile();
        profile2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
        Assert.assertEquals((Object)profile2.name, (Object)profile.name);
        Assert.assertEquals((Object)profile2.jobFile, (Object)profile.jobFile);
        Assert.assertEquals((Object)profile2.queueName, (Object)profile.queueName);
        Assert.assertEquals((Object)profile2.url, (Object)profile.url);
        Assert.assertEquals((Object)profile2.user, (Object)profile.user);
    }

    @Test(timeout=5000L)
    public void testTaskAttemptID() {
        TaskAttemptID task = new TaskAttemptID("001", 2, true, 3, 4);
        Assert.assertEquals((Object)"attempt_001_0002_m_000003_4", (Object)TaskAttemptID.getTaskAttemptIDsPattern((String)"001", (Integer)2, (Boolean)true, (Integer)3, (Integer)4));
        Assert.assertEquals((Object)"task_001_0002_m_000003", (Object)task.getTaskID().toString());
        Assert.assertEquals((Object)"attempt_001_0001_r_000002_3", (Object)TaskAttemptID.getTaskAttemptIDsPattern((String)"001", (Integer)1, (TaskType)TaskType.REDUCE, (Integer)2, (Integer)3));
        Assert.assertEquals((Object)"001_0001_m_000001_2", (Object)TaskAttemptID.getTaskAttemptIDsPatternWOPrefix((String)"001", (Integer)1, (TaskType)TaskType.MAP, (Integer)1, (Integer)2).toString());
    }

    @Test(timeout=5000L)
    public void testReporter() {
        Reporter nullReporter = Reporter.NULL;
        Assert.assertNull((Object)nullReporter.getCounter(null));
        Assert.assertNull((Object)nullReporter.getCounter("group", "name"));
        try {
            Assert.assertNull((Object)nullReporter.getInputSplit());
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"NULL reporter has no input", (Object)e.getMessage());
        }
        Assert.assertEquals((double)0.0, (double)nullReporter.getProgress(), (double)0.01);
    }
}

