/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestJobConf {
    @Test(timeout=5000L)
    public void testJobConf() {
        JobConf conf = new JobConf();
        Pattern pattern = conf.getJarUnpackPattern();
        Assert.assertEquals((Object)Pattern.compile("(?:classes/|lib/).*").toString(), (Object)pattern.toString());
        Assert.assertFalse((boolean)conf.getKeepFailedTaskFiles());
        conf.setKeepFailedTaskFiles(true);
        Assert.assertTrue((boolean)conf.getKeepFailedTaskFiles());
        Assert.assertNull((Object)conf.getKeepTaskFilesPattern());
        conf.setKeepTaskFilesPattern("123454");
        Assert.assertEquals((Object)"123454", (Object)conf.getKeepTaskFilesPattern());
        Assert.assertNotNull((Object)conf.getWorkingDirectory());
        conf.setWorkingDirectory(new Path("test"));
        Assert.assertTrue((boolean)conf.getWorkingDirectory().toString().endsWith("test"));
        Assert.assertEquals((long)1L, (long)conf.getNumTasksToExecutePerJvm());
        Assert.assertNull((Object)conf.getKeyFieldComparatorOption());
        conf.setKeyFieldComparatorOptions("keySpec");
        Assert.assertEquals((Object)"keySpec", (Object)conf.getKeyFieldComparatorOption());
        Assert.assertFalse((boolean)conf.getUseNewReducer());
        conf.setUseNewReducer(true);
        Assert.assertTrue((boolean)conf.getUseNewReducer());
        Assert.assertTrue((boolean)conf.getMapSpeculativeExecution());
        Assert.assertTrue((boolean)conf.getReduceSpeculativeExecution());
        Assert.assertTrue((boolean)conf.getSpeculativeExecution());
        conf.setReduceSpeculativeExecution(false);
        Assert.assertTrue((boolean)conf.getSpeculativeExecution());
        conf.setMapSpeculativeExecution(false);
        Assert.assertFalse((boolean)conf.getSpeculativeExecution());
        Assert.assertFalse((boolean)conf.getMapSpeculativeExecution());
        Assert.assertFalse((boolean)conf.getReduceSpeculativeExecution());
        conf.setSessionId("ses");
        Assert.assertEquals((Object)"ses", (Object)conf.getSessionId());
        Assert.assertEquals((long)3L, (long)conf.getMaxTaskFailuresPerTracker());
        conf.setMaxTaskFailuresPerTracker(2);
        Assert.assertEquals((long)2L, (long)conf.getMaxTaskFailuresPerTracker());
        Assert.assertEquals((long)0L, (long)conf.getMaxMapTaskFailuresPercent());
        conf.setMaxMapTaskFailuresPercent(50);
        Assert.assertEquals((long)50L, (long)conf.getMaxMapTaskFailuresPercent());
        Assert.assertEquals((long)0L, (long)conf.getMaxReduceTaskFailuresPercent());
        conf.setMaxReduceTaskFailuresPercent(70);
        Assert.assertEquals((long)70L, (long)conf.getMaxReduceTaskFailuresPercent());
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.DEFAULT);
        conf.setJobPriority(JobPriority.HIGH);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.HIGH);
        Assert.assertNull((Object)conf.getJobSubmitHostName());
        conf.setJobSubmitHostName("hostname");
        Assert.assertEquals((Object)"hostname", (Object)conf.getJobSubmitHostName());
        Assert.assertNull((Object)conf.getJobSubmitHostAddress());
        conf.setJobSubmitHostAddress("ww");
        Assert.assertEquals((Object)"ww", (Object)conf.getJobSubmitHostAddress());
        Assert.assertFalse((boolean)conf.getProfileEnabled());
        conf.setProfileEnabled(true);
        Assert.assertTrue((boolean)conf.getProfileEnabled());
        Assert.assertEquals((Object)conf.getProfileTaskRange(true).toString(), (Object)"0-2");
        Assert.assertEquals((Object)conf.getProfileTaskRange(false).toString(), (Object)"0-2");
        conf.setProfileTaskRange(true, "0-3");
        Assert.assertEquals((Object)conf.getProfileTaskRange(false).toString(), (Object)"0-2");
        Assert.assertEquals((Object)conf.getProfileTaskRange(true).toString(), (Object)"0-3");
        Assert.assertNull((Object)conf.getMapDebugScript());
        conf.setMapDebugScript("mDbgScript");
        Assert.assertEquals((Object)"mDbgScript", (Object)conf.getMapDebugScript());
        Assert.assertNull((Object)conf.getReduceDebugScript());
        conf.setReduceDebugScript("rDbgScript");
        Assert.assertEquals((Object)"rDbgScript", (Object)conf.getReduceDebugScript());
        Assert.assertNull((Object)conf.getJobLocalDir());
        Assert.assertEquals((Object)"default", (Object)conf.getQueueName());
        conf.setQueueName("qname");
        Assert.assertEquals((Object)"qname", (Object)conf.getQueueName());
        conf.setMemoryForMapTask(100000L);
        Assert.assertEquals((long)100000L, (long)conf.getMemoryForMapTask());
        conf.setMemoryForReduceTask(1000000L);
        Assert.assertEquals((long)1000000L, (long)conf.getMemoryForReduceTask());
        Assert.assertEquals((long)-1L, (long)conf.getMaxPhysicalMemoryForTask());
        Assert.assertEquals((Object)"The variable key is no longer used.", (Object)JobConf.deprecatedString((String)"key"));
        Assert.assertNull((String)"mapreduce.map.java.opts should not be set by default", (Object)conf.get("mapreduce.map.java.opts"));
        Assert.assertNull((String)"mapreduce.reduce.java.opts should not be set by default", (Object)conf.get("mapreduce.reduce.java.opts"));
    }

    @Test(timeout=10000L)
    public void testDeprecatedPropertyNameForTaskVmem() {
        JobConf configuration = new JobConf();
        configuration.setLong("mapred.job.map.memory.mb", 1024L);
        configuration.setLong("mapred.job.reduce.memory.mb", 1024L);
        Assert.assertEquals((long)1024L, (long)configuration.getMemoryForMapTask());
        Assert.assertEquals((long)1024L, (long)configuration.getMemoryForReduceTask());
        configuration.setLong("mapreduce.map.memory.mb", 1025L);
        configuration.setLong("mapreduce.reduce.memory.mb", 1025L);
        Assert.assertEquals((long)1025L, (long)configuration.getMemoryForMapTask());
        Assert.assertEquals((long)1025L, (long)configuration.getMemoryForReduceTask());
        configuration.setMemoryForMapTask(2048L);
        configuration.setMemoryForReduceTask(2048L);
        Assert.assertEquals((long)2048L, (long)configuration.getLong("mapred.job.map.memory.mb", -1L));
        Assert.assertEquals((long)2048L, (long)configuration.getLong("mapred.job.reduce.memory.mb", -1L));
        Assert.assertEquals((long)2048L, (long)configuration.getLong("mapreduce.map.memory.mb", -1L));
        Assert.assertEquals((long)2048L, (long)configuration.getLong("mapreduce.reduce.memory.mb", -1L));
    }

    @Test
    public void testProfileParamsDefaults() {
        JobConf configuration = new JobConf();
        String result = configuration.getProfileParams();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("file=%s"));
        Assert.assertTrue((boolean)result.startsWith("-agentlib:hprof"));
    }

    @Test
    public void testProfileParamsSetter() {
        JobConf configuration = new JobConf();
        configuration.setProfileParams("test");
        Assert.assertEquals((Object)"test", (Object)configuration.get("mapreduce.task.profile.params"));
    }

    @Test
    public void testProfileParamsGetter() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.task.profile.params", "test");
        Assert.assertEquals((Object)"test", (Object)configuration.getProfileParams());
    }

    @Test
    public void testMemoryConfigForMapOrReduceTask() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(300));
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(300L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(300L);
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(300));
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", "-1");
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(400));
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(300L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(400L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", "-1");
        configuration.set("mapreduce.reduce.memory.mb", "-1");
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(-1));
        configuration.set("mapreduce.map.memory.mb", "-1");
        configuration.set("mapreduce.reduce.memory.mb", "-1");
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(1024L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(1024L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x200000));
        configuration.set("mapreduce.map.memory.mb", "3");
        configuration.set("mapreduce.reduce.memory.mb", "3");
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
    }

    @Test
    public void testNegativeValueForTaskVmem() {
        JobConf configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", "-3");
        Assert.assertEquals((long)1024L, (long)configuration.getMemoryForMapTask());
        Assert.assertEquals((long)1024L, (long)configuration.getMemoryForReduceTask());
        configuration.set("mapreduce.map.memory.mb", "4");
        configuration.set("mapreduce.reduce.memory.mb", "5");
        Assert.assertEquals((long)4L, (long)configuration.getMemoryForMapTask());
        Assert.assertEquals((long)5L, (long)configuration.getMemoryForReduceTask());
    }

    @Test
    public void testNegativeValuesForMemoryParams() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", "-5");
        configuration.set("mapreduce.reduce.memory.mb", "-6");
        Assert.assertEquals((long)1024L, (long)configuration.getMemoryForMapTask());
        Assert.assertEquals((long)1024L, (long)configuration.getMemoryForReduceTask());
    }

    @Test
    public void testMaxVirtualMemoryForTask() {
        JobConf configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(-1));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x40000000L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(-1));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(200));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x40000000L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(-1));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(-1));
        configuration.set("mapred.task.maxvmem", String.valueOf(0x100000));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x100000L);
        configuration = new JobConf();
        configuration.set("mapred.task.maxvmem", String.valueOf(0x100000));
        Assertions.assertThat((long)configuration.getMaxVirtualMemoryForTask()).isEqualTo(0x100000L);
        configuration = new JobConf();
        configuration.setMaxVirtualMemoryForTask(0x200000L);
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
        configuration = new JobConf();
        configuration.set("mapreduce.map.memory.mb", String.valueOf(300));
        configuration.set("mapreduce.reduce.memory.mb", String.valueOf(400));
        configuration.setMaxVirtualMemoryForTask(0x200000L);
        Assertions.assertThat((long)configuration.getMemoryForMapTask()).isEqualTo(2L);
        Assertions.assertThat((long)configuration.getMemoryForReduceTask()).isEqualTo(2L);
    }

    @Test
    public void testMaxTaskFailuresPerTracker() {
        JobConf jobConf = new JobConf(true);
        Assert.assertTrue((String)"By default JobContext.MAX_TASK_FAILURES_PER_TRACKER was not less than JobContext.MAP_MAX_ATTEMPTS and REDUCE_MAX_ATTEMPTS", (jobConf.getMaxTaskFailuresPerTracker() < jobConf.getMaxMapAttempts() && jobConf.getMaxTaskFailuresPerTracker() < jobConf.getMaxReduceAttempts() ? 1 : 0) != 0);
    }

    @Test
    public void testParseMaximumHeapSizeMB() {
        Assert.assertEquals((long)4096L, (long)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4294967296"));
        Assert.assertEquals((long)4096L, (long)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4194304k"));
        Assert.assertEquals((long)4096L, (long)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4096m"));
        Assert.assertEquals((long)4096L, (long)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4g"));
        Assert.assertEquals((long)-1L, (long)JobConf.parseMaximumHeapSizeMB((String)"-Xmx4?"));
        Assert.assertEquals((long)-1L, (long)JobConf.parseMaximumHeapSizeMB((String)""));
    }

    @Test
    public void testJobPriorityConf() {
        JobConf conf = new JobConf();
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.DEFAULT);
        Assert.assertEquals((long)0L, (long)conf.getJobPriorityAsInteger());
        conf.setJobPriority(JobPriority.LOW);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.LOW);
        Assert.assertEquals((long)2L, (long)conf.getJobPriorityAsInteger());
        conf.setJobPriority(JobPriority.VERY_HIGH);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.VERY_HIGH);
        Assert.assertEquals((long)5L, (long)conf.getJobPriorityAsInteger());
        conf.setJobPriorityAsInteger(3);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.NORMAL);
        Assert.assertEquals((long)3L, (long)conf.getJobPriorityAsInteger());
        conf.setJobPriorityAsInteger(4);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.HIGH);
        Assert.assertEquals((long)4L, (long)conf.getJobPriorityAsInteger());
        conf.setJobPriorityAsInteger(57);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.UNDEFINED_PRIORITY);
        Assert.assertEquals((long)57L, (long)conf.getJobPriorityAsInteger());
        conf.setJobPriority(JobPriority.UNDEFINED_PRIORITY);
        Assertions.assertThat((Comparable)conf.getJobPriority()).isEqualTo((Object)JobPriority.UNDEFINED_PRIORITY);
        Assert.assertEquals((long)0L, (long)conf.getJobPriorityAsInteger());
    }
}

